/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public abstract class ProjectTableScanRule
extends RelOptRule {
    @Deprecated
    public static final Predicate<TableScan> PREDICATE = ProjectTableScanRule::test;
    @Deprecated
    public static final ProjectTableScanRule INSTANCE = CoreRules.PROJECT_TABLE_SCAN;
    @Deprecated
    public static final ProjectTableScanRule INTERPRETER = CoreRules.PROJECT_INTERPRETER_TABLE_SCAN;

    public ProjectTableScanRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    protected static boolean test(TableScan scan) {
        RelOptTable table = scan.getTable();
        return table.unwrap(ProjectableFilterableTable.class) != null;
    }

    protected void apply(RelOptRuleCall call, Project project, TableScan scan) {
        List<Integer> projectsPushDown;
        ImmutableList<RexNode> filtersPushDown;
        RelOptTable table = scan.getTable();
        assert (table.unwrap(ProjectableFilterableTable.class) != null);
        final ArrayList<Integer> selectedColumns = new ArrayList<Integer>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                if (!selectedColumns.contains(inputRef.getIndex())) {
                    selectedColumns.add(inputRef.getIndex());
                }
                return null;
            }
        };
        visitor.visitEach(project.getProjects());
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filtersPushDown = bindableScan.filters;
            projectsPushDown = selectedColumns.stream().map(col -> bindableScan.projects.get((int)col)).collect(Collectors.toList());
        } else {
            filtersPushDown = ImmutableList.of();
            projectsPushDown = selectedColumns;
        }
        Bindables.BindableTableScan newScan = Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), filtersPushDown, projectsPushDown);
        Mapping mapping = Mappings.target(selectedColumns, scan.getRowType().getFieldCount());
        List<RexNode> newProjectRexNodes = RexUtil.apply((Mappings.TargetMapping)mapping, project.getProjects());
        if (RexUtil.isIdentity(newProjectRexNodes, newScan.getRowType())) {
            call.transformTo(newScan);
        } else {
            call.transformTo(call.builder().push(newScan).project(newProjectRexNodes).build());
        }
    }
}

