/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;

public class ProjectJoinRemoveRule
extends RelOptRule
implements SubstitutionRule {
    @Deprecated
    public static final ProjectJoinRemoveRule INSTANCE = CoreRules.PROJECT_JOIN_REMOVE;

    public ProjectJoinRemoveRule(Class<? extends Project> projectClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        super(ProjectJoinRemoveRule.operand(projectClass, ProjectJoinRemoveRule.operandJ(joinClass, null, join -> join.getJoinType() == JoinRelType.LEFT || join.getJoinType() == JoinRelType.RIGHT, ProjectJoinRemoveRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project node;
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        boolean isLeftJoin = join.getJoinType() == JoinRelType.LEFT;
        int lower = isLeftJoin ? join.getLeft().getRowType().getFieldCount() - 1 : 0;
        int upper = isLeftJoin ? join.getRowType().getFieldCount() : join.getLeft().getRowType().getFieldCount();
        for (RexNode expr2 : project.getProjects()) {
            if (!RelOptUtil.InputFinder.bits(expr2).asList().stream().anyMatch(i -> i >= lower && i < upper)) continue;
            return;
        }
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(join.getLeft(), join.getRight(), join.getCondition(), leftKeys, rightKeys, new ArrayList<Boolean>());
        ArrayList<Integer> joinKeys = isLeftJoin ? rightKeys : leftKeys;
        ImmutableBitSet.Builder columns = ImmutableBitSet.builder();
        joinKeys.forEach(key -> columns.set((int)key));
        RelMetadataQuery mq = call.getMetadataQuery();
        if (!mq.areColumnsUnique(isLeftJoin ? join.getRight() : join.getLeft(), columns.build()).booleanValue()) {
            return;
        }
        if (isLeftJoin) {
            node = project.copy(project.getTraitSet(), join.getLeft(), project.getProjects(), project.getRowType());
        } else {
            int offset = join.getLeft().getRowType().getFieldCount();
            List<RexNode> newExprs = project.getProjects().stream().map(expr -> RexUtil.shift(expr, -offset)).collect(Collectors.toList());
            node = project.copy(project.getTraitSet(), join.getRight(), newExprs, project.getRowType());
        }
        call.transformTo(node);
    }
}

