/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;

public class ProjectFilterTransposeRule
extends RelOptRule
implements TransformationRule {
    @Deprecated
    public static final ProjectFilterTransposeRule INSTANCE = CoreRules.PROJECT_FILTER_TRANSPOSE;
    @Deprecated
    public static final ProjectFilterTransposeRule EXPRESSION_INSTANCE = CoreRules.PROJECT_FILTER_TRANSPOSE_WHOLE_EXPRESSIONS;
    @Deprecated
    public static final ProjectFilterTransposeRule PROJECT_EXPRESSION_INSTANCE = CoreRules.PROJECT_FILTER_TRANSPOSE_WHOLE_PROJECT_EXPRESSIONS;
    private final PushProjector.ExprCondition preserveExprCondition;
    private final boolean wholeProject;
    private final boolean wholeFilter;

    public ProjectFilterTransposeRule(Class<? extends Project> projectClass, Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory, PushProjector.ExprCondition preserveExprCondition, boolean wholeProject, boolean wholeFilter) {
        this(ProjectFilterTransposeRule.operand(projectClass, ProjectFilterTransposeRule.operand(filterClass, ProjectFilterTransposeRule.any()), new RelOptRuleOperand[0]), preserveExprCondition, wholeProject, wholeFilter, relBuilderFactory);
    }

    @Deprecated
    public ProjectFilterTransposeRule(Class<? extends Project> projectClass, Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory, PushProjector.ExprCondition preserveExprCondition) {
        this(projectClass, filterClass, relBuilderFactory, preserveExprCondition, false, false);
    }

    protected ProjectFilterTransposeRule(RelOptRuleOperand operand, PushProjector.ExprCondition preserveExprCondition, boolean wholeProject, boolean wholeFilter, RelBuilderFactory relBuilderFactory) {
        super(operand, relBuilderFactory, null);
        this.preserveExprCondition = preserveExprCondition;
        this.wholeProject = wholeProject;
        this.wholeFilter = wholeFilter;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode topProject;
        Filter filter;
        Project origProject;
        if (call.rels.length >= 2) {
            origProject = (Project)call.rel(0);
            filter = (Filter)call.rel(1);
        } else {
            origProject = null;
            filter = (Filter)call.rel(0);
        }
        RelNode input = filter.getInput();
        RexNode origFilter = filter.getCondition();
        if (origProject != null && RexOver.containsOver(origProject.getProjects(), null)) {
            return;
        }
        if (origProject != null && origProject.getRowType().isStruct() && origProject.getRowType().getFieldList().stream().anyMatch(RelDataTypeField::isDynamicStar)) {
            return;
        }
        RelBuilder builder = call.builder();
        if (origProject != null && (this.wholeProject || this.wholeFilter)) {
            builder.push(input);
            LinkedHashSet<RexNode> set = new LinkedHashSet<RexNode>();
            RelOptUtil.InputFinder refCollector = new RelOptUtil.InputFinder();
            if (this.wholeFilter) {
                set.add(filter.getCondition());
            } else {
                filter.getCondition().accept(refCollector);
            }
            if (this.wholeProject) {
                set.addAll(origProject.getProjects());
            } else {
                refCollector.visitEach(origProject.getProjects());
            }
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            ImmutableBitSet refs = refCollector.build();
            for (RexNode field : builder.fields()) {
                if (!refs.get(((RexInputRef)field).getIndex()) && !set.contains(field)) continue;
                list.add(field);
            }
            set.removeAll(list);
            list.addAll(set);
            builder.project(list);
            Replacer replacer = new Replacer(list, builder);
            builder.filter(replacer.visit(filter.getCondition()));
            builder.project(replacer.visitList(origProject.getProjects()), origProject.getRowType().getFieldNames());
            topProject = builder.build();
        } else {
            PushProjector pushProjector = new PushProjector(origProject, origFilter, input, this.preserveExprCondition, builder);
            topProject = pushProjector.convertProject(null);
        }
        if (topProject != null) {
            call.transformTo(topProject);
        }
    }

    private static class Replacer
    extends RexShuttle {
        final ImmutableMap<RexNode, Integer> map;
        final RelBuilder relBuilder;

        Replacer(Iterable<? extends RexNode> exprs, RelBuilder relBuilder) {
            this.relBuilder = relBuilder;
            ImmutableMap.Builder b = ImmutableMap.builder();
            int i = 0;
            for (RexNode rexNode : exprs) {
                b.put((Object)rexNode, (Object)i++);
            }
            this.map = b.build();
        }

        RexNode visit(RexNode e) {
            Integer i = (Integer)this.map.get((Object)e);
            if (i != null) {
                return this.relBuilder.field(i);
            }
            return e.accept(this);
        }

        @Override
        public void visitList(Iterable<? extends RexNode> exprs, List<RexNode> out) {
            for (RexNode rexNode : exprs) {
                out.add(this.visit(rexNode));
            }
        }

        @Override
        protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean[] update) {
            ImmutableList.Builder clonedOperands = ImmutableList.builder();
            for (RexNode rexNode : exprs) {
                RexNode clonedOperand = this.visit(rexNode);
                if (clonedOperand != rexNode && update != null) {
                    update[0] = true;
                }
                clonedOperands.add((Object)clonedOperand);
            }
            return clonedOperands.build();
        }
    }
}

