/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptMaterializations;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.rules.materialize.MaterializedViewRules;
import org.apache.calcite.tools.RelBuilderFactory;

public class MaterializedViewFilterScanRule
extends RelOptRule
implements TransformationRule {
    @Deprecated
    public static final MaterializedViewFilterScanRule INSTANCE = MaterializedViewRules.FILTER_SCAN;
    private final HepProgram program = new HepProgramBuilder().addRuleInstance(CoreRules.FILTER_PROJECT_TRANSPOSE).addRuleInstance(CoreRules.PROJECT_MERGE).build();

    public MaterializedViewFilterScanRule(RelBuilderFactory relBuilderFactory) {
        super(MaterializedViewFilterScanRule.operand(Filter.class, MaterializedViewFilterScanRule.operand(TableScan.class, null, MaterializedViewFilterScanRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewFilterScanRule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        this.apply(call, filter, scan);
    }

    protected void apply(RelOptRuleCall call, Filter filter, TableScan scan) {
        RelOptPlanner planner = call.getPlanner();
        List<RelOptMaterialization> materializations = planner.getMaterializations();
        if (!materializations.isEmpty()) {
            RelNode root = filter.copy(filter.getTraitSet(), Collections.singletonList(scan));
            List<RelOptMaterialization> applicableMaterializations = RelOptMaterializations.getApplicableMaterializations(root, materializations);
            for (RelOptMaterialization materialization : applicableMaterializations) {
                if (!RelOptUtil.areRowTypesEqual(scan.getRowType(), materialization.queryRel.getRowType(), false)) continue;
                RelNode target = materialization.queryRel;
                HepPlanner hepPlanner = new HepPlanner(this.program, planner.getContext());
                hepPlanner.setRoot(target);
                target = hepPlanner.findBestExp();
                List<RelNode> subs = new SubstitutionVisitor(target, root).go(materialization.tableRel);
                for (RelNode s : subs) {
                    call.transformTo(s);
                }
            }
        }
    }
}

