/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilderFactory;

public class JoinAddRedundantSemiJoinRule
extends RelOptRule
implements TransformationRule {
    @Deprecated
    public static final JoinAddRedundantSemiJoinRule INSTANCE = CoreRules.JOIN_ADD_REDUNDANT_SEMI_JOIN;

    public JoinAddRedundantSemiJoinRule(Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory) {
        super(JoinAddRedundantSemiJoinRule.operand(clazz, JoinAddRedundantSemiJoinRule.any()), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join origJoinRel = (Join)call.rel(0);
        if (origJoinRel.isSemiJoinDone()) {
            return;
        }
        if (origJoinRel.getJoinType() != JoinRelType.INNER) {
            return;
        }
        JoinInfo joinInfo = origJoinRel.analyzeCondition();
        if (joinInfo.leftKeys.size() == 0) {
            return;
        }
        LogicalJoin semiJoin = LogicalJoin.create(origJoinRel.getLeft(), origJoinRel.getRight(), (List<RelHint>)ImmutableList.of(), origJoinRel.getCondition(), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.SEMI);
        Join newJoinRel = origJoinRel.copy(origJoinRel.getTraitSet(), origJoinRel.getCondition(), semiJoin, origJoinRel.getRight(), JoinRelType.INNER, true);
        call.transformTo(newJoinRel);
    }
}

