/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;

public class FilterTableFunctionTransposeRule
extends RelOptRule
implements TransformationRule {
    @Deprecated
    public static final FilterTableFunctionTransposeRule INSTANCE = CoreRules.FILTER_TABLE_FUNCTION_TRANSPOSE;

    public FilterTableFunctionTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(FilterTableFunctionTransposeRule.operand(LogicalFilter.class, FilterTableFunctionTransposeRule.operand(LogicalTableFunctionScan.class, FilterTableFunctionTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        LogicalTableFunctionScan funcRel = (LogicalTableFunctionScan)call.rel(1);
        Set<RelColumnMapping> columnMappings = funcRel.getColumnMappings();
        if (columnMappings == null || columnMappings.isEmpty()) {
            return;
        }
        List<RelNode> funcInputs = funcRel.getInputs();
        if (funcInputs.size() != 1) {
            return;
        }
        if (funcRel.getRowType().getFieldCount() != funcInputs.get(0).getRowType().getFieldCount()) {
            return;
        }
        for (RelColumnMapping mapping : columnMappings) {
            if (mapping.iInputColumn != mapping.iOutputColumn) {
                return;
            }
            if (!mapping.derived) continue;
            return;
        }
        ArrayList<RelNode> newFuncInputs = new ArrayList<RelNode>();
        RelOptCluster cluster = funcRel.getCluster();
        RexNode condition = filter.getCondition();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = funcRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        for (RelNode funcInput : funcInputs) {
            RexNode newCondition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, funcInput.getRowType().getFieldList(), adjustments));
            newFuncInputs.add(LogicalFilter.create(funcInput, newCondition));
        }
        LogicalTableFunctionScan newFuncRel = LogicalTableFunctionScan.create(cluster, newFuncInputs, funcRel.getCall(), funcRel.getElementType(), funcRel.getRowType(), columnMappings);
        call.transformTo(newFuncRel);
    }
}

