/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Collections;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public class FilterProjectTransposeRule
extends RelOptRule
implements TransformationRule {
    @Deprecated
    public static final FilterProjectTransposeRule INSTANCE = CoreRules.FILTER_PROJECT_TRANSPOSE;
    private final boolean copyFilter;
    private final boolean copyProject;

    public FilterProjectTransposeRule(Class<? extends Filter> filterClass, Class<? extends Project> projectClass, boolean copyFilter, boolean copyProject, RelBuilderFactory relBuilderFactory) {
        this(filterClass, filter -> !RexUtil.containsCorrelation(filter.getCondition()), projectClass, project -> true, copyFilter, copyProject, relBuilderFactory);
    }

    public <F extends Filter, P extends Project> FilterProjectTransposeRule(Class<F> filterClass, Predicate<? super F> filterPredicate, Class<P> projectClass, Predicate<? super P> projectPredicate, boolean copyFilter, boolean copyProject, RelBuilderFactory relBuilderFactory) {
        this(FilterProjectTransposeRule.operandJ(filterClass, null, filterPredicate, FilterProjectTransposeRule.operandJ(projectClass, null, projectPredicate, FilterProjectTransposeRule.any()), new RelOptRuleOperand[0]), copyFilter, copyProject, relBuilderFactory);
    }

    @Deprecated
    public FilterProjectTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Project> projectClass, RelFactories.ProjectFactory projectFactory) {
        this(filterClass, filter -> !RexUtil.containsCorrelation(filter.getCondition()), projectClass, project -> true, filterFactory == null, projectFactory == null, RelBuilder.proto(filterFactory, projectFactory));
    }

    protected FilterProjectTransposeRule(RelOptRuleOperand operand, boolean copyFilter, boolean copyProject, RelBuilderFactory relBuilderFactory) {
        super(operand, relBuilderFactory, null);
        this.copyFilter = copyFilter;
        this.copyProject = copyProject;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode newFilterRel;
        Filter filter = (Filter)call.rel(0);
        Project project = (Project)call.rel(1);
        if (RexOver.containsOver(project.getProjects(), null)) {
            return;
        }
        RexNode newCondition = RelOptUtil.pushPastProject(filter.getCondition(), project);
        RelBuilder relBuilder = call.builder();
        if (this.copyFilter) {
            RelNode input = project.getInput();
            RelTraitSet traitSet = filter.getTraitSet().replaceIfs(RelCollationTraitDef.INSTANCE, () -> Collections.singletonList(input.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE))).replaceIfs(RelDistributionTraitDef.INSTANCE, () -> Collections.singletonList(input.getTraitSet().getTrait(RelDistributionTraitDef.INSTANCE)));
            newCondition = RexUtil.removeNullabilityCast(relBuilder.getTypeFactory(), newCondition);
            newFilterRel = filter.copy(traitSet, input, newCondition);
        } else {
            newFilterRel = relBuilder.push(project.getInput()).filter(newCondition).build();
        }
        RelNode newProjRel = this.copyProject ? project.copy(project.getTraitSet(), newFilterRel, project.getProjects(), project.getRowType()) : relBuilder.push(newFilterRel).project(project.getProjects(), project.getRowType().getFieldNames()).build();
        call.transformTo(newProjRel);
    }
}

