/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelDigest;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptQuery;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataFactory;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apiguardian.api.API;
import org.slf4j.Logger;

public abstract class AbstractRelNode
implements RelNode {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    protected RelDataType rowType;
    @API(since="1.24", status=API.Status.INTERNAL)
    protected RelDigest digest;
    private final RelOptCluster cluster;
    protected final int id;
    protected RelTraitSet traitSet;

    public AbstractRelNode(RelOptCluster cluster, RelTraitSet traitSet) {
        assert (cluster != null);
        this.cluster = cluster;
        this.traitSet = traitSet;
        this.id = NEXT_ID.getAndIncrement();
        this.digest = new InnerRelDigest();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        if (this.getInputs().equals(inputs) && traitSet == this.getTraitSet()) {
            return this;
        }
        throw new AssertionError((Object)("Relational expression should override copy. Class=[" + this.getClass() + "]; traits=[" + this.getTraitSet() + "]; desired traits=[" + traitSet + "]"));
    }

    protected static <T> T sole(List<T> collection) {
        assert (collection.size() == 1);
        return collection.get(0);
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of();
    }

    @Override
    public final RelOptCluster getCluster() {
        return this.cluster;
    }

    @Override
    public final Convention getConvention() {
        return this.traitSet.getTrait(ConventionTraitDef.INSTANCE);
    }

    @Override
    public RelTraitSet getTraitSet() {
        return this.traitSet;
    }

    @Override
    public String getCorrelVariable() {
        return null;
    }

    @Override
    @Deprecated
    public boolean isDistinct() {
        RelMetadataQuery mq = this.cluster.getMetadataQuery();
        return Boolean.TRUE.equals(mq.areRowsUnique(this));
    }

    @Override
    @Deprecated
    public boolean isKey(ImmutableBitSet columns) {
        RelMetadataQuery mq = this.cluster.getMetadataQuery();
        return Boolean.TRUE.equals(mq.areColumnsUnique(this, columns));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public RelNode getInput(int i) {
        List<RelNode> inputs = this.getInputs();
        return inputs.get(i);
    }

    @Override
    @Deprecated
    public final RelOptQuery getQuery() {
        return this.getCluster().getQuery();
    }

    @Override
    public void register(RelOptPlanner planner) {
        Util.discard(planner);
    }

    @Override
    public String getRelTypeName() {
        String cn = this.getClass().getName();
        int i = cn.length();
        while (--i >= 0) {
            if (cn.charAt(i) != '$' && cn.charAt(i) != '.') continue;
            return cn.substring(i + 1);
        }
        return cn;
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        return litmus.succeed();
    }

    @Override
    @Deprecated
    public boolean isValid(boolean fail) {
        return this.isValid(Litmus.THROW, null);
    }

    @Override
    @Deprecated
    public List<RelCollation> getCollationList() {
        return ImmutableList.of();
    }

    @Override
    public final RelDataType getRowType() {
        if (this.rowType == null) {
            this.rowType = this.deriveRowType();
            assert (this.rowType != null) : this;
        }
        return this.rowType;
    }

    protected RelDataType deriveRowType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RelDataType getExpectedInputRowType(int ordinalInParent) {
        return this.getRowType();
    }

    @Override
    public List<RelNode> getInputs() {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public final double getRows() {
        return this.estimateRowCount(this.cluster.getMetadataQuery());
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return 1.0;
    }

    @Override
    @Deprecated
    public final Set<String> getVariablesStopped() {
        return CorrelationId.names(this.getVariablesSet());
    }

    @Override
    public Set<CorrelationId> getVariablesSet() {
        return ImmutableSet.of();
    }

    @Override
    public void collectVariablesUsed(Set<CorrelationId> variableSet) {
    }

    @Override
    public boolean isEnforcer() {
        return false;
    }

    @Override
    public void collectVariablesSet(Set<CorrelationId> variableSet) {
    }

    @Override
    public void childrenAccept(RelVisitor visitor) {
        List<RelNode> inputs = this.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            visitor.visit(inputs.get(i), i, this);
        }
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        return this;
    }

    @Override
    @Deprecated
    public final RelOptCost computeSelfCost(RelOptPlanner planner) {
        return this.computeSelfCost(planner, this.cluster.getMetadataQuery());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, rowCount, 0.0);
    }

    @Override
    public final <M extends Metadata> M metadata(Class<M> metadataClass, RelMetadataQuery mq) {
        MetadataFactory factory = this.cluster.getMetadataFactory();
        M metadata = factory.query(this, mq, metadataClass);
        assert (metadata != null) : "no provider found (rel=" + this + ", m=" + metadataClass + "); a backstop provider is recommended";
        return metadata;
    }

    @Override
    public void explain(RelWriter pw) {
        this.explainTerms(pw).done(this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return pw;
    }

    @Override
    public RelNode onRegister(RelOptPlanner planner) {
        List<RelNode> oldInputs = this.getInputs();
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(oldInputs.size());
        for (RelNode input : oldInputs) {
            RelNode e = planner.ensureRegistered(input, null);
            assert (e == input || RelOptUtil.equal("rowtype of rel before registration", input.getRowType(), "rowtype of rel after registration", e.getRowType(), Litmus.THROW));
            inputs.add(e);
        }
        RelNode r = this;
        if (!Util.equalShallow(oldInputs, inputs)) {
            r = this.copy(this.getTraitSet(), inputs);
        }
        r.recomputeDigest();
        assert (r.isValid(Litmus.THROW, null));
        return r;
    }

    @Override
    public void recomputeDigest() {
        this.digest.clear();
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        throw new UnsupportedOperationException("replaceInput called on " + this);
    }

    public String toString() {
        return "rel#" + this.id + ':' + this.getDigest();
    }

    @Override
    @Deprecated
    public final String getDescription() {
        return this.toString();
    }

    @Override
    public String getDigest() {
        return this.digest.toString();
    }

    @Override
    public final RelDigest getRelDigest() {
        return this.digest;
    }

    @Override
    public RelOptTable getTable() {
        return null;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    protected boolean digestEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRelNode that = (AbstractRelNode)obj;
        return this.getTraitSet().equals(that.getTraitSet()) && this.getDigestItems().equals(that.getDigestItems()) && this.getRowType().equalsSansFieldNames(that.getRowType());
    }

    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    protected int digestHash() {
        return Objects.hash(this.getTraitSet(), this.getDigestItems());
    }

    private List<List<Object>> getDigestItems() {
        RelDigestWriter rdw = new RelDigestWriter();
        this.explainTerms(rdw);
        if (this instanceof Hintable) {
            ImmutableList<RelHint> hints;
            rdw.itemIf("hints", hints, !(hints = ((Hintable)((Object)this)).getHints()).isEmpty());
        }
        return rdw.attrs;
    }

    private static final class RelDigestWriter
    implements RelWriter {
        private final List<List<Object>> attrs = new ArrayList<List<Object>>();
        String digest = null;

        private RelDigestWriter() {
        }

        @Override
        public void explain(RelNode rel, List<Pair<String, Object>> valueList) {
            throw new IllegalStateException("Should not be called for computing digest");
        }

        @Override
        public SqlExplainLevel getDetailLevel() {
            return SqlExplainLevel.DIGEST_ATTRIBUTES;
        }

        @Override
        public RelWriter item(String term, Object value) {
            if (value != null && value.getClass().isArray()) {
                value = "" + value;
            }
            this.attrs.add(FlatLists.of(term, value));
            return this;
        }

        @Override
        public RelWriter done(RelNode node) {
            StringBuilder sb = new StringBuilder();
            sb.append(node.getRelTypeName());
            sb.append('.');
            sb.append(node.getTraitSet());
            sb.append('(');
            int j = 0;
            for (List<Object> attr : this.attrs) {
                String key = (String)attr.get(0);
                Object value = attr.get(1);
                if (j++ > 0) {
                    sb.append(',');
                }
                sb.append(key);
                sb.append('=');
                if (value instanceof RelNode) {
                    RelNode input = (RelNode)value;
                    sb.append(input.getRelTypeName());
                    sb.append('#');
                    sb.append(input.getId());
                    continue;
                }
                sb.append(value);
            }
            sb.append(')');
            this.digest = sb.toString();
            return this;
        }
    }

    private class InnerRelDigest
    implements RelDigest {
        private int hash = 0;

        private InnerRelDigest() {
        }

        @Override
        public RelNode getRel() {
            return AbstractRelNode.this;
        }

        @Override
        public void clear() {
            this.hash = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerRelDigest relDigest = (InnerRelDigest)o;
            return AbstractRelNode.this.digestEquals(relDigest.getRel());
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = AbstractRelNode.this.digestHash();
            }
            return this.hash;
        }

        public String toString() {
            RelDigestWriter rdw = new RelDigestWriter();
            AbstractRelNode.this.explain(rdw);
            return rdw.digest;
        }
    }
}

