/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelDigest;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptMaterializations;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.Dumpers;
import org.apache.calcite.plan.volcano.IterativeRuleDriver;
import org.apache.calcite.plan.volcano.RelSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.RuleDriver;
import org.apache.calcite.plan.volcano.TopDownRuleDriver;
import org.apache.calcite.plan.volcano.VolcanoCost;
import org.apache.calcite.plan.volcano.VolcanoPlannerPhase;
import org.apache.calcite.plan.volcano.VolcanoPlannerPhaseRuleMappingInitializer;
import org.apache.calcite.plan.volcano.VolcanoRelMetadataProvider;
import org.apache.calcite.plan.volcano.VolcanoRuleCall;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.plan.volcano.VolcanoTimeoutException;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.Converter;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.externalize.RelWriterImpl;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apiguardian.api.API;

public class VolcanoPlanner
extends AbstractRelOptPlanner {
    protected RelSubset root;
    private final Multimap<Class<? extends RelNode>, RelOptRuleOperand> classOperands = LinkedListMultimap.create();
    final List<RelSet> allSets = new ArrayList<RelSet>();
    private final Map<RelDigest, RelNode> mapDigestToRel = new HashMap<RelDigest, RelNode>();
    private final IdentityHashMap<RelNode, RelSubset> mapRel2Subset = new IdentityHashMap();
    final Set<RelNode> prunedNodes = new HashSet<RelNode>();
    private final Set<RelOptSchema> registeredSchemas = new HashSet<RelOptSchema>();
    RuleDriver ruleDriver;
    private final List<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
    private int nextSetId = 0;
    private RelNode originalRoot;
    private Convention rootConvention;
    private boolean locked;
    private boolean noneConventionHasInfiniteCost = true;
    private final List<RelOptMaterialization> materializations = new ArrayList<RelOptMaterialization>();
    private final Map<List<String>, RelOptLattice> latticeByName = new LinkedHashMap<List<String>, RelOptLattice>();
    final Map<RelNode, Provenance> provenanceMap;
    final Deque<VolcanoRuleCall> ruleCallStack = new ArrayDeque<VolcanoRuleCall>();
    final RelOptCost zeroCost;
    final RelOptCost infCost;
    boolean topDownOpt = CalciteSystemProperty.TOPDOWN_OPT.value();
    Set<RelSubset> explorationRoots = new HashSet<RelSubset>();

    public VolcanoPlanner() {
        this(null, null);
    }

    public VolcanoPlanner(Context externalContext) {
        this(null, externalContext);
    }

    public VolcanoPlanner(RelOptCostFactory costFactory, Context externalContext) {
        super(costFactory == null ? VolcanoCost.FACTORY : costFactory, externalContext);
        this.zeroCost = this.costFactory.makeZeroCost();
        this.infCost = this.costFactory.makeInfiniteCost();
        this.provenanceMap = LOGGER.isDebugEnabled() ? new HashMap() : Util.blackholeMap();
        this.initRuleQueue();
    }

    private void initRuleQueue() {
        this.ruleDriver = this.topDownOpt ? new TopDownRuleDriver(this) : new IterativeRuleDriver(this);
    }

    protected VolcanoPlannerPhaseRuleMappingInitializer getPhaseRuleMappingInitializer() {
        return phaseRuleMap -> {
            ((Set)phaseRuleMap.get((Object)VolcanoPlannerPhase.PRE_PROCESS_MDR)).add("xxx");
            ((Set)phaseRuleMap.get((Object)VolcanoPlannerPhase.PRE_PROCESS)).add("xxx");
            ((Set)phaseRuleMap.get((Object)VolcanoPlannerPhase.CLEANUP)).add("xxx");
        };
    }

    public void setTopDownOpt(boolean value) {
        if (this.topDownOpt == value) {
            return;
        }
        this.topDownOpt = value;
        this.initRuleQueue();
    }

    @Override
    public boolean isRegistered(RelNode rel) {
        return this.mapRel2Subset.get(rel) != null;
    }

    @Override
    public void setRoot(RelNode rel) {
        this.registerMetadataRels();
        this.root = this.registerImpl(rel, null);
        if (this.originalRoot == null) {
            this.originalRoot = rel;
        }
        this.rootConvention = this.root.getConvention();
        this.ensureRootConverters();
    }

    @Override
    public RelNode getRoot() {
        return this.root;
    }

    @Override
    public List<RelOptMaterialization> getMaterializations() {
        return ImmutableList.copyOf(this.materializations);
    }

    @Override
    public void addMaterialization(RelOptMaterialization materialization) {
        this.materializations.add(materialization);
    }

    @Override
    public void addLattice(RelOptLattice lattice) {
        this.latticeByName.put(lattice.starRelOptTable.getQualifiedName(), lattice);
    }

    @Override
    public RelOptLattice getLattice(RelOptTable table) {
        return this.latticeByName.get(table.getQualifiedName());
    }

    protected void registerMaterializations() {
        CalciteConnectionConfig config = this.context.unwrap(CalciteConnectionConfig.class);
        if (config == null || !config.materializationsEnabled()) {
            return;
        }
        List<Pair<RelNode, List<RelOptMaterialization>>> materializationUses = RelOptMaterializations.useMaterializedViews(this.originalRoot, this.materializations);
        for (Pair<RelNode, List<RelOptMaterialization>> pair : materializationUses) {
            RelNode relNode = (RelNode)pair.left;
            Hook.SUB.run(relNode);
            this.registerImpl(relNode, this.root.set);
        }
        HashSet<RelOptMaterialization> applicableMaterializations = new HashSet<RelOptMaterialization>(RelOptMaterializations.getApplicableMaterializations(this.originalRoot, this.materializations));
        for (Pair<RelNode, List<RelOptMaterialization>> pair : materializationUses) {
            applicableMaterializations.removeAll((Collection)pair.right);
        }
        for (RelOptMaterialization relOptMaterialization : applicableMaterializations) {
            RelSubset subset = this.registerImpl(relOptMaterialization.queryRel, null);
            this.explorationRoots.add(subset);
            RelNode tableRel2 = RelOptUtil.createCastRel(relOptMaterialization.tableRel, relOptMaterialization.queryRel.getRowType(), true);
            this.registerImpl(tableRel2, subset.set);
        }
        List<Pair<RelNode, RelOptLattice>> list = RelOptMaterializations.useLattices(this.originalRoot, (List<RelOptLattice>)ImmutableList.copyOf(this.latticeByName.values()));
        if (!list.isEmpty()) {
            RelNode relNode = (RelNode)list.get((int)0).left;
            Hook.SUB.run(relNode);
            this.registerImpl(relNode, this.root.set);
        }
    }

    public RelSet getSet(RelNode rel) {
        assert (rel != null) : "pre: rel != null";
        RelSubset subset = this.getSubset(rel);
        if (subset != null) {
            assert (subset.set != null);
            return subset.set;
        }
        return null;
    }

    @Override
    public boolean addRelTraitDef(RelTraitDef relTraitDef) {
        return !this.traitDefs.contains(relTraitDef) && this.traitDefs.add(relTraitDef);
    }

    @Override
    public void clearRelTraitDefs() {
        this.traitDefs.clear();
    }

    @Override
    public List<RelTraitDef> getRelTraitDefs() {
        return this.traitDefs;
    }

    @Override
    public RelTraitSet emptyTraitSet() {
        RelTraitSet traitSet = super.emptyTraitSet();
        for (RelTraitDef traitDef : this.traitDefs) {
            if (traitDef.multiple()) {
                // empty if block
            }
            traitSet = traitSet.plus((RelTrait)traitDef.getDefault());
        }
        return traitSet;
    }

    @Override
    public void clear() {
        super.clear();
        for (RelOptRule rule : this.getRules()) {
            this.removeRule(rule);
        }
        this.classOperands.clear();
        this.allSets.clear();
        this.mapDigestToRel.clear();
        this.mapRel2Subset.clear();
        this.prunedNodes.clear();
        this.ruleDriver.clear();
        this.materializations.clear();
        this.latticeByName.clear();
        this.provenanceMap.clear();
    }

    @Override
    public boolean addRule(RelOptRule rule) {
        ConverterRule converterRule;
        RelTrait ruleTrait;
        RelTraitDef ruleTraitDef;
        if (this.locked) {
            return false;
        }
        if (!super.addRule(rule)) {
            return false;
        }
        for (RelOptRuleOperand operand : rule.getOperands()) {
            for (Class<? extends RelNode> subClass : this.subClasses(operand.getMatchedClass())) {
                if (PhysicalNode.class.isAssignableFrom(subClass) && rule instanceof TransformationRule) continue;
                this.classOperands.put(subClass, (Object)operand);
            }
        }
        if (rule instanceof ConverterRule && this.traitDefs.contains(ruleTraitDef = (ruleTrait = (converterRule = (ConverterRule)rule).getInTrait()).getTraitDef())) {
            ruleTraitDef.registerConverterRule(this, converterRule);
        }
        return true;
    }

    @Override
    public boolean removeRule(RelOptRule rule) {
        ConverterRule converterRule;
        RelTrait ruleTrait;
        RelTraitDef ruleTraitDef;
        if (!super.removeRule(rule)) {
            return false;
        }
        this.classOperands.values().removeIf(entry -> entry.getRule().equals((Object)rule));
        if (rule instanceof ConverterRule && this.traitDefs.contains(ruleTraitDef = (ruleTrait = (converterRule = (ConverterRule)rule).getInTrait()).getTraitDef())) {
            ruleTraitDef.deregisterConverterRule(this, converterRule);
        }
        return true;
    }

    @Override
    protected void onNewClass(RelNode node) {
        super.onNewClass(node);
        boolean isPhysical = node instanceof PhysicalNode;
        Class<?> clazz = node.getClass();
        for (RelOptRule rule : this.mapDescToRule.values()) {
            if (isPhysical && rule instanceof TransformationRule) continue;
            for (RelOptRuleOperand operand : rule.getOperands()) {
                if (!operand.getMatchedClass().isAssignableFrom(clazz)) continue;
                this.classOperands.put(clazz, (Object)operand);
            }
        }
    }

    @Override
    public RelNode changeTraits(RelNode rel, RelTraitSet toTraits) {
        assert (!rel.getTraitSet().equals(toTraits));
        assert (toTraits.allSimple());
        RelSubset rel2 = this.ensureRegistered(rel, null);
        if (rel2.getTraitSet().equals(toTraits)) {
            return rel2;
        }
        return rel2.set.getOrCreateSubset(rel.getCluster(), toTraits, true);
    }

    @Override
    public RelOptPlanner chooseDelegate() {
        return this;
    }

    @Override
    public RelNode findBestExp() {
        this.ensureRootConverters();
        this.registerMaterializations();
        this.ruleDriver.drive();
        if (LOGGER.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.dump(pw);
            pw.flush();
            LOGGER.info(sw.toString());
        }
        this.dumpRuleAttemptsInfo();
        RelNode cheapest = this.root.buildCheapestPlan(this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cheapest plan:\n{}", (Object)RelOptUtil.toString(cheapest, SqlExplainLevel.ALL_ATTRIBUTES));
            if (!this.provenanceMap.isEmpty()) {
                LOGGER.debug("Provenance:\n{}", (Object)Dumpers.provenance(this.provenanceMap, cheapest));
            }
        }
        return cheapest;
    }

    @Override
    public void checkCancel() {
        if (this.cancelFlag.get()) {
            throw new VolcanoTimeoutException();
        }
    }

    private void registerMetadataRels() {
        JaninoRelMetadataProvider.DEFAULT.register(this.classOperands.keySet());
    }

    void ensureRootConverters() {
        HashSet<RelSubset> subsets = new HashSet<RelSubset>();
        for (RelNode rel : this.root.getRels()) {
            if (!(rel instanceof AbstractConverter)) continue;
            subsets.add((RelSubset)((AbstractConverter)rel).getInput());
        }
        for (RelSubset subset : this.root.set.subsets) {
            ImmutableList<RelTrait> difference = this.root.getTraitSet().difference(subset.getTraitSet());
            if (difference.size() != 1 || !subsets.add(subset)) continue;
            this.register(new AbstractConverter(subset.getCluster(), subset, ((RelTrait)difference.get(0)).getTraitDef(), this.root.getTraitSet()), this.root);
        }
    }

    @Override
    public RelSubset register(RelNode rel, RelNode equivRel) {
        RelSet set;
        assert (!this.isRegistered(rel)) : "pre: isRegistered(rel)";
        if (equivRel == null) {
            set = null;
        } else {
            assert (RelOptUtil.equal("rel rowtype", rel.getRowType(), "equivRel rowtype", equivRel.getRowType(), Litmus.THROW));
            equivRel = this.ensureRegistered(equivRel, null);
            set = this.getSet(equivRel);
        }
        return this.registerImpl(rel, set);
    }

    @Override
    public RelSubset ensureRegistered(RelNode rel, RelNode equivRel) {
        RelSubset result;
        RelSubset subset = this.getSubset(rel);
        if (subset != null) {
            if (equivRel != null) {
                RelSubset equivSubset = this.getSubset(equivRel);
                if (subset.set != equivSubset.set) {
                    this.merge(equivSubset.set, subset.set);
                }
            }
            result = this.canonize(subset);
        } else {
            result = this.register(rel, equivRel);
        }
        if (LOGGER.isDebugEnabled()) assert (this.isValid(Litmus.THROW));
        return result;
    }

    protected boolean isValid(Litmus litmus) {
        if (this.getRoot() == null) {
            return true;
        }
        RelMetadataQuery metaQuery = this.getRoot().getCluster().getMetadataQuerySupplier().get();
        for (RelSet set : this.allSets) {
            if (set.equivalentSet != null) {
                return litmus.fail("set [{}] has been merged: it should not be in the list", set);
            }
            for (RelSubset subset : set.subsets) {
                if (subset.set != set) {
                    return litmus.fail("subset [{}] is in wrong set [{}]", subset, set);
                }
                if (subset.best != null) {
                    if (!subset.set.rels.contains(subset.best)) {
                        return litmus.fail("RelSubset [{}] does not contain its best RelNode [{}]", subset, subset.best);
                    }
                    try {
                        RelOptCost bestCost = this.getCost(subset.best, metaQuery);
                        if (!subset.bestCost.equals(bestCost)) {
                            return litmus.fail("RelSubset [" + subset + "] has wrong best cost " + subset.bestCost + ". Correct cost is " + bestCost, new Object[0]);
                        }
                    }
                    catch (CyclicMetadataException cyclicMetadataException) {
                        // empty catch block
                    }
                }
                for (RelNode rel : subset.getRels()) {
                    try {
                        RelOptCost relCost = this.getCost(rel, metaQuery);
                        if (!relCost.isLt(subset.bestCost)) continue;
                        return litmus.fail("rel [{}] has lower cost {} than best cost {} of subset [{}]", rel, relCost, subset.bestCost, subset);
                    }
                    catch (CyclicMetadataException cyclicMetadataException) {
                    }
                }
            }
        }
        return litmus.succeed();
    }

    public void registerAbstractRelationalRules() {
        RelOptUtil.registerAbstractRelationalRules(this);
    }

    @Override
    public void registerSchema(RelOptSchema schema) {
        if (this.registeredSchemas.add(schema)) {
            try {
                schema.registerRules(this);
            }
            catch (Exception e) {
                throw new AssertionError("While registering schema " + schema, e);
            }
        }
    }

    public void setNoneConventionHasInfiniteCost(boolean infinite) {
        this.noneConventionHasInfiniteCost = infinite;
    }

    @Override
    public RelOptCost getCost(RelNode rel, RelMetadataQuery mq) {
        assert (rel != null) : "pre-condition: rel != null";
        if (rel instanceof RelSubset) {
            return ((RelSubset)rel).bestCost;
        }
        if (this.noneConventionHasInfiniteCost && rel.getTraitSet().getTrait(ConventionTraitDef.INSTANCE) == Convention.NONE) {
            return this.costFactory.makeInfiniteCost();
        }
        RelOptCost cost = mq.getNonCumulativeCost(rel);
        if (!this.zeroCost.isLt(cost)) {
            cost = this.costFactory.makeTinyCost();
        }
        for (RelNode input : rel.getInputs()) {
            cost = cost.plus(this.getCost(input, mq));
        }
        return cost;
    }

    public RelSubset getSubset(RelNode rel) {
        assert (rel != null) : "pre: rel != null";
        if (rel instanceof RelSubset) {
            return (RelSubset)rel;
        }
        return this.mapRel2Subset.get(rel);
    }

    public RelSubset getSubset(RelNode rel, RelTraitSet traits) {
        if (rel instanceof RelSubset && rel.getTraitSet().equals(traits)) {
            return (RelSubset)rel;
        }
        RelSet set = this.getSet(rel);
        if (set == null) {
            return null;
        }
        return set.getSubset(traits);
    }

    RelNode changeTraitsUsingConverters(RelNode rel, RelTraitSet toTraits) {
        RelTraitSet fromTraits = rel.getTraitSet();
        assert (fromTraits.size() >= toTraits.size());
        boolean allowInfiniteCostConverters = CalciteSystemProperty.ALLOW_INFINITE_COST_CONVERTERS.value();
        RelNode converted = rel;
        for (int i = 0; converted != null && i < toTraits.size(); ++i) {
            RelTrait fromTrait = converted.getTraitSet().getTrait(i);
            RelTraitDef traitDef = fromTrait.getTraitDef();
            RelTrait toTrait = toTraits.getTrait(i);
            if (toTrait == null) continue;
            assert (traitDef == toTrait.getTraitDef());
            if (fromTrait.equals(toTrait)) continue;
            rel = traitDef.convert(this, converted, toTrait, allowInfiniteCostConverters);
            if (rel != null) {
                assert (rel.getTraitSet().getTrait(traitDef).satisfies(toTrait));
                this.register(rel, converted);
            }
            converted = rel;
        }
        if (converted != null) assert (converted.getTraitSet().satisfies(toTraits));
        return converted;
    }

    @Override
    public void prune(RelNode rel) {
        this.prunedNodes.add(rel);
    }

    public void dump(PrintWriter pw) {
        pw.println("Root: " + this.root);
        pw.println("Original rel:");
        if (this.originalRoot != null) {
            this.originalRoot.explain(new RelWriterImpl(pw, SqlExplainLevel.ALL_ATTRIBUTES, false));
        }
        try {
            if (CalciteSystemProperty.DUMP_SETS.value().booleanValue()) {
                pw.println();
                pw.println("Sets:");
                Dumpers.dumpSets(this, pw);
            }
            if (CalciteSystemProperty.DUMP_GRAPHVIZ.value().booleanValue()) {
                pw.println();
                pw.println("Graphviz:");
                Dumpers.dumpGraphviz(this, pw);
            }
        }
        catch (AssertionError | Exception e) {
            pw.println("Error when dumping plan state: \n" + e);
        }
    }

    public String toDot() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Dumpers.dumpGraphviz(this, pw);
        pw.flush();
        return sw.toString();
    }

    void rename(RelNode rel) {
        String oldDigest = null;
        if (LOGGER.isTraceEnabled()) {
            oldDigest = rel.getDigest();
        }
        if (this.fixUpInputs(rel)) {
            RelDigest newDigest = rel.getRelDigest();
            LOGGER.trace("Rename #{} from '{}' to '{}'", new Object[]{rel.getId(), oldDigest, newDigest});
            RelNode equivRel = this.mapDigestToRel.put(newDigest, rel);
            if (equivRel != null) {
                assert (equivRel != rel);
                LOGGER.trace("After renaming rel#{} it is now equivalent to rel#{}", (Object)rel.getId(), (Object)equivRel.getId());
                this.mapDigestToRel.put(newDigest, equivRel);
                this.checkPruned(equivRel, rel);
                RelSubset equivRelSubset = this.getSubset(equivRel);
                for (RelNode input : rel.getInputs()) {
                    ((RelSubset)input).set.parents.remove(rel);
                }
                RelSubset subset = this.mapRel2Subset.put(rel, equivRelSubset);
                assert (subset != null);
                boolean existed = subset.set.rels.remove(rel);
                assert (existed) : "rel was not known to its set";
                RelSubset equivSubset = this.getSubset(equivRel);
                for (RelSubset s : subset.set.subsets) {
                    if (s.best != rel) continue;
                    HashSet<RelSubset> activeSet = new HashSet<RelSubset>();
                    s.best = equivRel;
                    s.propagateCostImprovements(this, equivRel.getCluster().getMetadataQuery(), equivRel, activeSet);
                }
                if (equivSubset != subset) {
                    assert (equivSubset.getTraitSet().equals(subset.getTraitSet()));
                    assert (equivSubset.set != subset.set);
                    this.merge(equivSubset.set, subset.set);
                }
            }
        }
    }

    void reregister(RelSet set, RelNode rel) {
        RelNode equivRel = this.mapDigestToRel.get(rel.getRelDigest());
        if (equivRel != null && equivRel != rel) {
            assert (equivRel.getClass() == rel.getClass());
            assert (equivRel.getTraitSet().equals(rel.getTraitSet()));
            this.checkPruned(equivRel, rel);
            return;
        }
        if (!this.prunedNodes.contains(rel)) {
            this.addRelToSet(rel, set);
        }
    }

    private void checkPruned(RelNode rel, RelNode duplicateRel) {
        if (this.prunedNodes.contains(duplicateRel)) {
            this.prunedNodes.add(rel);
        }
    }

    void canonize() {
        this.root = this.canonize(this.root);
    }

    private RelSubset canonize(RelSubset subset) {
        if (subset.set.equivalentSet == null) {
            return subset;
        }
        RelSet set = subset.set;
        do {
            set = set.equivalentSet;
        } while (set.equivalentSet != null);
        return set.getOrCreateSubset(subset.getCluster(), subset.getTraitSet(), subset.isRequired());
    }

    void fireRules(RelNode rel) {
        for (RelOptRuleOperand operand : this.classOperands.get(rel.getClass())) {
            if (!operand.matches(rel)) continue;
            DeferringRuleCall ruleCall = new DeferringRuleCall(this, operand);
            ruleCall.match(rel);
        }
    }

    private boolean fixUpInputs(RelNode rel) {
        List<RelNode> inputs = rel.getInputs();
        ArrayList<RelSubset> newInputs = new ArrayList<RelSubset>(inputs.size());
        int changeCount = 0;
        for (RelNode input : inputs) {
            assert (input instanceof RelSubset);
            RelSubset subset = (RelSubset)input;
            RelSubset newSubset = this.canonize(subset);
            newInputs.add(newSubset);
            if (newSubset == subset) continue;
            if (subset.set != newSubset.set) {
                subset.set.parents.remove(rel);
                newSubset.set.parents.add(rel);
            }
            ++changeCount;
        }
        if (changeCount > 0) {
            RelMdUtil.clearCache(rel);
            RelNode removed = this.mapDigestToRel.remove(rel.getRelDigest());
            assert (removed == rel);
            for (int i = 0; i < inputs.size(); ++i) {
                rel.replaceInput(i, (RelNode)newInputs.get(i));
            }
            rel.recomputeDigest();
            return true;
        }
        return false;
    }

    private RelSet merge(RelSet set, RelSet set2) {
        assert (set != set2) : "pre: set != set2";
        set = VolcanoPlanner.equivRoot(set);
        if ((set2 = VolcanoPlanner.equivRoot(set2)) == set) {
            return set;
        }
        if (!set2.getChildSets(this).contains(set) && (set.getChildSets(this).contains(set2) || set.id > set2.id)) {
            RelSet t = set;
            set = set2;
            set2 = t;
        }
        set.mergeWith(this, set2);
        if (set2 == this.getSet(this.root)) {
            this.root = set.getOrCreateSubset(this.root.getCluster(), this.root.getTraitSet(), this.root.isRequired());
            this.ensureRootConverters();
        }
        if (this.ruleDriver != null) {
            this.ruleDriver.onSetMerged(set);
        }
        return set;
    }

    static RelSet equivRoot(RelSet s) {
        RelSet p = s;
        while (s.equivalentSet != null) {
            p = VolcanoPlanner.forward2(s, p);
            s = s.equivalentSet;
        }
        return s;
    }

    private static RelSet forward2(RelSet s, RelSet p) {
        p = VolcanoPlanner.forward1(s, p);
        p = VolcanoPlanner.forward1(s, p);
        return p;
    }

    private static RelSet forward1(RelSet s, RelSet p) {
        if (p != null && (p = p.equivalentSet) == s) {
            throw new AssertionError((Object)"cycle in equivalence tree");
        }
        return p;
    }

    private RelSubset registerImpl(RelNode rel, RelSet set) {
        if (rel instanceof RelSubset) {
            return this.registerSubset(set, (RelSubset)rel);
        }
        assert (!this.isRegistered(rel)) : "already been registered: " + rel;
        if (rel.getCluster().getPlanner() != this) {
            throw new AssertionError((Object)("Relational expression " + rel + " belongs to a different planner than is currently being used."));
        }
        RelTraitSet traits = rel.getTraitSet();
        Convention convention = traits.getTrait(ConventionTraitDef.INSTANCE);
        assert (convention != null);
        if (!convention.getInterface().isInstance(rel) && !(rel instanceof Converter)) {
            throw new AssertionError((Object)("Relational expression " + rel + " has calling-convention " + convention + " but does not implement the required interface '" + convention.getInterface() + "' of that convention"));
        }
        if (traits.size() != this.traitDefs.size()) {
            throw new AssertionError((Object)("Relational expression " + rel + " does not have the correct number of traits: " + traits.size() + " != " + this.traitDefs.size()));
        }
        rel = rel.onRegister(this);
        if (this.ruleCallStack.isEmpty()) {
            this.provenanceMap.put(rel, Provenance.EMPTY);
        } else {
            VolcanoRuleCall ruleCall = this.ruleCallStack.peek();
            this.provenanceMap.put(rel, new RuleProvenance(ruleCall.rule, (ImmutableList<RelNode>)ImmutableList.copyOf((Object[])ruleCall.rels), ruleCall.id));
        }
        RelDigest digest = rel.getRelDigest();
        RelNode equivExp = this.mapDigestToRel.get(digest);
        if (equivExp != null) {
            if (equivExp == rel) {
                return this.getSubset(rel);
            }
            assert (RelOptUtil.equal("left", equivExp.getRowType(), "right", rel.getRowType(), Litmus.THROW));
            this.checkPruned(equivExp, rel);
            RelSet equivSet = this.getSet(equivExp);
            if (equivSet != null) {
                LOGGER.trace("Register: rel#{} is equivalent to {}", (Object)rel.getId(), (Object)equivExp);
                return this.registerSubset(set, this.getSubset(equivExp));
            }
        }
        if (rel instanceof Converter) {
            RelNode input = ((Converter)rel).getInput();
            RelSet childSet = this.getSet(input);
            if (set != null && set != childSet && set.equivalentSet == null) {
                RelNode equivRel;
                LOGGER.trace("Register #{} {} (and merge sets, because it is a conversion)", (Object)rel.getId(), (Object)rel.getRelDigest());
                this.merge(set, childSet);
                if (this.fixUpInputs(rel) && (equivRel = this.mapDigestToRel.get(digest = rel.getRelDigest())) != rel && equivRel != null) {
                    set.obliterateRelNode(rel);
                    return this.getSubset(equivRel);
                }
            } else {
                set = childSet;
            }
        }
        if (set == null) {
            set = new RelSet(this.nextSetId++, Util.minus(RelOptUtil.getVariablesSet(rel), rel.getVariablesSet()), RelOptUtil.getVariablesUsed(rel));
            this.allSets.add(set);
        }
        while (set.equivalentSet != null) {
            set = set.equivalentSet;
        }
        this.registerClass(rel);
        int subsetBeforeCount = set.subsets.size();
        RelSubset subset = this.addRelToSet(rel, set);
        RelNode xx = this.mapDigestToRel.putIfAbsent(digest, rel);
        LOGGER.trace("Register {} in {}", (Object)rel, (Object)subset);
        if (xx != null) {
            return subset;
        }
        for (RelNode input : rel.getInputs()) {
            RelSubset childSubset = (RelSubset)input;
            childSubset.set.parents.add(rel);
        }
        this.fireRules(rel);
        if (set.subsets.size() > subsetBeforeCount || subset.triggerRule) {
            this.fireRules(subset);
        }
        return subset;
    }

    private RelSubset addRelToSet(RelNode rel, RelSet set) {
        RelSubset subset = set.add(rel);
        this.mapRel2Subset.put(rel, subset);
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        try {
            subset.propagateCostImprovements(this, mq, rel, new HashSet<RelSubset>());
        }
        catch (CyclicMetadataException cyclicMetadataException) {
            // empty catch block
        }
        if (this.ruleDriver != null) {
            this.ruleDriver.onProduce(rel, subset);
        }
        return subset;
    }

    private RelSubset registerSubset(RelSet set, RelSubset subset) {
        if (set != subset.set && set != null && set.equivalentSet == null) {
            LOGGER.trace("Register #{} {}, and merge sets", (Object)subset.getId(), (Object)subset);
            this.merge(set, subset.set);
        }
        return this.canonize(subset);
    }

    @Override
    public void registerMetadataProviders(List<RelMetadataProvider> list) {
        list.add(0, new VolcanoRelMetadataProvider());
    }

    @Override
    public long getRelMetadataTimestamp(RelNode rel) {
        RelSubset subset = this.getSubset(rel);
        if (subset == null) {
            return 0L;
        }
        return subset.timestamp;
    }

    public static String normalizePlan(String plan) {
        if (plan == null) {
            return null;
        }
        Pattern poundDigits = Pattern.compile("Subset#[0-9]+\\.");
        int i = 0;
        Matcher matcher;
        while ((matcher = poundDigits.matcher(plan)).find()) {
            String token = matcher.group();
            plan = plan.replace(token, "Subset#{" + i++ + "}.");
        }
        return plan;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    public boolean isLogical(RelNode rel) {
        return !(rel instanceof PhysicalNode) && rel.getConvention() != this.rootConvention;
    }

    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    protected boolean isSubstituteRule(VolcanoRuleCall match) {
        return match.getRule() instanceof SubstitutionRule;
    }

    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    protected boolean isTransformationRule(VolcanoRuleCall match) {
        if (match.getRule() instanceof SubstitutionRule) {
            return true;
        }
        if (match.getRule() instanceof ConverterRule && match.getRule().getOutTrait() == this.rootConvention) {
            return false;
        }
        return match.getRule().getOperand().trait == Convention.NONE || match.getRule().getOperand().trait == null;
    }

    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    protected RelOptCost getLowerBound(RelNode rel) {
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        RelOptCost lowerBound = mq.getLowerBoundCost(rel, this);
        if (lowerBound == null) {
            return this.zeroCost;
        }
        return lowerBound;
    }

    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    protected RelOptCost upperBoundForInputs(RelNode mExpr, RelOptCost upperBound) {
        RelOptCost rootCost;
        if (!upperBound.isInfinite() && !(rootCost = mExpr.getCluster().getMetadataQuery().getNonCumulativeCost(mExpr)).isInfinite()) {
            return upperBound.minus(rootCost);
        }
        return upperBound;
    }

    static class RuleProvenance
    extends Provenance {
        final RelOptRule rule;
        final ImmutableList<RelNode> rels;
        final int callId;

        RuleProvenance(RelOptRule rule, ImmutableList<RelNode> rels, int callId) {
            this.rule = rule;
            this.rels = rels;
            this.callId = callId;
        }
    }

    static class DirectProvenance
    extends Provenance {
        final RelNode source;

        DirectProvenance(RelNode source) {
            this.source = source;
        }
    }

    private static class UnknownProvenance
    extends Provenance {
        private UnknownProvenance() {
        }
    }

    static abstract class Provenance {
        public static final Provenance EMPTY = new UnknownProvenance();

        Provenance() {
        }
    }

    private static class DeferringRuleCall
    extends VolcanoRuleCall {
        DeferringRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand) {
            super(planner, operand);
        }

        @Override
        protected void onMatch() {
            VolcanoRuleMatch match = new VolcanoRuleMatch(this.volcanoPlanner, this.getOperand0(), this.rels, (Map<RelNode, List<RelNode>>)this.nodeInputs);
            this.volcanoPlanner.ruleDriver.getRuleQueue().addMatch(match);
        }
    }
}

