/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.Converter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

class RelSet {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    final List<RelNode> rels = new ArrayList<RelNode>();
    final List<RelNode> parents = new ArrayList<RelNode>();
    final List<RelSubset> subsets = new ArrayList<RelSubset>();
    RelSet equivalentSet;
    RelNode rel;
    ExploringState exploringState;
    final Set<Pair<RelTraitSet, RelTraitSet>> conversions = new HashSet<Pair<RelTraitSet, RelTraitSet>>();
    final Set<CorrelationId> variablesPropagated;
    final Set<CorrelationId> variablesUsed;
    final int id;
    boolean inMetadataQuery;

    RelSet(int id, Set<CorrelationId> variablesPropagated, Set<CorrelationId> variablesUsed) {
        this.id = id;
        this.variablesPropagated = variablesPropagated;
        this.variablesUsed = variablesUsed;
    }

    public List<RelNode> getParentRels() {
        return this.parents;
    }

    public Set<RelSet> getChildSets(VolcanoPlanner planner) {
        HashSet<RelSet> childSets = new HashSet<RelSet>();
        for (RelNode node : this.rels) {
            if (node instanceof Converter) continue;
            for (RelNode child : node.getInputs()) {
                RelSet childSet = VolcanoPlanner.equivRoot(((RelSubset)child).getSet());
                if (childSet.id == this.id) continue;
                childSets.add(childSet);
            }
        }
        return childSets;
    }

    public List<RelNode> getRelsFromAllSubsets() {
        return this.rels;
    }

    public RelSubset getSubset(RelTraitSet traits) {
        for (RelSubset subset : this.subsets) {
            if (!subset.getTraitSet().equals(traits)) continue;
            return subset;
        }
        return null;
    }

    void obliterateRelNode(RelNode rel) {
        this.parents.remove(rel);
    }

    public RelSubset add(RelNode rel) {
        assert (this.equivalentSet == null) : "adding to a dead set";
        RelTraitSet traitSet = rel.getTraitSet().simplify();
        RelSubset subset = this.getOrCreateSubset(rel.getCluster(), traitSet, rel.isEnforcer());
        subset.add(rel);
        return subset;
    }

    void addConverters(RelSubset subset, boolean required, boolean useAbstractConverter) {
        RelOptCluster cluster = subset.getCluster();
        List others = this.subsets.stream().filter(n -> required ? n.isDelivered() : n.isRequired()).collect(Collectors.toList());
        for (RelSubset other : others) {
            RelNode enforcer;
            assert (other.getTraitSet().size() == subset.getTraitSet().size());
            RelSubset from = subset;
            RelSubset to = other;
            if (required) {
                from = other;
                to = subset;
            }
            if (from == to || to.isEnforceDisabled() || useAbstractConverter && !from.getConvention().useAbstractConvertersForConversion(from.getTraitSet(), to.getTraitSet()) || !this.conversions.add(Pair.of(from.getTraitSet(), to.getTraitSet()))) continue;
            ImmutableList<RelTrait> difference = to.getTraitSet().difference(from.getTraitSet());
            boolean needsConverter = false;
            for (RelTrait fromTrait : difference) {
                RelTraitDef traitDef = fromTrait.getTraitDef();
                Object toTrait = to.getTraitSet().getTrait(traitDef);
                if (toTrait == null || !traitDef.canConvert(cluster.getPlanner(), fromTrait, toTrait)) {
                    needsConverter = false;
                    break;
                }
                if (fromTrait.satisfies((RelTrait)toTrait)) continue;
                needsConverter = true;
            }
            if (!needsConverter || (enforcer = useAbstractConverter ? new AbstractConverter(cluster, from, null, to.getTraitSet()) : subset.getConvention().enforce(from, to.getTraitSet())) == null) continue;
            cluster.getPlanner().register(enforcer, to);
        }
    }

    RelSubset getOrCreateSubset(RelOptCluster cluster, RelTraitSet traits, boolean required) {
        boolean needsConverter = false;
        VolcanoPlanner planner = (VolcanoPlanner)cluster.getPlanner();
        RelSubset subset = this.getSubset(traits);
        if (subset == null) {
            needsConverter = true;
            subset = new RelSubset(cluster, this, traits);
            this.subsets.add(subset);
            if (planner.getListener() != null) {
                this.postEquivalenceEvent(planner, subset);
            }
        } else if (required && !subset.isRequired() || !required && !subset.isDelivered()) {
            needsConverter = true;
        }
        if (subset.getConvention() == Convention.NONE) {
            needsConverter = false;
        } else if (required) {
            subset.setRequired();
        } else {
            subset.setDelivered();
        }
        if (needsConverter) {
            this.addConverters(subset, required, !planner.topDownOpt);
        }
        return subset;
    }

    private void postEquivalenceEvent(VolcanoPlanner planner, RelNode rel) {
        RelOptListener.RelEquivalenceEvent event = new RelOptListener.RelEquivalenceEvent(planner, rel, "equivalence class " + this.id, false);
        planner.getListener().relEquivalenceFound(event);
    }

    void addInternal(RelNode rel) {
        if (!this.rels.contains(rel)) {
            this.rels.add(rel);
            for (RelTrait trait : rel.getTraitSet()) {
                assert (trait == trait.getTraitDef().canonize(trait));
            }
            VolcanoPlanner planner = (VolcanoPlanner)rel.getCluster().getPlanner();
            if (planner.getListener() != null) {
                this.postEquivalenceEvent(planner, rel);
            }
        }
        if (this.rel == null) {
            this.rel = rel;
        } else {
            RelOptUtil.verifyTypeEquivalence(this.rel, rel, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    void mergeWith(VolcanoPlanner planner, RelSet otherSet) {
        assert (this != otherSet);
        assert (this.equivalentSet == null);
        assert (otherSet.equivalentSet == null);
        LOGGER.trace("Merge set#{} into set#{}", (Object)otherSet.id, (Object)this.id);
        otherSet.equivalentSet = this;
        RelOptCluster cluster = this.rel.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        boolean existed = planner.allSets.remove(otherSet);
        assert (existed) : "merging with a dead otherSet";
        IdentityHashMap<void, RelNode> changedSubsets = new IdentityHashMap<void, RelNode>();
        for (RelSubset relSubset : otherSet.subsets) {
            void var9_11;
            Object var9_12 = null;
            RelTraitSet relTraitSet = relSubset.getTraitSet();
            if (relSubset.isDelivered() || !relSubset.isRequired()) {
                RelSubset relSubset2 = this.getOrCreateSubset(cluster, relTraitSet, false);
            }
            if (relSubset.isRequired()) {
                RelSubset relSubset3 = this.getOrCreateSubset(cluster, relTraitSet, true);
            }
            assert (var9_11 != null);
            if (var9_11.passThroughCache == null) {
                var9_11.passThroughCache = relSubset.passThroughCache;
            } else if (relSubset.passThroughCache != null) {
                var9_11.passThroughCache.addAll(relSubset.passThroughCache);
            }
            if (!relSubset.bestCost.isLt(var9_11.bestCost)) continue;
            changedSubsets.put(var9_11, relSubset.best);
        }
        HashSet<RelNode> parentRels = new HashSet<RelNode>(this.parents);
        for (RelNode relNode : otherSet.rels) {
            if (!(relNode instanceof Spool) && !relNode.isEnforcer() && parentRels.contains(relNode) && (relNode.getInputs().size() != 1 || relNode.getInput(0).getTraitSet().satisfies(relNode.getTraitSet()))) {
                planner.prune(relNode);
            }
            planner.reregister(this, relNode);
        }
        assert (this.equivalentSet == null);
        HashSet<RelSubset> hashSet = new HashSet<RelSubset>();
        for (Map.Entry entry : changedSubsets.entrySet()) {
            RelSubset relSubset = (RelSubset)entry.getKey();
            relSubset.propagateCostImprovements(planner, mq, (RelNode)entry.getValue(), hashSet);
        }
        assert (hashSet.isEmpty());
        ImmutableList immutableList = ImmutableList.copyOf(otherSet.getParentRels());
        for (RelNode parentRel : immutableList) {
            planner.rename(parentRel);
        }
        if (this.equivalentSet != null) {
            return;
        }
        for (RelNode parentRel : this.getParentRels()) {
            RelSubset parentSubset = planner.getSubset(parentRel);
            parentSubset.propagateCostImprovements(planner, mq, parentRel, hashSet);
        }
        assert (hashSet.isEmpty());
        assert (this.equivalentSet == null);
        for (RelNode rel : this.rels) {
            assert (planner.getSet(rel) == this);
            planner.fireRules(rel);
        }
        for (RelSubset subset : this.subsets) {
            planner.fireRules(subset);
        }
    }

    static enum ExploringState {
        EXPLORING,
        EXPLORED;

    }
}

