/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.RuleQueue;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoPlannerPhase;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

class IterativeRuleQueue
extends RuleQueue {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final Set<String> ALL_RULES = ImmutableSet.of((Object)"<ALL RULES>");
    final Map<VolcanoPlannerPhase, PhaseMatchList> matchListMap = new EnumMap<VolcanoPlannerPhase, PhaseMatchList>(VolcanoPlannerPhase.class);
    private final Map<VolcanoPlannerPhase, Set<String>> phaseRuleMapping = new EnumMap<VolcanoPlannerPhase, Set<String>>(VolcanoPlannerPhase.class);

    IterativeRuleQueue(VolcanoPlanner planner) {
        super(planner);
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            this.phaseRuleMapping.put(phase, new HashSet());
        }
        planner.getPhaseRuleMappingInitializer().initialize(this.phaseRuleMapping);
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            if (this.phaseRuleMapping.get((Object)phase).isEmpty()) {
                this.phaseRuleMapping.put(phase, ALL_RULES);
            }
            PhaseMatchList matchList = new PhaseMatchList(phase);
            this.matchListMap.put(phase, matchList);
        }
    }

    @Override
    public boolean clear() {
        boolean empty = true;
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            if (!matchList.queue.isEmpty() || !matchList.preQueue.isEmpty()) {
                empty = false;
            }
            matchList.clear();
        }
        return !empty;
    }

    public void phaseCompleted(VolcanoPlannerPhase phase) {
        this.matchListMap.get((Object)phase).clear();
    }

    @Override
    public void addMatch(VolcanoRuleMatch match) {
        String matchName = match.toString();
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            String ruleDescription;
            Set<String> phaseRuleSet = this.phaseRuleMapping.get((Object)matchList.phase);
            if (phaseRuleSet != ALL_RULES && !phaseRuleSet.contains(ruleDescription = match.getRule().toString()) || !matchList.names.add(matchName)) continue;
            LOGGER.trace("{} Rule-match queued: {}", (Object)matchList.phase.toString(), (Object)matchName);
            matchList.offer(match);
            matchList.matchMap.put((Object)this.planner.getSubset(match.rels[0]), (Object)match);
        }
    }

    public VolcanoRuleMatch popMatch(VolcanoPlannerPhase phase) {
        VolcanoRuleMatch match;
        this.dumpPlannerState();
        PhaseMatchList phaseMatchList = this.matchListMap.get((Object)phase);
        if (phaseMatchList == null) {
            throw new AssertionError((Object)("Used match list for phase " + (Object)((Object)phase) + " after phase complete"));
        }
        while (true) {
            if (phaseMatchList.size() == 0) {
                return null;
            }
            this.dumpRuleQueue(phaseMatchList);
            match = phaseMatchList.poll();
            if (!this.skipMatch(match)) break;
            LOGGER.debug("Skip match: {}", (Object)match);
        }
        phaseMatchList.matchMap.remove((Object)this.planner.getSubset(match.rels[0]), (Object)match);
        LOGGER.debug("Pop match: {}", (Object)match);
        return match;
    }

    private void dumpRuleQueue(PhaseMatchList phaseMatchList) {
        if (LOGGER.isTraceEnabled()) {
            StringBuilder b = new StringBuilder();
            b.append("Rule queue:");
            for (VolcanoRuleMatch rule : phaseMatchList.preQueue) {
                b.append("\n");
                b.append(rule);
            }
            for (VolcanoRuleMatch rule : phaseMatchList.queue) {
                b.append("\n");
                b.append(rule);
            }
            LOGGER.trace(b.toString());
        }
    }

    private void dumpPlannerState() {
        if (LOGGER.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.planner.dump(pw);
            pw.flush();
            LOGGER.trace(sw.toString());
            this.planner.getRoot().getCluster().invalidateMetadataQuery();
        }
    }

    private static class PhaseMatchList {
        final VolcanoPlannerPhase phase;
        private final Queue<VolcanoRuleMatch> preQueue = new LinkedList<VolcanoRuleMatch>();
        private final Queue<VolcanoRuleMatch> queue = new LinkedList<VolcanoRuleMatch>();
        final Set<String> names = new HashSet<String>();
        final Multimap<RelSubset, VolcanoRuleMatch> matchMap = HashMultimap.create();

        PhaseMatchList(VolcanoPlannerPhase phase) {
            this.phase = phase;
        }

        int size() {
            return this.preQueue.size() + this.queue.size();
        }

        VolcanoRuleMatch poll() {
            VolcanoRuleMatch match = this.preQueue.poll();
            if (match == null) {
                match = this.queue.poll();
            }
            return match;
        }

        void offer(VolcanoRuleMatch match) {
            if (match.getRule() instanceof SubstitutionRule) {
                this.preQueue.offer(match);
            } else {
                this.queue.offer(match);
            }
        }

        void clear() {
            this.preQueue.clear();
            this.queue.clear();
            this.names.clear();
            this.matchMap.clear();
        }
    }
}

