/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import org.apache.calcite.plan.volcano.IterativeRuleQueue;
import org.apache.calcite.plan.volcano.RelSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.RuleDriver;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoPlannerPhase;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.plan.volcano.VolcanoTimeoutException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

class IterativeRuleDriver
implements RuleDriver {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private final VolcanoPlanner planner;
    private final IterativeRuleQueue ruleQueue;

    IterativeRuleDriver(VolcanoPlanner planner) {
        this.planner = planner;
        this.ruleQueue = new IterativeRuleQueue(planner);
    }

    @Override
    public IterativeRuleQueue getRuleQueue() {
        return this.ruleQueue;
    }

    @Override
    public void drive() {
        block2: for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            while (true) {
                LOGGER.debug("PLANNER = {}; PHASE = {}; COST = {}", new Object[]{this, phase.toString(), this.planner.root.bestCost});
                VolcanoRuleMatch match = this.ruleQueue.popMatch(phase);
                if (match == null) break;
                assert (match.getRule().matches(match));
                try {
                    match.onMatch();
                }
                catch (VolcanoTimeoutException e) {
                    LOGGER.warn("Volcano planning times out, cancels the subsequent optimization.");
                    this.planner.canonize();
                    this.ruleQueue.phaseCompleted(phase);
                    break block2;
                }
                this.planner.canonize();
            }
            this.ruleQueue.phaseCompleted(phase);
        }
    }

    @Override
    public void onProduce(RelNode rel, RelSubset subset) {
    }

    @Override
    public void onSetMerged(RelSet set) {
    }

    @Override
    public void clear() {
        this.ruleQueue.clear();
    }
}

