/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableUnion;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalUnion;

class EnumerableUnionRule
extends ConverterRule {
    EnumerableUnionRule() {
        super(LogicalUnion.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableUnionRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalUnion union = (LogicalUnion)rel;
        EnumerableConvention out = EnumerableConvention.INSTANCE;
        RelTraitSet traitSet = rel.getCluster().traitSet().replace(out);
        List newInputs = Lists.transform(union.getInputs(), n -> EnumerableUnionRule.convert(n, traitSet));
        return new EnumerableUnion(rel.getCluster(), traitSet, newInputs, union.all);
    }
}

