/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.MatchImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.MemoryFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.DeclarationStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.runtime.Enumerables;
import org.apache.calcite.sql.SqlMatchFunction;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

public class EnumerableMatch
extends Match
implements EnumerableRel {
    public EnumerableMatch(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, RexNode interval) {
        super(cluster, traitSet, input, rowType, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
    }

    public static EnumerableMatch create(RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, RexNode interval) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE);
        return new EnumerableMatch(cluster, traitSet, input, rowType, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableMatch(this.getCluster(), traitSet, inputs.get(0), this.rowType, this.pattern, this.strictStart, this.strictEnd, (Map<String, RexNode>)this.patternDefinitions, (Map<String, RexNode>)this.measures, this.after, (Map<String, ? extends SortedSet<String>>)this.subsets, this.allRows, this.partitionKeys, this.orderKeys, this.interval);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel input = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, input, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), input.getRowType(), result.format);
        Expression inputExp = builder.append("input", result.block);
        PhysType inputPhysType = result.physType;
        PhysType keyPhysType = inputPhysType.project(this.partitionKeys.asList(), JavaRowFormat.LIST);
        ParameterExpression row_ = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"row_");
        Expression keySelector_ = builder.append("keySelector", inputPhysType.generateSelector(row_, this.partitionKeys.asList(), keyPhysType.getFormat()));
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = implementor.getTypeFactory().builder();
        this.measures.forEach((name, value) -> typeBuilder.add((String)name, value.getType()).nullable(true));
        PhysType emitType = PhysTypeImpl.of(implementor.getTypeFactory(), typeBuilder.build(), result.format);
        Expression matcher_ = this.implementMatcher(implementor, physType, builder, row_);
        Expression emitter_ = this.implementEmitter(implementor, emitType, physType);
        MaxHistoryFutureVisitor visitor = new MaxHistoryFutureVisitor();
        this.patternDefinitions.values().forEach(pd -> pd.accept(visitor));
        int history = visitor.getHistory();
        int future = visitor.getFuture();
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.MATCH.method, (Expression[])new Expression[]{inputExp, keySelector_, matcher_, emitter_, Expressions.constant((Object)history), Expressions.constant((Object)future)})));
        return implementor.result(emitType, builder.toBlock());
    }

    private Expression implementEmitter(EnumerableRelImplementor implementor, PhysType physType, PhysType inputPhysType) {
        ParameterExpression rows_ = Expressions.parameter((Type)Types.of(List.class, (Type[])new Type[]{inputPhysType.getJavaRowType()}), (String)"rows");
        ParameterExpression rowStates_ = Expressions.parameter(List.class, (String)"rowStates");
        ParameterExpression symbols_ = Expressions.parameter(List.class, (String)"symbols");
        ParameterExpression match_ = Expressions.parameter(Integer.TYPE, (String)"match");
        ParameterExpression consumer_ = Expressions.parameter(Consumer.class, (String)"consumer");
        ParameterExpression i_ = Expressions.parameter(Integer.TYPE, (String)"i");
        ParameterExpression row_ = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"row");
        BlockBuilder builder2 = new BlockBuilder();
        builder2.add((Statement)Expressions.declare((int)0, (ParameterExpression)row_, (Expression)EnumUtils.convert((Expression)Expressions.call((Expression)rows_, (Method)BuiltInMethod.LIST_GET.method, (Expression[])new Expression[]{i_}), inputPhysType.getJavaRowType())));
        RexBuilder rexBuilder = new RexBuilder(implementor.getTypeFactory());
        RexProgramBuilder rexProgramBuilder = new RexProgramBuilder(inputPhysType.getRowType(), rexBuilder);
        for (Map.Entry entry : this.measures.entrySet()) {
            rexProgramBuilder.addProject((RexNode)entry.getValue(), (String)entry.getKey());
        }
        RexToLixTranslator translator = RexToLixTranslator.forAggregation((JavaTypeFactory)this.getCluster().getTypeFactory(), builder2, new PassedRowsInputGetter(row_, rows_, inputPhysType), implementor.getConformance());
        ParameterExpression result_ = Expressions.parameter((Type)physType.getJavaRowType());
        builder2.add((Statement)Expressions.declare((int)16, (ParameterExpression)result_, (Expression)Expressions.new_((Type)physType.getJavaRowType())));
        Ord.forEach((Iterable)this.measures.values(), (measure, i) -> builder2.add(Expressions.statement((Expression)Expressions.assign((Expression)physType.fieldReference((Expression)result_, i), (Expression)this.implementMeasure(translator, rows_, symbols_, i_, row_, (RexNode)measure)))));
        builder2.add(Expressions.statement((Expression)Expressions.call((Expression)consumer_, (Method)BuiltInMethod.CONSUMER_ACCEPT.method, (Expression[])new Expression[]{result_})));
        BlockBuilder builder = new BlockBuilder();
        builder.add((Statement)Expressions.for_((DeclarationStatement)Expressions.declare((int)0, (ParameterExpression)i_, (Expression)Expressions.constant((Object)0)), (Expression)Expressions.lessThan((Expression)i_, (Expression)Expressions.call((Expression)rows_, (Method)BuiltInMethod.COLLECTION_SIZE.method, (Expression[])new Expression[0])), (Expression)Expressions.preIncrementAssign((Expression)i_), (Statement)builder2.toBlock()));
        return Expressions.new_((Type)Types.of(Enumerables.Emitter.class, (Type[])new Type[0]), EnumUtils.NO_EXPRS, (Iterable)Expressions.list((Object[])new MethodDeclaration[]{EnumUtils.overridingMethodDecl(BuiltInMethod.EMITTER_EMIT.method, (Iterable<ParameterExpression>)ImmutableList.of((Object)rows_, (Object)rowStates_, (Object)symbols_, (Object)match_, (Object)consumer_), builder.toBlock())}));
    }

    private Expression implementMeasure(RexToLixTranslator translator, ParameterExpression rows_, ParameterExpression symbols_, ParameterExpression i_, ParameterExpression row_, RexNode value) {
        switch (value.getKind()) {
            case LAST: 
            case PREV: 
            case CLASSIFIER: {
                SqlMatchFunction matchFunction = (SqlMatchFunction)((RexCall)value).getOperator();
                MatchImplementor matchImplementor = RexImpTable.INSTANCE.get(matchFunction);
                return matchImplementor.implement(translator, (RexCall)value, row_, rows_, symbols_, i_);
            }
            case RUNNING: 
            case FINAL: {
                List<RexNode> operands = ((RexCall)value).getOperands();
                assert (operands.size() == 1);
                switch (operands.get(0).getKind()) {
                    case LAST: 
                    case PREV: 
                    case CLASSIFIER: {
                        RexCall call = (RexCall)operands.get(0);
                        SqlMatchFunction matchFunction = (SqlMatchFunction)call.getOperator();
                        MatchImplementor matchImplementor = RexImpTable.INSTANCE.get(matchFunction);
                        ((PassedRowsInputGetter)translator.inputGetter).setIndex(null);
                        return matchImplementor.implement(translator, call, row_, rows_, symbols_, i_);
                    }
                }
                return translator.translate(operands.get(0));
            }
        }
        return translator.translate(value);
    }

    private Expression implementMatcher(EnumerableRelImplementor implementor, PhysType physType, BlockBuilder builder, ParameterExpression row_) {
        Expression patternBuilder_ = builder.append("patternBuilder", (Expression)Expressions.call((Method)BuiltInMethod.PATTERN_BUILDER.method, (Expression[])new Expression[0]));
        Expression automaton_ = builder.append("automaton", (Expression)Expressions.call((Expression)this.implementPattern(patternBuilder_, this.pattern), (Method)BuiltInMethod.PATTERN_TO_AUTOMATON.method, (Expression[])new Expression[0]));
        Expression matcherBuilder_ = builder.append("matcherBuilder", (Expression)Expressions.call((Method)BuiltInMethod.MATCHER_BUILDER.method, (Expression[])new Expression[]{automaton_}));
        BlockBuilder builder2 = new BlockBuilder();
        for (Map.Entry entry : this.patternDefinitions.entrySet()) {
            RexBuilder rexBuilder = new RexBuilder(implementor.getTypeFactory());
            RexProgramBuilder rexProgramBuilder = new RexProgramBuilder(physType.getRowType(), rexBuilder);
            rexProgramBuilder.addCondition((RexNode)entry.getValue());
            PrevInputGetter inputGetter1 = new PrevInputGetter(row_, physType);
            Expression condition = RexToLixTranslator.translateCondition(rexProgramBuilder.getProgram(), (JavaTypeFactory)this.getCluster().getTypeFactory(), builder2, inputGetter1, implementor.allCorrelateVariables, implementor.getConformance());
            builder2.add((Statement)Expressions.return_(null, (Expression)condition));
            Expression predicate_ = this.implementPredicate(physType, row_, builder2.toBlock());
            matcherBuilder_ = Expressions.call((Expression)matcherBuilder_, (Method)BuiltInMethod.MATCHER_BUILDER_ADD.method, (Expression[])new Expression[]{Expressions.constant(entry.getKey()), predicate_});
        }
        return builder.append("matcher", (Expression)Expressions.call((Expression)matcherBuilder_, (Method)BuiltInMethod.MATCHER_BUILDER_BUILD.method, (Expression[])new Expression[0]));
    }

    private Expression implementPredicate(PhysType physType, ParameterExpression rows_, BlockStatement body) {
        ArrayList<MethodDeclaration> memberDeclarations = new ArrayList<MethodDeclaration>();
        ParameterExpression row_ = Expressions.parameter((Type)Types.of(MemoryFactory.Memory.class, (Type[])new Type[]{physType.getJavaRowType()}), (String)"row_");
        Expressions.assign((Expression)row_, (Expression)Expressions.call((Expression)rows_, (Method)BuiltInMethod.MEMORY_GET0.method, (Expression[])new Expression[0]));
        memberDeclarations.add(EnumUtils.overridingMethodDecl(BuiltInMethod.PREDICATE_TEST.method, (Iterable<ParameterExpression>)ImmutableList.of((Object)row_), body));
        ParameterExpression row0_ = Expressions.parameter(Object.class, (String)"row");
        ParameterExpression rowsO_ = Expressions.parameter(Object.class, (String)"rows");
        BlockBuilder bridgeBody = new BlockBuilder();
        bridgeBody.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)Expressions.parameter(Comparable.class, (String)"this"), (Method)BuiltInMethod.PREDICATE_TEST.method, (Expression[])new Expression[]{Expressions.convert_((Expression)row0_, (Type)Types.of(MemoryFactory.Memory.class, (Type[])new Type[]{physType.getJavaRowType()}))})));
        memberDeclarations.add(EnumUtils.overridingMethodDecl(BuiltInMethod.PREDICATE_TEST.method, (Iterable<ParameterExpression>)ImmutableList.of((Object)row0_), bridgeBody.toBlock()));
        return Expressions.new_((Type)Types.of(Predicate.class, (Type[])new Type[0]), EnumUtils.NO_EXPRS, memberDeclarations);
    }

    private Expression implementPattern(Expression patternBuilder_, RexNode pattern) {
        switch (pattern.getKind()) {
            case LITERAL: {
                String symbol = ((RexLiteral)pattern).getValueAs(String.class);
                return Expressions.call((Expression)patternBuilder_, (Method)BuiltInMethod.PATTERN_BUILDER_SYMBOL.method, (Expression[])new Expression[]{Expressions.constant((Object)symbol)});
            }
            case PATTERN_CONCAT: {
                RexCall concat = (RexCall)pattern;
                for (Ord operand : Ord.zip(concat.operands)) {
                    patternBuilder_ = this.implementPattern(patternBuilder_, (RexNode)operand.e);
                    if (operand.i <= 0) continue;
                    patternBuilder_ = Expressions.call((Expression)patternBuilder_, (Method)BuiltInMethod.PATTERN_BUILDER_SEQ.method, (Expression[])new Expression[0]);
                }
                return patternBuilder_;
            }
        }
        throw new AssertionError((Object)("unknown kind: " + pattern));
    }

    static class PrevInputGetter
    implements RexToLixTranslator.InputGetter {
        private Expression offset;
        private final ParameterExpression row;
        private final Function<Expression, RexToLixTranslator.InputGetter> generator;
        private final PhysType physType;

        PrevInputGetter(ParameterExpression row, PhysType physType) {
            this.row = row;
            this.generator = e -> new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(e, physType)));
            this.physType = physType;
        }

        void setOffset(Expression offset) {
            this.offset = offset;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            ParameterExpression row = Expressions.parameter((Type)this.physType.getJavaRowType());
            ParameterExpression tmp = Expressions.parameter(Object.class);
            list.add((Statement)Expressions.declare((int)0, (ParameterExpression)tmp, (Expression)Expressions.call((Expression)this.row, (Method)BuiltInMethod.MEMORY_GET1.method, (Expression[])new Expression[]{this.offset})));
            list.add((Statement)Expressions.declare((int)0, (ParameterExpression)row, (Expression)Expressions.convert_((Expression)tmp, (Type)this.physType.getJavaRowType())));
            list.add((Statement)Expressions.ifThen((Expression)Expressions.equal((Expression)tmp, (Expression)Expressions.constant(null)), (Node)Expressions.return_(null, (Expression)Expressions.constant((Object)false))));
            return this.generator.apply((Expression)row).field(list, index, storageType);
        }
    }

    static class PassedRowsInputGetter
    implements RexToLixTranslator.InputGetter {
        private Expression index;
        private final ParameterExpression row;
        private final ParameterExpression passedRows;
        private final Function<Expression, RexToLixTranslator.InputGetter> generator;
        private final PhysType physType;

        PassedRowsInputGetter(ParameterExpression row, ParameterExpression passedRows, PhysType physType) {
            this.row = row;
            this.passedRows = passedRows;
            this.generator = e -> new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(e, physType)));
            this.physType = physType;
        }

        void setIndex(Expression index) {
            this.index = index;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            if (this.index == null) {
                return this.generator.apply((Expression)this.row).field(list, index, storageType);
            }
            return Expressions.condition((Expression)Expressions.greaterThanOrEqual((Expression)this.index, (Expression)Expressions.constant((Object)0)), (Expression)this.generator.apply(EnumUtils.convert((Expression)Expressions.call((Expression)this.passedRows, (Method)BuiltInMethod.LIST_GET.method, (Expression[])new Expression[]{this.index}), this.physType.getJavaRowType())).field(list, index, storageType), (Expression)Expressions.constant(null));
        }
    }

    private static class MaxHistoryFutureVisitor
    extends RexVisitorImpl<Void> {
        private int history;
        private int future;

        protected MaxHistoryFutureVisitor() {
            super(true);
        }

        public int getHistory() {
            return this.history;
        }

        public int getFuture() {
            return this.future;
        }

        @Override
        public Void visitCall(RexCall call) {
            call.operands.forEach(o -> o.accept(this));
            switch (call.op.kind) {
                case PREV: {
                    RexLiteral operand = (RexLiteral)call.getOperands().get(1);
                    int prev = operand.getValueAs(Integer.class);
                    this.history = Math.max(this.history, prev);
                    break;
                }
                case NEXT: {
                    RexLiteral operand = (RexLiteral)call.getOperands().get(1);
                    int next = operand.getValueAs(Integer.class);
                    this.future = Math.max(this.future, next);
                }
            }
            return null;
        }

        @Override
        public Void visitSubQuery(RexSubQuery subQuery) {
            return null;
        }
    }
}

