/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.AggImpState;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.AggregateLambdaFactory;
import org.apache.calcite.adapter.enumerable.EnumerableAggregateBase;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.impl.AggResultContextImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;

public class EnumerableAggregate
extends EnumerableAggregateBase
implements EnumerableRel {
    public EnumerableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, (List<RelHint>)ImmutableList.of(), input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() instanceof EnumerableConvention);
        for (AggregateCall aggCall : aggCalls) {
            if (aggCall.isDistinct()) {
                throw new InvalidRelException("distinct aggregation not supported");
            }
            AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
            if (implementor2 != null) continue;
            throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
        }
    }

    @Deprecated
    public EnumerableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        EnumerableAggregate.checkIndicator(indicator);
    }

    @Override
    public EnumerableAggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new EnumerableAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ParameterExpression key_;
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        Expression childExp = builder.append("child", result.block);
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.preferCustom());
        PhysType inputPhysType = result.physType;
        ParameterExpression parameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"a0");
        PhysType keyPhysType = inputPhysType.project(this.groupSet.asList(), this.getGroupType() != Aggregate.Group.SIMPLE, JavaRowFormat.LIST);
        int groupCount = this.getGroupCount();
        ArrayList<AggImpState> aggs = new ArrayList<AggImpState>(this.aggCalls.size());
        for (Ord call : Ord.zip((List)this.aggCalls)) {
            aggs.add(new AggImpState(call.i, (AggregateCall)call.e, false));
        }
        ArrayList<Expression> initExpressions = new ArrayList<Expression>();
        BlockBuilder initBlock = new BlockBuilder();
        List<Type> aggStateTypes = this.createAggStateTypes(initExpressions, initBlock, aggs, typeFactory);
        PhysType accPhysType = PhysTypeImpl.of(typeFactory, typeFactory.createSyntheticType(aggStateTypes));
        this.declareParentAccumulator(initExpressions, initBlock, accPhysType);
        Expression accumulatorInitializer = builder.append("accumulatorInitializer", (Expression)Expressions.lambda(Function0.class, (BlockStatement)initBlock.toBlock(), (ParameterExpression[])new ParameterExpression[0]));
        ParameterExpression inParameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"in");
        ParameterExpression acc_ = Expressions.parameter((Type)accPhysType.getJavaRowType(), (String)"acc");
        this.createAccumulatorAdders(inParameter, aggs, accPhysType, acc_, inputPhysType, builder, implementor, typeFactory);
        ParameterExpression lambdaFactory = Expressions.parameter(AggregateLambdaFactory.class, (String)builder.newName("lambdaFactory"));
        this.implementLambdaFactory(builder, inputPhysType, aggs, accumulatorInitializer, EnumerableAggregate.hasOrderedCall(aggs), lambdaFactory);
        BlockBuilder resultBlock = new BlockBuilder();
        Expressions.FluentList results = Expressions.list();
        if (groupCount == 0) {
            key_ = null;
        } else {
            Type keyType = keyPhysType.getJavaRowType();
            key_ = Expressions.parameter((Type)keyType, (String)"key");
            for (int j = 0; j < groupCount; ++j) {
                Expression ref = keyPhysType.fieldReference((Expression)key_, j);
                if (this.getGroupType() == Aggregate.Group.SIMPLE) {
                    results.add(ref);
                    continue;
                }
                results.add(Expressions.condition((Expression)keyPhysType.fieldReference((Expression)key_, groupCount + j), (Expression)Expressions.constant(null), (Expression)Expressions.box((Expression)ref)));
            }
        }
        for (AggImpState agg : aggs) {
            results.add(agg.implementor.implementResult(agg.context, new AggResultContextImpl(resultBlock, agg.call, agg.state, key_, keyPhysType)));
        }
        resultBlock.add(physType.record((List<Expression>)results));
        if (this.getGroupType() != Aggregate.Group.SIMPLE) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            for (ImmutableBitSet set : this.groupSets) {
                list.add(inputPhysType.generateSelector(parameter, this.groupSet.asList(), set.asList(), keyPhysType.getFormat()));
            }
            Expression keySelectors_ = builder.append("keySelectors", (Expression)Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, list));
            Expression resultSelector = builder.append("resultSelector", (Expression)Expressions.lambda(Function2.class, (BlockStatement)resultBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{key_, acc_}));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.GROUP_BY_MULTIPLE.method, (Iterable)Expressions.list((Object[])new Expression[]{childExp, keySelectors_, Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, (Expression[])new Expression[0]), Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, (Expression[])new Expression[0]), Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_RESULT_SELECTOR.method, (Expression[])new Expression[]{resultSelector})}).appendIfNotNull((Object)keyPhysType.comparer()))));
        } else if (groupCount == 0) {
            Expression resultSelector = builder.append("resultSelector", (Expression)Expressions.lambda(Function1.class, (BlockStatement)resultBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{acc_}));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.call((Expression)childExp, (Method)BuiltInMethod.AGGREGATE.method, (Expression[])new Expression[]{Expressions.call((Expression)Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, (Expression[])new Expression[0]), (Method)BuiltInMethod.FUNCTION0_APPLY.method, (Expression[])new Expression[0]), Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, (Expression[])new Expression[0]), Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_SINGLE_GROUP_RESULT_SELECTOR.method, (Expression[])new Expression[]{resultSelector})})})));
        } else if (this.aggCalls.isEmpty() && this.groupSet.equals(ImmutableBitSet.range(child.getRowType().getFieldCount()))) {
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)inputPhysType.convertTo(childExp, physType.getFormat()), (Method)BuiltInMethod.DISTINCT.method, (Iterable)Expressions.list().appendIfNotNull((Object)physType.comparer()))));
        } else {
            Expression keySelector_ = builder.append("keySelector", inputPhysType.generateSelector(parameter, this.groupSet.asList(), keyPhysType.getFormat()));
            Expression resultSelector_ = builder.append("resultSelector", (Expression)Expressions.lambda(Function2.class, (BlockStatement)resultBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{key_, acc_}));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltInMethod.GROUP_BY2.method, (Iterable)Expressions.list((Object[])new Expression[]{keySelector_, Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, (Expression[])new Expression[0]), Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, (Expression[])new Expression[0]), Expressions.call((Expression)lambdaFactory, (Method)BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_RESULT_SELECTOR.method, (Expression[])new Expression[]{resultSelector_})}).appendIfNotNull((Object)keyPhysType.comparer()))));
        }
        return implementor.result(physType, builder.toBlock());
    }
}

