/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRules;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.rel.rules.AggregateStarTableRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.FilterTableScanRule;
import org.apache.calcite.rel.rules.JoinAssociateRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.LoptOptimizeJoinRule;
import org.apache.calcite.rel.rules.MatchRule;
import org.apache.calcite.rel.rules.MultiJoinOptimizeBushyRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.SemiJoinRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.SubQueryRemoveRule;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;

public class Programs {
    @Deprecated
    public static final ImmutableList<RelOptRule> CALC_RULES = RelOptRules.CALC_RULES;
    public static final Program CALC_PROGRAM = Programs.calc(DefaultRelMetadataProvider.INSTANCE);
    public static final Program SUB_QUERY_PROGRAM = Programs.subQuery(DefaultRelMetadataProvider.INSTANCE);
    public static final ImmutableSet<RelOptRule> RULE_SET = ImmutableSet.of((Object)EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE, (Object)EnumerableRules.ENUMERABLE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_CORRELATE_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_RULE, (Object[])new RelOptRule[]{EnumerableRules.ENUMERABLE_AGGREGATE_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_LIMIT_RULE, EnumerableRules.ENUMERABLE_UNION_RULE, EnumerableRules.ENUMERABLE_INTERSECT_RULE, EnumerableRules.ENUMERABLE_MINUS_RULE, EnumerableRules.ENUMERABLE_TABLE_MODIFICATION_RULE, EnumerableRules.ENUMERABLE_VALUES_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_MATCH_RULE, SemiJoinRule.PROJECT, SemiJoinRule.JOIN, MatchRule.INSTANCE, CalciteSystemProperty.COMMUTE.value() != false ? JoinAssociateRule.INSTANCE : ProjectMergeRule.INSTANCE, AggregateStarTableRule.INSTANCE, AggregateStarTableRule.INSTANCE2, FilterTableScanRule.INSTANCE, FilterProjectTransposeRule.INSTANCE, FilterJoinRule.FILTER_ON_JOIN, AggregateExpandDistinctAggregatesRule.INSTANCE, AggregateReduceFunctionsRule.INSTANCE, FilterAggregateTransposeRule.INSTANCE, JoinCommuteRule.INSTANCE, JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, SortProjectTransposeRule.INSTANCE});

    private Programs() {
    }

    public static Program of(RuleSet ruleSet) {
        return new RuleSetProgram(ruleSet);
    }

    public static List<Program> listOf(RuleSet ... ruleSets) {
        return Lists.transform(Arrays.asList(ruleSets), Programs::of);
    }

    public static List<Program> listOf(List<RuleSet> ruleSets) {
        return Lists.transform(ruleSets, Programs::of);
    }

    public static Program ofRules(RelOptRule ... rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program ofRules(Iterable<? extends RelOptRule> rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program sequence(Program ... programs) {
        return new SequenceProgram((ImmutableList<Program>)ImmutableList.copyOf((Object[])programs));
    }

    public static Program hep(Iterable<? extends RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule relOptRule : rules) {
            builder.addRuleInstance(relOptRule);
        }
        return Programs.of(builder.build(), noDag, metadataProvider);
    }

    public static Program of(HepProgram hepProgram, boolean noDag, RelMetadataProvider metadataProvider) {
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            HepPlanner hepPlanner = new HepPlanner(hepProgram, null, noDag, null, RelOptCostImpl.FACTORY);
            ArrayList<RelMetadataProvider> list = new ArrayList<RelMetadataProvider>();
            if (metadataProvider != null) {
                list.add(metadataProvider);
            }
            hepPlanner.registerMetadataProviders(list);
            for (RelOptMaterialization materialization : materializations) {
                hepPlanner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                hepPlanner.addLattice(lattice);
            }
            RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
            rel.getCluster().setMetadataProvider(plannerChain);
            hepPlanner.setRoot(rel);
            return hepPlanner.findBestExp();
        };
    }

    public static Program heuristicJoinOrder(Iterable<? extends RelOptRule> rules, boolean bushy, int minJoinCount) {
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            Program program;
            int joinCount = RelOptUtil.countJoins(rel);
            if (joinCount < minJoinCount) {
                program = Programs.ofRules(rules);
            } else {
                HepProgram hep = new HepProgramBuilder().addRuleInstance(FilterJoinRule.FILTER_ON_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance(JoinToMultiJoinRule.INSTANCE).build();
                Program program1 = Programs.of(hep, false, DefaultRelMetadataProvider.INSTANCE);
                ArrayList list = Lists.newArrayList((Iterable)rules);
                list.removeAll((Collection<?>)ImmutableList.of((Object)JoinCommuteRule.INSTANCE, (Object)JoinAssociateRule.INSTANCE, (Object)JoinPushThroughJoinRule.LEFT, (Object)JoinPushThroughJoinRule.RIGHT));
                list.add(bushy ? MultiJoinOptimizeBushyRule.INSTANCE : LoptOptimizeJoinRule.INSTANCE);
                Program program2 = Programs.ofRules(list);
                program = Programs.sequence(program1, program2);
            }
            return program.run(planner, rel, requiredOutputTraits, materializations, lattices);
        };
    }

    public static Program calc(RelMetadataProvider metadataProvider) {
        return Programs.hep(RelOptRules.CALC_RULES, true, metadataProvider);
    }

    @Deprecated
    public static Program subquery(RelMetadataProvider metadataProvider) {
        return Programs.subQuery(metadataProvider);
    }

    public static Program subQuery(RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        builder.addRuleCollection((Collection<RelOptRule>)ImmutableList.of((Object)SubQueryRemoveRule.FILTER, (Object)SubQueryRemoveRule.PROJECT, (Object)SubQueryRemoveRule.JOIN));
        return Programs.of(builder.build(), true, metadataProvider);
    }

    public static Program getProgram() {
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> null;
    }

    public static Program standard() {
        return Programs.standard(DefaultRelMetadataProvider.INSTANCE);
    }

    public static Program standard(RelMetadataProvider metadataProvider) {
        Program program1 = (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            RelNode rootRel2;
            planner.setRoot(rel);
            for (RelOptMaterialization materialization : materializations) {
                planner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                planner.addLattice(lattice);
            }
            RelNode relNode = rootRel2 = rel.getTraitSet().equals(requiredOutputTraits) ? rel : planner.changeTraits(rel, requiredOutputTraits);
            assert (rootRel2 != null);
            planner.setRoot(rootRel2);
            RelOptPlanner planner2 = planner.chooseDelegate();
            RelNode rootRel3 = planner2.findBestExp();
            assert (rootRel3 != null) : "could not implement exp";
            return rootRel3;
        };
        return Programs.sequence(Programs.subQuery(metadataProvider), new DecorrelateProgram(), new TrimFieldsProgram(), program1, Programs.calc(metadataProvider));
    }

    private static class TrimFieldsProgram
    implements Program {
        private TrimFieldsProgram() {
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
            return new RelFieldTrimmer(null, relBuilder).trim(rel);
        }
    }

    private static class DecorrelateProgram
    implements Program {
        private DecorrelateProgram() {
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            CalciteConnectionConfig config = planner.getContext().unwrap(CalciteConnectionConfig.class);
            if (config != null && config.forceDecorrelate()) {
                RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
                return RelDecorrelator.decorrelateQuery(rel, relBuilder);
            }
            return rel;
        }
    }

    private static class SequenceProgram
    implements Program {
        private final ImmutableList<Program> programs;

        SequenceProgram(ImmutableList<Program> programs) {
            this.programs = programs;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            for (Program program : this.programs) {
                rel = program.run(planner, rel, requiredOutputTraits, materializations, lattices);
            }
            return rel;
        }
    }

    static class RuleSetProgram
    implements Program {
        final RuleSet ruleSet;

        private RuleSetProgram(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            planner.clear();
            for (RelOptRule rule : this.ruleSet) {
                planner.addRule(rule);
            }
            for (RelOptMaterialization materialization : materializations) {
                planner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                planner.addLattice(lattice);
            }
            if (!rel.getTraitSet().equals(requiredOutputTraits)) {
                rel = planner.changeTraits(rel, requiredOutputTraits);
            }
            planner.setRoot(rel);
            return planner.findBestExp();
        }
    }
}

