/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.IndexExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;

public class RexExecutorImpl
implements RexExecutor {
    private final DataContext dataContext;

    public RexExecutorImpl(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    private static String compile(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter) {
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelDataType emptyRowType = typeFactory.builder().build();
        return RexExecutorImpl.compile(rexBuilder, constExps, getter, emptyRowType);
    }

    private static String compile(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter, RelDataType rowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(rowType, rexBuilder);
        for (RexNode node : constExps) {
            programBuilder.addProject(node, "c" + programBuilder.getProjectList().size());
        }
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(rexBuilder.getTypeFactory().getTypeSystem());
        BlockBuilder blockBuilder = new BlockBuilder();
        ParameterExpression root0_ = Expressions.parameter(Object.class, (String)"root0");
        ParameterExpression root_ = DataContext.ROOT;
        blockBuilder.add((Statement)Expressions.declare((int)16, (ParameterExpression)root_, (Expression)Expressions.convert_((Expression)root0_, DataContext.class)));
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        RexProgram program = programBuilder.getProgram();
        List<Expression> expressions = RexToLixTranslator.translateProjects(program, javaTypeFactory, conformance, blockBuilder, null, (Expression)root_, getter, null);
        blockBuilder.add((Statement)Expressions.return_(null, (Expression)Expressions.newArrayInit(Object[].class, expressions)));
        MethodDeclaration methodDecl = Expressions.methodDecl((int)1, Object[].class, (String)BuiltInMethod.FUNCTION1_APPLY.method.getName(), (Iterable)ImmutableList.of((Object)root0_), (BlockStatement)blockBuilder.toBlock());
        String code = Expressions.toString((Node)methodDecl);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, code);
        }
        return code;
    }

    public static RexExecutable getExecutable(RexBuilder rexBuilder, List<RexNode> exps, RelDataType rowType) {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(rexBuilder.getTypeFactory().getTypeSystem());
        DataContextInputGetter getter = new DataContextInputGetter(rowType, typeFactory);
        String code = RexExecutorImpl.compile(rexBuilder, exps, getter, rowType);
        return new RexExecutable(code, "generated Rex code");
    }

    @Override
    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        String code = RexExecutorImpl.compile(rexBuilder, constExps, (list, index, storageType) -> {
            throw new UnsupportedOperationException();
        });
        RexExecutable executable = new RexExecutable(code, constExps);
        executable.setDataContext(this.dataContext);
        executable.reduce(rexBuilder, constExps, reducedValues);
    }

    private static class DataContextInputGetter
    implements RexToLixTranslator.InputGetter {
        private final RelDataTypeFactory typeFactory;
        private final RelDataType rowType;

        DataContextInputGetter(RelDataType rowType, RelDataTypeFactory typeFactory) {
            this.rowType = rowType;
            this.typeFactory = typeFactory;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            MethodCallExpression recFromCtx = Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)"inputRecord")});
            Expression recFromCtxCasted = EnumUtils.convert((Expression)recFromCtx, Object[].class);
            IndexExpression recordAccess = Expressions.arrayIndex((Expression)recFromCtxCasted, (Expression)Expressions.constant((Object)index));
            if (storageType == null) {
                RelDataType fieldType = this.rowType.getFieldList().get(index).getType();
                storageType = ((JavaTypeFactory)this.typeFactory).getJavaClass(fieldType);
            }
            return EnumUtils.convert((Expression)recordAccess, storageType);
        }
    }
}

