/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.Bytes;
import herddb.utils.ILocalLockManager;
import herddb.utils.LockHandle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LegacyLocalLockManager
implements ILocalLockManager {
    private static final Logger LOGGER = Logger.getLogger(LegacyLocalLockManager.class.getName());
    private final ConcurrentMap<Bytes, LockInstance> locks = new ConcurrentHashMap<Bytes, LockInstance>();
    private int writeLockTimeout = 1800;
    private int readLockTimeout = 1800;

    private StampedLock makeLock() {
        return new StampedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StampedLock makeLockForKey(Bytes key) {
        LockInstance instance = this.locks.computeIfAbsent(key, k -> {
            LockInstance li = new LockInstance(this.makeLock(), 1);
            li.lock();
            return li;
        });
        try {
            if (!instance.isHeldByCurrentThread()) {
                instance.lock();
                if (instance.count < 1) {
                    StampedLock stampedLock = this.makeLockForKey(key);
                    return stampedLock;
                }
                ++instance.count;
            }
        }
        finally {
            instance.unlock();
        }
        return instance.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StampedLock returnLockForKey(Bytes key) throws IllegalStateException {
        LockInstance instance = (LockInstance)this.locks.get(key);
        if (instance == null) {
            LOGGER.log(Level.SEVERE, "no lock object exists for key {0}", key);
            throw new IllegalStateException("no lock object exists for key " + key);
        }
        instance.lock();
        try {
            if (--instance.count < 1) {
                if (instance.count < 0) {
                    LOGGER.log(Level.SEVERE, "too much lock releases for key {0}", key);
                    throw new IllegalStateException("too much lock releases for key " + key);
                }
                boolean ok = this.locks.remove(key, instance);
                if (!ok) {
                    throw new IllegalStateException("illegal lock releases for key " + key);
                }
            }
        }
        finally {
            instance.unlock();
        }
        return instance.lock;
    }

    public int getWriteLockTimeout() {
        return this.writeLockTimeout;
    }

    public void setWriteLockTimeout(int writeLockTimeout) {
        this.writeLockTimeout = writeLockTimeout;
    }

    public int getReadLockTimeout() {
        return this.readLockTimeout;
    }

    public void setReadLockTimeout(int readLockTimeout) {
        this.readLockTimeout = readLockTimeout;
    }

    @Override
    public LockHandle acquireWriteLockForKey(Bytes key) {
        StampedLock lock = this.makeLockForKey(key);
        try {
            long tryWriteLock = lock.tryWriteLock(this.writeLockTimeout, TimeUnit.SECONDS);
            if (tryWriteLock == 0L) {
                throw new RuntimeException("timed out acquiring lock for write");
            }
            return new LockHandle(tryWriteLock, key, true);
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(err);
        }
    }

    @Override
    public void releaseWriteLock(LockHandle handle) {
        StampedLock lock = this.returnLockForKey(handle.key);
        lock.unlockWrite(handle.stamp);
    }

    @Override
    public LockHandle acquireReadLockForKey(Bytes key) {
        StampedLock lock = this.makeLockForKey(key);
        try {
            long tryReadLock = lock.tryReadLock(this.readLockTimeout, TimeUnit.SECONDS);
            if (tryReadLock == 0L) {
                throw new RuntimeException("timedout trying to read lock");
            }
            return new LockHandle(tryReadLock, key, false);
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(err);
        }
    }

    @Override
    public void releaseReadLock(LockHandle handle) {
        StampedLock lock = this.returnLockForKey(handle.key);
        lock.unlockRead(handle.stamp);
    }

    @Override
    public void releaseLock(LockHandle handle) {
        if (handle == null) {
            return;
        }
        if (handle.write) {
            this.releaseWriteLock(handle);
        } else {
            this.releaseReadLock(handle);
        }
    }

    @Override
    public void clear() {
        this.locks.clear();
    }

    @Override
    public int getNumKeys() {
        return this.locks.size();
    }

    private static class LockInstance
    extends ReentrantLock {
        private final StampedLock lock;
        private int count;

        public LockInstance(StampedLock lock, int count) {
            this.lock = lock;
            this.count = count;
        }
    }
}

