/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.DeleteFileVisitor;
import herddb.utils.SystemProperties;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileUtils {
    private static final boolean USE_DIRECT_BUFFER = SystemProperties.getBooleanSystemProperty("herddb.nio.usedirectmemory", false);

    public static void cleanDirectory(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(directory, DeleteFileVisitor.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fastReadFile(Path f) throws IOException {
        int len = (int)Files.size(f);
        if (USE_DIRECT_BUFFER) {
            try (SeekableByteChannel c = Files.newByteChannel(f, StandardOpenOption.READ);){
                byte[] byArray;
                ByteBuffer buffer = ByteBuffer.allocateDirect(len);
                try {
                    long res = c.read(buffer);
                    if (res != (long)len) {
                        throw new IOException("not all file " + f.toAbsolutePath() + " was read with NIO len=" + len + " writeen=" + res);
                    }
                    buffer.flip();
                    byte[] result = new byte[len];
                    buffer.get(result);
                    byArray = result;
                }
                catch (Throwable throwable) {
                    FileUtils.forceReleaseBuffer(buffer);
                    throw throwable;
                }
                FileUtils.forceReleaseBuffer(buffer);
                return byArray;
            }
        }
        byte[] result = new byte[len];
        try (RandomAccessFile raf = new RandomAccessFile(f.toFile(), "r");){
            long res = raf.read(result, 0, len);
            if (res != (long)len) {
                throw new IOException("not all file " + f.toAbsolutePath() + " was read with NIO len=" + len + " read=" + res);
            }
        }
        return result;
    }

    public static void forceReleaseBuffer(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return;
        }
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }
}

