/*
 * Decompiled with CFR 0.152.
 */
package herddb.proto;

import herddb.proto.Pdu;
import herddb.utils.ByteBufUtils;
import herddb.utils.DataAccessor;
import herddb.utils.IntHolder;
import herddb.utils.KeyValue;
import herddb.utils.RawString;
import herddb.utils.RecordsBatch;
import herddb.utils.TuplesList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class PduCodec {
    public static final byte VERSION_3 = 3;
    private static final int ONE_BYTE = 1;
    private static final int ONE_INT = 4;
    private static final int ONE_LONG = 8;
    private static final int MSGID_SIZE = 8;
    private static final int TYPE_SIZE = 1;
    private static final int FLAGS_SIZE = 1;
    private static final int VERSION_SIZE = 1;
    private static final int NULLABLE_FIELD_PRESENT = 1;
    private static final int NULLABLE_FIELD_ABSENT = 0;
    public static final byte TYPE_STRING = 0;
    public static final byte TYPE_LONG = 1;
    public static final byte TYPE_INTEGER = 2;
    public static final byte TYPE_BYTEARRAY = 3;
    public static final byte TYPE_TIMESTAMP = 4;
    public static final byte TYPE_NULL = 5;
    public static final byte TYPE_DOUBLE = 6;
    public static final byte TYPE_BOOLEAN = 7;
    public static final byte TYPE_SHORT = 8;
    public static final byte TYPE_BYTE = 9;

    public static Pdu decodePdu(ByteBuf in) throws IOException {
        byte version = in.getByte(0);
        if (version == 3) {
            byte flags = in.getByte(1);
            byte type = in.getByte(2);
            long messageId = in.getLong(3);
            return Pdu.newPdu(in, type, flags, messageId);
        }
        throw new IOException("Cannot decode version " + version);
    }

    private static void writeObject(ByteBuf byteBuf, Object v) {
        if (v == null) {
            byteBuf.writeByte(5);
        } else if (v instanceof RawString) {
            byteBuf.writeByte(0);
            ByteBufUtils.writeRawString(byteBuf, (RawString)v);
        } else if (v instanceof String) {
            byteBuf.writeByte(0);
            ByteBufUtils.writeString(byteBuf, (String)v);
        } else if (v instanceof Long) {
            byteBuf.writeByte(1);
            byteBuf.writeLong(((Long)v).longValue());
        } else if (v instanceof Integer) {
            byteBuf.writeByte(2);
            byteBuf.writeInt(((Integer)v).intValue());
        } else if (v instanceof Boolean) {
            byteBuf.writeByte(7);
            byteBuf.writeBoolean(((Boolean)v).booleanValue());
        } else if (v instanceof Date) {
            byteBuf.writeByte(4);
            byteBuf.writeLong(((Date)v).getTime());
        } else if (v instanceof Double) {
            byteBuf.writeByte(6);
            byteBuf.writeDouble(((Double)v).doubleValue());
        } else if (v instanceof Float) {
            byteBuf.writeByte(6);
            byteBuf.writeDouble((double)((Float)v).floatValue());
        } else if (v instanceof Short) {
            byteBuf.writeByte(8);
            byteBuf.writeLong((long)((Short)v).shortValue());
        } else if (v instanceof byte[]) {
            byteBuf.writeByte(3);
            ByteBufUtils.writeArray(byteBuf, (byte[])v);
        } else if (v instanceof Byte) {
            byteBuf.writeByte(9);
            byteBuf.writeByte((int)((Byte)v).byteValue());
        } else {
            throw new IllegalArgumentException("bad data type " + v.getClass());
        }
    }

    public static Object readObject(ByteBuf dii) {
        int type = ByteBufUtils.readVInt(dii);
        switch (type) {
            case 3: {
                return ByteBufUtils.readArray(dii);
            }
            case 1: {
                return dii.readLong();
            }
            case 2: {
                return dii.readInt();
            }
            case 8: {
                return dii.readShort();
            }
            case 9: {
                return dii.readByte();
            }
            case 0: {
                return ByteBufUtils.readUnpooledRawString(dii);
            }
            case 4: {
                return new Timestamp(dii.readLong());
            }
            case 5: {
                return null;
            }
            case 7: {
                return dii.readBoolean();
            }
            case 6: {
                return dii.readDouble();
            }
        }
        throw new IllegalArgumentException("bad column type " + type);
    }

    public static class ObjectListReader {
        private final Pdu pdu;
        private final int numParams;

        public ObjectListReader(Pdu pdu, int numParams) {
            this.pdu = pdu;
            this.numParams = numParams;
        }

        public int getNumParams() {
            return this.numParams;
        }

        public Object nextObject() {
            return PduCodec.readObject(this.pdu.buffer);
        }
    }

    public static class ListOfListsReader {
        private final Pdu pdu;
        private final int numLists;

        public ListOfListsReader(Pdu pdu, int numLists) {
            this.pdu = pdu;
            this.numLists = numLists;
        }

        public int getNumLists() {
            return this.numLists;
        }

        public ObjectListReader nextList() {
            int numValues = ByteBufUtils.readVInt(this.pdu.buffer);
            return new ObjectListReader(this.pdu, numValues);
        }
    }

    public static class PushTransactionsBlock {
        public static ByteBuf write(long messageId, String tableSpace, List<byte[]> records) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(11 + tableSpace.length() + records.size() * 512);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(20);
            byteBuf.writeLong(messageId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            byteBuf.writeInt(records.size());
            for (byte[] tx : records) {
                ByteBufUtils.writeArray(byteBuf, tx);
            }
            return byteBuf;
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            return ByteBufUtils.readString(buffer);
        }

        public static void readTransactions(Pdu pdu, Consumer<byte[]> consumer) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            ByteBufUtils.skipArray(buffer);
            int numRecords = buffer.readInt();
            for (int i = 0; i < numRecords; ++i) {
                byte[] key = ByteBufUtils.readArray(buffer);
                consumer.accept(key);
            }
        }
    }

    public static class PushTxLogChunk {
        public static ByteBuf write(long messageId, String tableSpace, List<KeyValue> records) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(11 + tableSpace.length() + records.size() * 512);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(17);
            byteBuf.writeLong(messageId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            byteBuf.writeInt(records.size());
            for (KeyValue kv : records) {
                ByteBufUtils.writeArray(byteBuf, kv.key);
                ByteBufUtils.writeArray(byteBuf, kv.value);
            }
            return byteBuf;
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            return ByteBufUtils.readString(buffer);
        }

        public static void readRecords(Pdu pdu, BiConsumer<byte[], byte[]> consumer) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            ByteBufUtils.skipArray(buffer);
            int numRecords = buffer.readInt();
            for (int i = 0; i < numRecords; ++i) {
                byte[] key = ByteBufUtils.readArray(buffer);
                byte[] value = ByteBufUtils.readArray(buffer);
                consumer.accept(key, value);
            }
        }
    }

    public static class PushTableData {
        public static ByteBuf write(long messageId, String tableSpace, String tableName, List<KeyValue> records) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(11 + tableSpace.length() + tableName.length() + records.size() * 512);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(14);
            byteBuf.writeLong(messageId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeString(byteBuf, tableName);
            byteBuf.writeInt(records.size());
            for (KeyValue kv : records) {
                ByteBufUtils.writeArray(byteBuf, kv.key);
                ByteBufUtils.writeArray(byteBuf, kv.value);
            }
            return byteBuf;
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            return ByteBufUtils.readString(buffer);
        }

        public static String readTablename(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }

        public static void readRecords(Pdu pdu, BiConsumer<byte[], byte[]> consumer) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            int numRecords = buffer.readInt();
            for (int i = 0; i < numRecords; ++i) {
                byte[] key = ByteBufUtils.readArray(buffer);
                byte[] value = ByteBufUtils.readArray(buffer);
                consumer.accept(key, value);
            }
        }
    }

    public static class RestoreFinished {
        public static ByteBuf write(long messageId, String tableSpace) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(11 + tableSpace.length());
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(23);
            byteBuf.writeLong(messageId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            return byteBuf;
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            return ByteBufUtils.readString(buffer);
        }
    }

    public static class TableRestoreFinished {
        public static ByteBuf write(long messageId, String tableSpace, String tableName, List<byte[]> indexesDefinition) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(11 + tableSpace.length() + tableName.length() + (indexesDefinition == null ? 0 : indexesDefinition.size() * 64));
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(19);
            byteBuf.writeLong(messageId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeString(byteBuf, tableName);
            if (indexesDefinition == null) {
                byteBuf.writeInt(0);
            } else {
                byteBuf.writeInt(indexesDefinition.size());
                for (int i = 0; i < indexesDefinition.size(); ++i) {
                    ByteBufUtils.writeArray(byteBuf, indexesDefinition.get(i));
                }
            }
            return byteBuf;
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            return ByteBufUtils.readString(buffer);
        }

        public static String readTableName(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }

        public static List<byte[]> readIndexesDefinition(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            int num = buffer.readInt();
            ArrayList<byte[]> res = new ArrayList<byte[]>();
            for (int i = 0; i < num; ++i) {
                res.add(ByteBufUtils.readArray(buffer));
            }
            return res;
        }
    }

    public static class RequestTableRestore {
        public static ByteBuf write(long messageId, String tableSpace, byte[] tableDefinition, long dumpLedgerId, long dumpOffset) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(27 + tableSpace.length() + tableDefinition.length);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(13);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(dumpLedgerId);
            byteBuf.writeLong(dumpOffset);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeArray(byteBuf, tableDefinition);
            return byteBuf;
        }

        public static long readLedgerId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(11);
        }

        public static long readOffset(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(19);
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(27);
            return ByteBufUtils.readString(buffer);
        }

        public static byte[] readTableDefinition(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(27);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readArray(buffer);
        }
    }

    public static class TablespaceDumpData {
        public static ByteBuf write(long messageId, String tableSpace, String dumpId, String command, byte[] tableDefinition, long estimatedSize, long dumpLedgerid, long dumpOffset, List<byte[]> indexesDefinition, List<KeyValue> records) {
            if (tableDefinition == null) {
                tableDefinition = new byte[]{};
            }
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(16 + tableDefinition.length + tableSpace.length() + dumpId.length());
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(12);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(dumpLedgerid);
            byteBuf.writeLong(dumpOffset);
            byteBuf.writeLong(estimatedSize);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeString(byteBuf, dumpId);
            ByteBufUtils.writeString(byteBuf, command);
            ByteBufUtils.writeArray(byteBuf, tableDefinition);
            if (indexesDefinition == null) {
                byteBuf.writeInt(0);
            } else {
                byteBuf.writeInt(indexesDefinition.size());
                for (int i = 0; i < indexesDefinition.size(); ++i) {
                    ByteBufUtils.writeArray(byteBuf, indexesDefinition.get(i));
                }
            }
            if (records == null) {
                byteBuf.writeInt(0);
            } else {
                byteBuf.writeInt(records.size());
                for (KeyValue kv : records) {
                    ByteBufUtils.writeArray(byteBuf, kv.key);
                    ByteBufUtils.writeArray(byteBuf, kv.value);
                }
            }
            return byteBuf;
        }

        public static long readLedgerId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(11);
        }

        public static long readOffset(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(19);
        }

        public static long readEstimatedSize(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(27);
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(35);
            return ByteBufUtils.readString(buffer);
        }

        public static String readDumpId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(35);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }

        public static String readCommand(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(35);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }

        public static byte[] readTableDefinition(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(35);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readArray(buffer);
        }

        public static List<byte[]> readIndexesDefinition(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(35);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            int num = buffer.readInt();
            ArrayList<byte[]> res = new ArrayList<byte[]>();
            for (int i = 0; i < num; ++i) {
                res.add(ByteBufUtils.readArray(buffer));
            }
            return res;
        }

        public static void readRecords(Pdu pdu, BiConsumer<byte[], byte[]> consumer) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(35);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            int num = buffer.readInt();
            for (int i = 0; i < num; ++i) {
                ByteBufUtils.skipArray(buffer);
            }
            int numRecords = buffer.readInt();
            for (int i = 0; i < numRecords; ++i) {
                byte[] key = ByteBufUtils.readArray(buffer);
                byte[] value = ByteBufUtils.readArray(buffer);
                consumer.accept(key, value);
            }
        }
    }

    public static class RequestTablespaceDump {
        public static ByteBuf write(long messageId, String tableSpace, String dumpId, int fetchSize, boolean includeTransactionLog) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(16 + tableSpace.length() + dumpId.length());
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(11);
            byteBuf.writeLong(messageId);
            byteBuf.writeByte(includeTransactionLog ? 1 : 0);
            byteBuf.writeInt(fetchSize);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeString(byteBuf, dumpId);
            return byteBuf;
        }

        public static boolean readInludeTransactionLog(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getByte(11) == 1;
        }

        public static int readFetchSize(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getInt(12);
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(16);
            return ByteBufUtils.readString(buffer);
        }

        public static String readDumpId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(16);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }
    }

    public static class PrepareStatement {
        public static ByteBuf write(long messageId, String tableSpace, String query) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(11);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(103);
            byteBuf.writeLong(messageId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeString(byteBuf, query);
            return byteBuf;
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            return ByteBufUtils.readString(buffer);
        }

        public static String readQuery(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(11);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }
    }

    public static class ExecuteStatement {
        public static ByteBuf write(long messageId, String tableSpace, String query, long tx, boolean returnValues, long statementId, List<Object> params) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(20 + tableSpace.length() + query.length() + 1 + params.size() * 8);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(5);
            byteBuf.writeLong(messageId);
            byteBuf.writeByte(returnValues ? 1 : 0);
            byteBuf.writeLong(tx);
            byteBuf.writeLong(statementId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeString(byteBuf, query);
            ByteBufUtils.writeVInt(byteBuf, params.size());
            for (Object p : params) {
                PduCodec.writeObject(byteBuf, p);
            }
            return byteBuf;
        }

        public static boolean readReturnValues(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getByte(11) == 1;
        }

        public static long readTx(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(12);
        }

        public static long readStatementId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(20);
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(28);
            return ByteBufUtils.readString(buffer);
        }

        public static String readQuery(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(28);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }

        public static ObjectListReader startReadParameters(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(28);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            int numParams = ByteBufUtils.readVInt(buffer);
            return new ObjectListReader(pdu, numParams);
        }
    }

    public static class ExecuteStatements {
        public static ByteBuf write(long messageId, String tableSpace, String query, long tx, boolean returnValues, long statementId, List<List<Object>> statements) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(29 + statements.size() * 64);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(15);
            byteBuf.writeLong(messageId);
            byteBuf.writeByte(returnValues ? 1 : 0);
            byteBuf.writeLong(tx);
            byteBuf.writeLong(statementId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeString(byteBuf, query);
            ByteBufUtils.writeVInt(byteBuf, statements.size());
            for (List<Object> list : statements) {
                ByteBufUtils.writeVInt(byteBuf, list.size());
                for (Object param : list) {
                    PduCodec.writeObject(byteBuf, param);
                }
            }
            return byteBuf;
        }

        public static boolean readReturnValues(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getByte(11) == 1;
        }

        public static long readTx(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(12);
        }

        public static long readStatementId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(20);
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(28);
            return ByteBufUtils.readString(buffer);
        }

        public static String readQuery(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(28);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }

        public static ListOfListsReader startReadStatementsParameters(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(28);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            int numLists = ByteBufUtils.readVInt(buffer);
            return new ListOfListsReader(pdu, numLists);
        }
    }

    public static class CloseScanner {
        public static ByteBuf write(long messageId, long scannerId) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(19);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(9);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(scannerId);
            return byteBuf;
        }

        public static long readScannerId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(11);
        }
    }

    public static class FetchScannerData {
        public static ByteBuf write(long messageId, long scannerId, int fetchSize) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(23);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(10);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(scannerId);
            byteBuf.writeInt(fetchSize);
            return byteBuf;
        }

        public static long readScannerId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(11);
        }

        public static int readFetchSize(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getInt(19);
        }
    }

    public static class ResultSetChunk {
        private static int estimateTupleListSize(TuplesList data) {
            return data.tuples.size() * 1024 + data.columnNames.length * 64;
        }

        public static ByteBuf write(long messageId, TuplesList tuplesList, boolean last, long tx) {
            int dataSize = ResultSetChunk.estimateTupleListSize(tuplesList);
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(20 + dataSize);
            byteBuf.writeByte(3);
            byteBuf.writeByte(2);
            byteBuf.writeByte(8);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(tx);
            byteBuf.writeByte(last ? 1 : 0);
            int numColumns = tuplesList.columnNames.length;
            byteBuf.writeInt(numColumns);
            for (String columnName : tuplesList.columnNames) {
                ByteBufUtils.writeString(byteBuf, columnName);
            }
            byteBuf.writeInt(tuplesList.tuples.size());
            for (DataAccessor da : tuplesList.tuples) {
                IntHolder currentColumn = new IntHolder();
                da.forEach((key, value) -> {
                    String expectedColumnName = tuplesList.columnNames[currentColumn.value];
                    while (!key.equals(expectedColumnName)) {
                        PduCodec.writeObject(byteBuf, null);
                        ++currentColumn.value;
                        expectedColumnName = tuplesList.columnNames[currentColumn.value];
                    }
                    PduCodec.writeObject(byteBuf, value);
                    ++currentColumn.value;
                });
                while (currentColumn.value < numColumns) {
                    PduCodec.writeObject(byteBuf, null);
                    ++currentColumn.value;
                }
                if (currentColumn.value <= numColumns) continue;
                throw new RuntimeException("unexpected number of columns " + currentColumn.value + " > " + numColumns);
            }
            return byteBuf;
        }

        public static long readTx(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(11);
        }

        public static boolean readIsLast(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getByte(19) == 1;
        }

        public static RecordsBatch startReadingData(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(20);
            return new RecordsBatch(pdu);
        }
    }

    public static class OpenScanner {
        public static ByteBuf write(long messageId, String tableSpace, String query, long scannerId, long tx, List<Object> params, long statementId, int fetchSize, int maxRows) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(44 + tableSpace.length() + 2 + query.length() + 1 + params.size() * 8);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(7);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(tx);
            byteBuf.writeLong(statementId);
            byteBuf.writeInt(fetchSize);
            byteBuf.writeInt(maxRows);
            byteBuf.writeLong(scannerId);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            ByteBufUtils.writeString(byteBuf, query);
            ByteBufUtils.writeVInt(byteBuf, params.size());
            for (Object p : params) {
                PduCodec.writeObject(byteBuf, p);
            }
            return byteBuf;
        }

        public static long readTx(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(11);
        }

        public static long readStatementId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(19);
        }

        public static int readFetchSize(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getInt(27);
        }

        public static int readMaxRows(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getInt(31);
        }

        public static long readScannerId(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(35);
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(43);
            return ByteBufUtils.readString(buffer);
        }

        public static String readQuery(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(43);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readString(buffer);
        }

        public static ObjectListReader startReadParameters(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(43);
            ByteBufUtils.skipArray(buffer);
            ByteBufUtils.skipArray(buffer);
            int numParams = ByteBufUtils.readVInt(buffer);
            return new ObjectListReader(pdu, numParams);
        }
    }

    public static abstract class TxCommandResult {
        public static ByteBuf write(long messageId, long tx) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(11);
            byteBuf.writeByte(3);
            byteBuf.writeByte(2);
            byteBuf.writeByte(25);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(tx);
            return byteBuf;
        }

        public static long readTx(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(11);
        }
    }

    public static abstract class TxCommand {
        public static final byte TX_COMMAND_ROLLBACK_TRANSACTION = 1;
        public static final byte TX_COMMAND_COMMIT_TRANSACTION = 2;
        public static final byte TX_COMMAND_BEGIN_TRANSACTION = 3;

        public static ByteBuf write(long messageId, byte command, long tx, String tableSpace) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(20 + tableSpace.length());
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(24);
            byteBuf.writeLong(messageId);
            byteBuf.writeByte((int)command);
            byteBuf.writeLong(tx);
            ByteBufUtils.writeString(byteBuf, tableSpace);
            return byteBuf;
        }

        public static byte readCommand(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getByte(11);
        }

        public static long readTx(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            return buffer.getLong(12);
        }

        public static String readTablespace(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(20);
            return ByteBufUtils.readString(buffer);
        }
    }

    public static class ErrorResponse {
        public static final byte FLAG_NONE = 0;
        public static final byte FLAG_NOT_LEADER = 1;
        public static final byte FLAG_MISSING_PREPARED_STATEMENT = 2;
        public static final byte FLAG_DUPLICATEPRIMARY_KEY_ERROR = 4;

        public static ByteBuf write(long messageId, String error) {
            return ErrorResponse.write(messageId, error, false, false, false);
        }

        public static ByteBuf writeNotLeaderError(long messageId, String message) {
            return ErrorResponse.write(messageId, message, true, false, false);
        }

        public static ByteBuf writeMissingPreparedStatementError(long messageId, String message) {
            return ErrorResponse.write(messageId, message, false, true, false);
        }

        public static ByteBuf writeNotLeaderError(long messageId, Throwable message) {
            return ErrorResponse.write(messageId, message.toString(), true, false, false);
        }

        public static ByteBuf writeSqlIntegrityConstraintsViolation(long messageId, Throwable message) {
            return ErrorResponse.write(messageId, message.toString(), false, false, true);
        }

        private static ByteBuf write(long messageId, String error, boolean notLeader, boolean missingPreparedStatement, boolean sqlIntegrityConstraintViolation) {
            if (error == null) {
                error = "";
            }
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(12 + error.length());
            byteBuf.writeByte(3);
            byteBuf.writeByte(2);
            byteBuf.writeByte(4);
            byteBuf.writeLong(messageId);
            byte flags = 0;
            if (notLeader) {
                flags = (byte)(flags | 1);
            }
            if (missingPreparedStatement) {
                flags = (byte)(flags | 2);
            }
            if (sqlIntegrityConstraintViolation) {
                flags = (byte)(flags | 4);
            }
            byteBuf.writeByte((int)flags);
            ByteBufUtils.writeString(byteBuf, error);
            return byteBuf;
        }

        public static ByteBuf write(long messageId, Throwable error, boolean notLeader, boolean missingPreparedStatementError) {
            StringWriter writer = new StringWriter();
            error.printStackTrace(new PrintWriter(writer));
            return ErrorResponse.write(messageId, writer.toString(), notLeader, missingPreparedStatementError, false);
        }

        public static ByteBuf write(long messageId, Throwable error) {
            return ErrorResponse.write(messageId, error, false, false);
        }

        public static String readError(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(0);
            buffer.skipBytes(12);
            return ByteBufUtils.readString(buffer);
        }

        public static boolean readIsNotLeader(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            byte read = buffer.getByte(11);
            return (read & 1) == 1;
        }

        public static boolean readIsMissingPreparedStatementError(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            byte read = buffer.getByte(11);
            return (read & 2) == 2;
        }

        public static boolean readIsSqlIntegrityViolationError(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            byte read = buffer.getByte(11);
            return (read & 4) == 4;
        }
    }

    public static class AckResponse {
        public static ByteBuf write(long messageId) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(11);
            byteBuf.writeByte(3);
            byteBuf.writeByte(2);
            byteBuf.writeByte(0);
            byteBuf.writeLong(messageId);
            return byteBuf;
        }
    }

    public static class SaslTokenServerResponse {
        public static ByteBuf write(long messageId, byte[] token) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(75);
            byteBuf.writeByte(3);
            byteBuf.writeByte(2);
            byteBuf.writeByte(101);
            byteBuf.writeLong(messageId);
            if (token != null) {
                ByteBufUtils.writeArray(byteBuf, token);
            }
            return byteBuf;
        }

        public static byte[] readToken(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            if (buffer.writerIndex() > 11) {
                buffer.readerIndex(0);
                buffer.skipBytes(11);
                return ByteBufUtils.readArray(buffer);
            }
            return null;
        }
    }

    public static abstract class SaslTokenMessageToken {
        public static ByteBuf write(long messageId, byte[] token) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(12 + (token != null ? token.length : 0));
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(102);
            byteBuf.writeLong(messageId);
            if (token == null) {
                byteBuf.writeByte(0);
            } else {
                byteBuf.writeByte(1);
                ByteBufUtils.writeArray(byteBuf, token);
            }
            return byteBuf;
        }

        public static byte[] readToken(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(0);
            buffer.skipBytes(11);
            byte tokenPresent = buffer.readByte();
            if (tokenPresent == 1) {
                return ByteBufUtils.readArray(buffer);
            }
            return null;
        }
    }

    public static abstract class SaslTokenMessageRequest {
        public static ByteBuf write(long messageId, String saslMech, byte[] firstToken) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(75);
            byteBuf.writeByte(3);
            byteBuf.writeByte(1);
            byteBuf.writeByte(100);
            byteBuf.writeLong(messageId);
            ByteBufUtils.writeString(byteBuf, saslMech);
            ByteBufUtils.writeArray(byteBuf, firstToken);
            return byteBuf;
        }

        public static String readMech(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(0);
            buffer.skipBytes(11);
            return new String(ByteBufUtils.readArray(buffer), StandardCharsets.UTF_8);
        }

        public static byte[] readToken(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(0);
            buffer.skipBytes(11);
            ByteBufUtils.skipArray(buffer);
            return ByteBufUtils.readArray(buffer);
        }
    }

    public static abstract class PrepareStatementResult {
        public static ByteBuf write(long messageId, long statementId) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(19);
            byteBuf.writeByte(3);
            byteBuf.writeByte(2);
            byteBuf.writeByte(104);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(statementId);
            return byteBuf;
        }

        public static long readStatementId(Pdu pdu) {
            return pdu.buffer.getLong(11);
        }
    }

    public static abstract class ExecuteStatementResult {
        public static ByteBuf write(long messageId, long updateCount, long tx, Map<String, Object> record) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(27);
            byteBuf.writeByte(3);
            byteBuf.writeByte(2);
            byteBuf.writeByte(6);
            byteBuf.writeLong(messageId);
            byteBuf.writeLong(updateCount);
            byteBuf.writeLong(tx);
            int size = record != null ? record.size() : 0;
            ByteBufUtils.writeVInt(byteBuf, size * 2);
            if (record != null) {
                for (Map.Entry<String, Object> entry : record.entrySet()) {
                    PduCodec.writeObject(byteBuf, entry.getKey());
                    PduCodec.writeObject(byteBuf, entry.getValue());
                }
            }
            return byteBuf;
        }

        public static boolean hasRecord(Pdu pdu) {
            return pdu.buffer.writerIndex() > 27;
        }

        public static ObjectListReader readRecord(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(27);
            int numParams = ByteBufUtils.readVInt(buffer);
            return new ObjectListReader(pdu, numParams);
        }

        public static long readUpdateCount(Pdu pdu) {
            return pdu.buffer.getLong(11);
        }

        public static long readTx(Pdu pdu) {
            return pdu.buffer.getLong(19);
        }
    }

    public static abstract class ExecuteStatementsResult {
        public static ByteBuf write(long replyId, List<Long> updateCounts, List<Map<String, Object>> otherdata, long tx) {
            ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(27);
            byteBuf.writeByte(3);
            byteBuf.writeByte(2);
            byteBuf.writeByte(16);
            byteBuf.writeLong(replyId);
            byteBuf.writeLong(tx);
            byteBuf.writeInt(updateCounts.size());
            for (Long l : updateCounts) {
                byteBuf.writeLong(l.longValue());
            }
            byteBuf.writeInt(otherdata.size());
            for (Map map : otherdata) {
                int size = map != null ? map.size() : 0;
                ByteBufUtils.writeVInt(byteBuf, size * 2);
                if (map == null) continue;
                for (Map.Entry entry : map.entrySet()) {
                    PduCodec.writeObject(byteBuf, entry.getKey());
                    PduCodec.writeObject(byteBuf, entry.getValue());
                }
            }
            return byteBuf;
        }

        public static long readTx(Pdu pdu) {
            return pdu.buffer.getLong(11);
        }

        public static List<Long> readUpdateCounts(Pdu pdu) {
            pdu.buffer.readerIndex(19);
            int numStatements = pdu.buffer.readInt();
            ArrayList<Long> res = new ArrayList<Long>(numStatements);
            for (int i = 0; i < numStatements; ++i) {
                res.add(pdu.buffer.readLong());
            }
            return res;
        }

        public static ListOfListsReader startResultRecords(Pdu pdu) {
            ByteBuf buffer = pdu.buffer;
            buffer.readerIndex(19);
            int numStatements = buffer.readInt();
            for (int i = 0; i < numStatements; ++i) {
                buffer.skipBytes(8);
            }
            int numLists = ByteBufUtils.readVInt(buffer);
            return new ListOfListsReader(pdu, numLists);
        }
    }
}

