/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.Page;
import herddb.core.PageReplacementPolicy;
import herddb.utils.ListWithMap;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class ClockAdaptiveReplacement
implements PageReplacementPolicy {
    private static final Logger LOGGER = Logger.getLogger(ClockAdaptiveReplacement.class.getName());
    private static final boolean COMPILE_EXPENSIVE_LOGS = false;
    private final int c;
    private final ListWithMap<CARMetadata> t1;
    private final ListWithMap<CARMetadata> t2;
    private final ListWithMap<CARMetadata> b1;
    private final ListWithMap<CARMetadata> b2;
    private int p;
    private final Lock lock = new ReentrantLock();

    public ClockAdaptiveReplacement(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Invalid capacity " + capacity);
        }
        this.c = capacity;
        this.p = 0;
        this.t1 = new ListWithMap();
        this.t2 = new ListWithMap();
        this.b1 = new ListWithMap();
        this.b2 = new ListWithMap();
    }

    @Override
    public int capacity() {
        return this.c;
    }

    @Override
    public int size() {
        return this.t1.size() + this.t2.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page.Metadata add(Page<?> page) {
        this.lock.lock();
        try {
            CARMetadata metadata = new CARMetadata(page);
            page.metadata = metadata;
            Page.Metadata metadata2 = this.unsafeAdd(metadata);
            return metadata2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Page.Metadata pop() {
        this.lock.lock();
        try {
            CARMetadata cARMetadata = this.unsafeReplace();
            return cARMetadata;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends Page<?>> void remove(Collection<P> pages) {
        this.lock.lock();
        try {
            for (Page page : pages) {
                this.unsafeRemove((CARMetadata)page.metadata);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(Page<?> page) {
        this.lock.lock();
        try {
            boolean bl = this.unsafeRemove((CARMetadata)page.metadata);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.t1.clear();
            this.t2.clear();
            this.b1.clear();
            this.b2.clear();
            this.p = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void pageHit(Page<?> page) {
        ClockAdaptiveReplacement.hit(page);
    }

    private Page.Metadata unsafeAdd(CARMetadata page) {
        boolean b1Hit = this.b1.contains(page);
        boolean b2Hit = this.b2.contains(page);
        CARMetadata replaced = null;
        if (this.t1.size() + this.t2.size() == this.c) {
            replaced = this.unsafeReplace();
            if (!b1Hit && !b2Hit) {
                if (this.t1.size() + this.b1.size() == this.c) {
                    this.b1.poll();
                } else if (this.t1.size() + this.t2.size() + this.b1.size() + this.b2.size() == 2 * this.c) {
                    this.b2.poll();
                }
            }
        }
        if (!b1Hit && !b2Hit) {
            page.reference = false;
            this.t1.append(page);
        } else if (b1Hit) {
            this.p = Math.min(this.p + Math.max(1, this.b2.size() / this.b1.size()), this.c);
            page.reference = false;
            this.b1.remove(page);
            this.t2.append(page);
        } else {
            this.p = Math.max(this.p - Math.max(1, this.b1.size() / this.b2.size()), 0);
            page.reference = false;
            this.b2.remove(page);
            this.t2.append(page);
        }
        return replaced;
    }

    private CARMetadata unsafeReplace() {
        while (true) {
            if (this.t1.size() >= Math.max(1, this.p)) {
                CARMetadata t1h = this.t1.poll();
                if (!t1h.reference) {
                    this.b1.append(t1h);
                    return t1h;
                }
                t1h.reference = false;
                this.t2.append(t1h);
                continue;
            }
            CARMetadata t2h = this.t2.poll();
            if (!t2h.reference) {
                this.b2.append(t2h);
                return t2h;
            }
            t2h.reference = false;
            this.t2.append(t2h);
        }
    }

    private boolean unsafeRemove(CARMetadata page) {
        CARMetadata t1r = this.t1.remove(page);
        if (t1r != null) {
            t1r.reference = false;
            this.b1.append(t1r);
            return true;
        }
        CARMetadata t2r = this.t2.remove(page);
        if (t2r != null) {
            t2r.reference = false;
            this.b2.append(t2r);
            return true;
        }
        return false;
    }

    private static <P extends Page<?>> P hit(P page) {
        if (page != null && page.metadata != null) {
            ((CARMetadata)page.metadata).reference = true;
        }
        return page;
    }

    private static class CARMetadata
    extends Page.Metadata {
        public volatile boolean reference;
        private final int hashcode;

        public CARMetadata(Page<?> datapage) {
            this((Page.Owner)datapage.owner, datapage.pageId);
        }

        public CARMetadata(Page.Owner owner, long pageId) {
            super(owner, pageId);
            this.hashcode = Objects.hash(owner, pageId);
            this.reference = false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CARMetadata)) {
                return false;
            }
            CARMetadata other = (CARMetadata)obj;
            if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
                return false;
            }
            return this.pageId == other.pageId;
        }

        public String toString() {
            return "CARMetadata {pageId=" + this.pageId + ", owner=" + this.owner + '}';
        }
    }
}

