/*
 * Decompiled with CFR 0.152.
 */
package herddb.storage;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.PageSet;
import herddb.log.LogSequenceNumber;
import herddb.storage.DataStorageManagerException;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class TableStatus {
    public final String tableName;
    public final LogSequenceNumber sequenceNumber;
    public final byte[] nextPrimaryKeyValue;
    public final Map<Long, PageSet.DataPageMetaData> activePages;
    public final long nextPageId;

    public TableStatus(String tableName, LogSequenceNumber sequenceNumber, byte[] nextPrimaryKeyValue, long nextPageId, Map<Long, PageSet.DataPageMetaData> activePages) {
        this.tableName = tableName;
        this.sequenceNumber = sequenceNumber;
        this.nextPrimaryKeyValue = nextPrimaryKeyValue;
        this.activePages = activePages;
        this.nextPageId = nextPageId;
    }

    public void serialize(ExtendedDataOutputStream output) throws IOException {
        output.writeVLong(1L);
        output.writeVLong(0L);
        output.writeUTF(this.tableName);
        output.writeLong(this.sequenceNumber.ledgerId);
        output.writeLong(this.sequenceNumber.offset);
        output.writeLong(this.nextPageId);
        output.writeArray(this.nextPrimaryKeyValue);
        output.writeVInt(this.activePages.size());
        for (Map.Entry<Long, PageSet.DataPageMetaData> active : this.activePages.entrySet()) {
            output.writeVLong(active.getKey().longValue());
            active.getValue().serialize(output);
        }
    }

    public static TableStatus deserialize(ExtendedDataInputStream in) throws IOException {
        long version = in.readVLong();
        long flags = in.readVLong();
        if (version != 1L || flags != 0L) {
            throw new DataStorageManagerException("corrupted table status");
        }
        String tableName = in.readUTF();
        long ledgerId = in.readLong();
        long offset = in.readLong();
        long nextPageId = in.readLong();
        byte[] nextPrimaryKeyValue = in.readArray();
        int numActivePages = in.readVInt();
        HashMap<Long, PageSet.DataPageMetaData> activePages = new HashMap<Long, PageSet.DataPageMetaData>(numActivePages);
        for (int i = 0; i < numActivePages; ++i) {
            activePages.put(in.readVLong(), PageSet.DataPageMetaData.deserialize(in));
        }
        return new TableStatus(tableName, new LogSequenceNumber(ledgerId, offset), nextPrimaryKeyValue, nextPageId, activePages);
    }

    public String toString() {
        return "TableStatus{tableName=" + this.tableName + ", sequenceNumber=" + this.sequenceNumber + ", nextPageId=" + this.nextPageId + ", activePages=" + this.activePages.keySet() + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.tableName);
        hash = 23 * hash + Objects.hashCode(this.sequenceNumber);
        hash = 23 * hash + Arrays.hashCode(this.nextPrimaryKeyValue);
        hash = 23 * hash + Objects.hashCode(this.activePages);
        hash = 23 * hash + (int)(this.nextPageId ^ this.nextPageId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableStatus other = (TableStatus)obj;
        if (this.nextPageId != other.nextPageId) {
            return false;
        }
        if (!Objects.equals(this.tableName, other.tableName)) {
            return false;
        }
        if (!Objects.equals(this.sequenceNumber, other.sequenceNumber)) {
            return false;
        }
        if (!Arrays.equals(this.nextPrimaryKeyValue, other.nextPrimaryKeyValue)) {
            return false;
        }
        return Objects.equals(this.activePages, other.activePages);
    }
}

