/*
 * Decompiled with CFR 0.152.
 */
package herddb.storage;

import herddb.core.MemoryManager;
import herddb.core.PostCheckpointAction;
import herddb.core.RecordSetFactory;
import herddb.index.KeyToPageIndex;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import herddb.storage.DataStorageManagerException;
import herddb.storage.FullTableScanConsumer;
import herddb.storage.IndexStatus;
import herddb.storage.TableStatus;
import herddb.utils.ByteArrayCursor;
import herddb.utils.ExtendedDataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DataStorageManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(DataStorageManager.class.getName());
    private final Map<String, Map<Long, Integer>> tablePagesPins = new ConcurrentHashMap<String, Map<Long, Integer>>();
    private final Map<String, Set<LogSequenceNumber>> tableCheckpointPins = new ConcurrentHashMap<String, Set<LogSequenceNumber>>();
    private final Map<String, Map<Long, Integer>> indexPagesPins = new ConcurrentHashMap<String, Map<Long, Integer>>();
    private final Map<String, Set<LogSequenceNumber>> indexCheckpointPins = new ConcurrentHashMap<String, Set<LogSequenceNumber>>();

    public abstract List<Record> readPage(String var1, String var2, Long var3) throws DataStorageManagerException;

    public abstract void initIndex(String var1, String var2) throws DataStorageManagerException;

    public abstract void initTable(String var1, String var2) throws DataStorageManagerException;

    public abstract <X> X readIndexPage(String var1, String var2, Long var3, DataReader<X> var4) throws DataStorageManagerException;

    public abstract void fullTableScan(String var1, String var2, FullTableScanConsumer var3) throws DataStorageManagerException;

    public abstract void fullTableScan(String var1, String var2, LogSequenceNumber var3, FullTableScanConsumer var4) throws DataStorageManagerException;

    public abstract void writePage(String var1, String var2, long var3, Collection<Record> var5) throws DataStorageManagerException;

    public abstract void writeIndexPage(String var1, String var2, long var3, DataWriter var5);

    public abstract List<PostCheckpointAction> tableCheckpoint(String var1, String var2, TableStatus var3, boolean var4) throws DataStorageManagerException;

    public abstract List<PostCheckpointAction> indexCheckpoint(String var1, String var2, IndexStatus var3, boolean var4) throws DataStorageManagerException;

    public abstract int getActualNumberOfPages(String var1, String var2) throws DataStorageManagerException;

    public abstract TableStatus getLatestTableStatus(String var1, String var2) throws DataStorageManagerException;

    public abstract TableStatus getTableStatus(String var1, String var2, LogSequenceNumber var3) throws DataStorageManagerException;

    public abstract IndexStatus getIndexStatus(String var1, String var2, LogSequenceNumber var3) throws DataStorageManagerException;

    public abstract void start() throws DataStorageManagerException;

    @Override
    public abstract void close() throws DataStorageManagerException;

    public abstract void eraseTablespaceData(String var1) throws DataStorageManagerException;

    public abstract List<Table> loadTables(LogSequenceNumber var1, String var2) throws DataStorageManagerException;

    public abstract List<Index> loadIndexes(LogSequenceNumber var1, String var2) throws DataStorageManagerException;

    public abstract void loadTransactions(LogSequenceNumber var1, String var2, Consumer<Transaction> var3) throws DataStorageManagerException;

    public abstract Collection<PostCheckpointAction> writeTables(String var1, LogSequenceNumber var2, List<Table> var3, List<Index> var4, boolean var5) throws DataStorageManagerException;

    public abstract Collection<PostCheckpointAction> writeCheckpointSequenceNumber(String var1, LogSequenceNumber var2) throws DataStorageManagerException;

    public abstract Collection<PostCheckpointAction> writeTransactionsAtCheckpoint(String var1, LogSequenceNumber var2, Collection<Transaction> var3) throws DataStorageManagerException;

    public abstract LogSequenceNumber getLastcheckpointSequenceNumber(String var1) throws DataStorageManagerException;

    public abstract void dropTable(String var1, String var2) throws DataStorageManagerException;

    public abstract KeyToPageIndex createKeyToPageMap(String var1, String var2, MemoryManager var3) throws DataStorageManagerException;

    public abstract void releaseKeyToPageMap(String var1, String var2, KeyToPageIndex var3);

    public abstract RecordSetFactory createRecordSetFactory();

    public abstract void cleanupAfterBoot(String var1, String var2, Set<Long> var3) throws DataStorageManagerException;

    public abstract void truncateIndex(String var1, String var2) throws DataStorageManagerException;

    public abstract void dropIndex(String var1, String var2) throws DataStorageManagerException;

    protected Map<Long, Integer> pinTableAndGetPages(String tableSpace, String uuid, TableStatus status, boolean pin) {
        return this.pinAndGetPages(tableSpace, uuid, status.activePages.keySet(), this.tablePagesPins, pin);
    }

    protected Map<Long, Integer> pinIndexAndGetPages(String tableSpace, String uuid, IndexStatus status, boolean pin) {
        return this.pinAndGetPages(tableSpace, uuid, status.activePages, this.indexPagesPins, pin);
    }

    protected Set<LogSequenceNumber> pinTableAndGetCheckpoints(String tableSpace, String uuid, TableStatus status, boolean pin) {
        return this.pinAndGetCheckpoints(tableSpace, uuid, status.sequenceNumber, this.tableCheckpointPins, pin);
    }

    protected Set<LogSequenceNumber> pinIndexAndGetCheckpoints(String tableSpace, String uuid, IndexStatus status, boolean pin) {
        return this.pinAndGetCheckpoints(tableSpace, uuid, status.sequenceNumber, this.indexCheckpointPins, pin);
    }

    public void unPinTableCheckpoint(String tableSpace, String uuid, LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        TableStatus status = this.getTableStatus(tableSpace, uuid, sequenceNumber);
        if (status == null) {
            throw new DataStorageManagerException("Cannot unpin a not pinned checkpoint " + tableSpace + "." + uuid + "." + sequenceNumber.ledgerId + "." + sequenceNumber.offset);
        }
        this.unPinPages(tableSpace, uuid, status.activePages.keySet(), this.tablePagesPins);
        this.unPinCheckPoint(tableSpace, uuid, status.sequenceNumber, this.tableCheckpointPins);
    }

    public void unPinIndexCheckpoint(String tableSpace, String uuid, LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        IndexStatus status = this.getIndexStatus(tableSpace, uuid, sequenceNumber);
        if (status == null) {
            throw new DataStorageManagerException("Cannot unpin a not pinned checkpoint " + tableSpace + "." + uuid + "." + sequenceNumber.ledgerId + "." + sequenceNumber.offset);
        }
        this.unPinPages(tableSpace, uuid, status.activePages, this.indexPagesPins);
        this.unPinCheckPoint(tableSpace, uuid, status.sequenceNumber, this.indexCheckpointPins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Integer> pinAndGetPages(String tableSpace, String name, Collection<Long> activePages, Map<String, Map<Long, Integer>> pagesPins, boolean pin) {
        Map pins;
        LOG.log(Level.FINER, "pinAndGetPages {0}.{1} activePages: {2}, pagesPins:{3} (pin: {4})", new Object[]{tableSpace, name, activePages, pagesPins, pin});
        String pinkey = tableSpace + "_" + name;
        if (pin) {
            Map<String, Map<Long, Integer>> map = pagesPins;
            synchronized (map) {
                pins = pagesPins.computeIfAbsent(pinkey, k -> new ConcurrentHashMap());
                for (Long pageId : activePages) {
                    pins.compute(pageId, (k, v) -> v == null ? 1 : v + 1);
                }
            }
        } else {
            pins = pagesPins.getOrDefault(pinkey, Collections.emptyMap());
        }
        return pins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<LogSequenceNumber> pinAndGetCheckpoints(String tableSpace, String uuid, LogSequenceNumber sequenceNumber, Map<String, Set<LogSequenceNumber>> checkpointsPins, boolean pin) {
        Set checkpoints;
        String pinkey = tableSpace + "_" + uuid;
        if (pin) {
            Map<String, Set<LogSequenceNumber>> map = checkpointsPins;
            synchronized (map) {
                checkpoints = checkpointsPins.computeIfAbsent(pinkey, k -> ConcurrentHashMap.newKeySet());
                checkpoints.add(sequenceNumber);
            }
        } else {
            checkpoints = checkpointsPins.getOrDefault(pinkey, Collections.emptySet());
        }
        return checkpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unPinPages(String tableSpace, String name, Collection<Long> activePages, Map<String, Map<Long, Integer>> pagesPins) throws DataStorageManagerException {
        String pinkey = tableSpace + "_" + name;
        Map<String, Map<Long, Integer>> map = pagesPins;
        synchronized (map) {
            Map<Long, Integer> pins = pagesPins.get(pinkey);
            if (pins != null) {
                for (Long pageId : activePages) {
                    pins.compute(pageId, (k, v) -> {
                        if (v == null || v < 2) {
                            return null;
                        }
                        return v - 1;
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unPinCheckPoint(String tableSpace, String name, LogSequenceNumber sequenceNumber, Map<String, Set<LogSequenceNumber>> checkpointsPins) throws DataStorageManagerException {
        String pinkey = tableSpace + "_" + name;
        Map<String, Set<LogSequenceNumber>> map = checkpointsPins;
        synchronized (map) {
            Set<LogSequenceNumber> checkpoints = checkpointsPins.get(pinkey);
            if (checkpoints != null) {
                checkpoints.remove(sequenceNumber);
            }
        }
    }

    @FunctionalInterface
    public static interface DataWriter {
        public void write(ExtendedDataOutputStream var1) throws IOException;
    }

    @FunctionalInterface
    public static interface DataReader<X> {
        public X read(ByteArrayCursor var1) throws IOException;
    }
}

