/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.TypedJdbcParameterExpression;
import herddb.utils.DataAccessor;

public class JdbcParameterExpression
implements CompiledSQLExpression {
    private final int index;

    public JdbcParameterExpression(int index) {
        this.index = index;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        return context.getJdbcParameter(this.index);
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        context.getJdbcParameter(this.index);
    }

    public String toString() {
        return "JdbcParameterExpression{index=" + this.index + '}';
    }

    @Override
    public CompiledSQLExpression cast(int type) {
        return new TypedJdbcParameterExpression(this.index, type);
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return this;
    }
}

