/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.BindableTableScanColumnNameResolver;
import herddb.sql.expressions.CastExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.Collections;
import java.util.List;

public interface CompiledSQLExpression {
    public Object evaluate(DataAccessor var1, StatementEvaluationContext var2) throws StatementExecutionException;

    default public boolean opEqualsTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object leftValue = this.evaluate(bean, context);
        Object rightValue = right.evaluate(bean, context);
        return SQLRecordPredicateFunctions.objectEquals((Object)leftValue, (Object)rightValue);
    }

    default public boolean opNotEqualsTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object leftValue = this.evaluate(bean, context);
        Object rightValue = right.evaluate(bean, context);
        return SQLRecordPredicateFunctions.objectNotEquals((Object)leftValue, (Object)rightValue);
    }

    default public int opCompareTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object leftValue = this.evaluate(bean, context);
        Object rightValue = right.evaluate(bean, context);
        return SQLRecordPredicateFunctions.compare((Object)leftValue, (Object)rightValue);
    }

    default public void validate(StatementEvaluationContext context) throws StatementExecutionException {
    }

    default public List<CompiledSQLExpression> scanForConstraintedValueOnColumnWithOperator(String column, String operator, BindableTableScanColumnNameResolver columnNameResolver) {
        return Collections.emptyList();
    }

    default public List<CompiledSQLExpression> scanForConstraintsOnColumn(String column, BindableTableScanColumnNameResolver columnNameResolver) {
        return Collections.emptyList();
    }

    default public CompiledSQLExpression cast(int type) {
        return new CastExpression(this, type);
    }

    default public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        throw new IllegalStateException("not implemented for " + this.getClass());
    }

    public static interface BinaryExpressionBuilder {
        public CompiledSQLExpression build(boolean var1, CompiledSQLExpression var2, CompiledSQLExpression var3);
    }
}

