/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;

public class CompiledGreaterThenEqualsExpression
extends CompiledBinarySQLExpression {
    public CompiledGreaterThenEqualsExpression(CompiledSQLExpression left, CompiledSQLExpression right) {
        super(left, right);
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        return this.left.opCompareTo(bean, context, this.right) >= 0;
    }

    @Override
    public String getOperator() {
        return ">=";
    }

    public String toString() {
        return "CompiledGreaterThenEqualsExpression{left=" + this.left + ", right=" + this.right + "}";
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return new CompiledGreaterThenEqualsExpression(this.left.remapPositionalAccessToToPrimaryKeyAccessor(projection), this.right.remapPositionalAccessToToPrimaryKeyAccessor(projection));
    }
}

