/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;

public class CompiledAndExpression
extends CompiledBinarySQLExpression {
    private final boolean not;

    public CompiledAndExpression(boolean not, CompiledSQLExpression left, CompiledSQLExpression right) {
        super(left, right);
        this.not = not;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        boolean ok = SQLRecordPredicateFunctions.toBoolean((Object)this.left.evaluate(bean, context));
        if (!ok) {
            return this.not;
        }
        ok = SQLRecordPredicateFunctions.toBoolean((Object)this.right.evaluate(bean, context));
        if (this.not) {
            return !ok;
        }
        return ok;
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        this.left.validate(context);
        this.right.validate(context);
    }

    public String toString() {
        return "CompiledAndExpression{left=" + this.left + ", right=" + this.right + ", not=" + this.not + '}';
    }
}

