/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import herddb.codec.RecordSerializer;
import herddb.model.Column;
import herddb.model.Record;
import herddb.model.RecordFunction;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableContext;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SQLRecordFunction
extends RecordFunction {
    private final Table table;
    private final Map<String, CompiledSQLExpression> expressionsByColumnName;

    public SQLRecordFunction(Table table, List<net.sf.jsqlparser.schema.Column> columns, List<CompiledSQLExpression> expressions) {
        this.table = table;
        List _columns = columns.stream().map(net.sf.jsqlparser.schema.Column::getColumnName).collect(Collectors.toList());
        this.expressionsByColumnName = new HashMap<String, CompiledSQLExpression>();
        int size = _columns.size();
        for (int i = 0; i < size; ++i) {
            this.expressionsByColumnName.put((String)_columns.get(i), expressions.get(i));
        }
    }

    public SQLRecordFunction(List<String> columns, Table table, List<CompiledSQLExpression> expressions) {
        this.table = table;
        this.expressionsByColumnName = new HashMap<String, CompiledSQLExpression>();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            this.expressionsByColumnName.put(columns.get(i), expressions.get(i));
        }
    }

    @Override
    public byte[] computeNewValue(Record previous, StatementEvaluationContext context, TableContext tableContext) throws StatementExecutionException {
        try {
            if (previous != null) {
                Map<String, Object> asMap = previous.toBean(this.table);
                DataAccessor bean = previous.getDataAccessor(this.table);
                Function<String, Object> fieldValueComputer = columnName -> {
                    CompiledSQLExpression e = this.expressionsByColumnName.get(columnName);
                    if (e == null) {
                        return asMap.get(columnName);
                    }
                    Column column = this.table.getColumn((String)columnName);
                    if (column == null) {
                        throw new StatementExecutionException("unknown column " + columnName + " in table " + this.table.name);
                    }
                    return RecordSerializer.convert(column.type, e.evaluate(bean, context));
                };
                return RecordSerializer.buildRecord(previous.value != null ? previous.value.getLength() : 0, this.table, fieldValueComputer);
            }
            Function<String, Object> fieldValueComputer = columnName -> {
                CompiledSQLExpression e = this.expressionsByColumnName.get(columnName);
                if (e == null) {
                    return null;
                }
                Column column = this.table.getColumn((String)columnName);
                if (column == null) {
                    throw new StatementExecutionException("unknown column " + columnName + " in table " + this.table.name);
                }
                return RecordSerializer.convert(column.type, e.evaluate(DataAccessor.NULL, context));
            };
            return RecordSerializer.buildRecord(0, this.table, fieldValueComputer);
        }
        catch (IllegalArgumentException err) {
            throw new StatementExecutionException(err);
        }
    }

    public String toString() {
        return "SQLRecordFunction{table=" + this.table + ", exp=" + this.expressionsByColumnName + '}';
    }
}

