/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import com.google.common.collect.ImmutableList;
import herddb.core.AbstractIndexManager;
import herddb.core.AbstractTableManager;
import herddb.core.DBManager;
import herddb.core.TableSpaceManager;
import herddb.index.IndexOperation;
import herddb.index.PrimaryIndexPrefixScan;
import herddb.index.PrimaryIndexRangeScan;
import herddb.index.PrimaryIndexSeek;
import herddb.index.SecondaryIndexPrefixScan;
import herddb.index.SecondaryIndexRangeScan;
import herddb.index.SecondaryIndexSeek;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.AutoIncrementPrimaryKeyRecordFunction;
import herddb.model.Column;
import herddb.model.ColumnTypes;
import herddb.model.ColumnsList;
import herddb.model.DMLStatement;
import herddb.model.ExecutionPlan;
import herddb.model.Predicate;
import herddb.model.Projection;
import herddb.model.RecordFunction;
import herddb.model.Statement;
import herddb.model.StatementExecutionException;
import herddb.model.TableDoesNotExistException;
import herddb.model.TableSpaceDoesNotExistException;
import herddb.model.commands.DeleteStatement;
import herddb.model.commands.GetStatement;
import herddb.model.commands.InsertStatement;
import herddb.model.commands.SQLPlannedOperationStatement;
import herddb.model.commands.ScanStatement;
import herddb.model.commands.UpdateStatement;
import herddb.model.planner.AggregateOp;
import herddb.model.planner.BindableTableScanOp;
import herddb.model.planner.DeleteOp;
import herddb.model.planner.FilterOp;
import herddb.model.planner.FilteredTableScanOp;
import herddb.model.planner.InsertOp;
import herddb.model.planner.JoinOp;
import herddb.model.planner.LimitOp;
import herddb.model.planner.NestedLoopJoinOp;
import herddb.model.planner.PlannerOp;
import herddb.model.planner.ProjectOp;
import herddb.model.planner.SimpleDeleteOp;
import herddb.model.planner.SimpleInsertOp;
import herddb.model.planner.SimpleUpdateOp;
import herddb.model.planner.SortOp;
import herddb.model.planner.TableScanOp;
import herddb.model.planner.UnionAllOp;
import herddb.model.planner.UpdateOp;
import herddb.model.planner.ValuesOp;
import herddb.sql.AbstractSQLPlanner;
import herddb.sql.DDLSQLPlanner;
import herddb.sql.PlansCache;
import herddb.sql.SQLRecordFunction;
import herddb.sql.SQLRecordKeyFunction;
import herddb.sql.SQLRecordPredicate;
import herddb.sql.SQLStatementEvaluationContext;
import herddb.sql.TranslatedQuery;
import herddb.sql.expressions.AccessCurrentRowExpression;
import herddb.sql.expressions.BindableTableScanColumnNameResolver;
import herddb.sql.expressions.CompiledMultiAndExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.ConstantExpression;
import herddb.sql.expressions.JdbcParameterExpression;
import herddb.sql.expressions.SQLExpressionCompiler;
import herddb.sql.expressions.TypedJdbcParameterExpression;
import herddb.sql.functions.ShowCreateTableCalculator;
import herddb.utils.SQLUtils;
import herddb.utils.SystemProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableAggregate;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.calcite.adapter.enumerable.EnumerableHashJoin;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import org.apache.calcite.adapter.enumerable.EnumerableNestedLoopJoin;
import org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.calcite.adapter.enumerable.EnumerableSort;
import org.apache.calcite.adapter.enumerable.EnumerableTableModify;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.adapter.enumerable.EnumerableUnion;
import org.apache.calcite.adapter.enumerable.EnumerableValues;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.ImmutableBitSet;

public class CalcitePlanner
implements AbstractSQLPlanner {
    private static final long WAIT_FOR_SCHEMA_UP_TIMEOUT = SystemProperties.getLongSystemProperty((String)"herddb.planner.waitfortablespacetimeout", (long)60000L);
    private static final Level DUMP_QUERY_LEVEL = Level.parse(SystemProperties.getStringSystemProperty((String)"herddb.planner.dumpqueryloglevel", (String)Level.FINE.toString()));
    private static final Pattern USE_DDL_PARSER = Pattern.compile("^[\\s]*(EXECUTE|CREATE|DROP|ALTER|TRUNCATE|BEGIN|COMMIT|ROLLBACK).*", 34);
    private final DBManager manager;
    private final AbstractSQLPlanner fallback;
    private final PlansCache cache;
    private SchemaPlus rootSchema;
    private static final SqlParser.Config SQL_PARSER_CONFIG = SqlParser.configBuilder((SqlParser.Config)SqlParser.Config.DEFAULT).setCaseSensitive(false).setConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).setQuoting(Quoting.BACK_TICK).build();
    private static final Logger LOG = Logger.getLogger(CalcitePlanner.class.getName());
    private static final List<RelTraitDef> TRAITS = Collections.unmodifiableList(Arrays.asList(ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE));

    public CalcitePlanner(DBManager manager, long maxPlanCacheSize) {
        this.manager = manager;
        this.cache = new PlansCache(maxPlanCacheSize);
        this.fallback = new DDLSQLPlanner(manager, maxPlanCacheSize);
    }

    @Override
    public long getCacheSize() {
        return this.cache.getCacheSize();
    }

    @Override
    public long getCacheHits() {
        return this.cache.getCacheHits();
    }

    @Override
    public long getCacheMisses() {
        return this.cache.getCacheMisses();
    }

    @Override
    public void clearCache() {
        this.rootSchema = null;
        this.cache.clear();
        this.fallback.clearCache();
    }

    static final boolean isDDL(String query) {
        return USE_DDL_PARSER.matcher(query).matches();
    }

    @Override
    public TranslatedQuery translate(String defaultTableSpace, String query, List<Object> parameters, boolean scan, boolean allowCache, boolean returnValues, int maxRows) throws StatementExecutionException {
        ExecutionPlan cached;
        int idx = SQLUtils.findQueryStart((String)query);
        if (idx != -1) {
            query = query.substring(idx);
        }
        if (parameters == null) {
            parameters = Collections.emptyList();
        }
        String cacheKey = "scan:" + scan + ",defaultTableSpace:" + defaultTableSpace + ",query:" + query + ",returnValues:" + returnValues + ",maxRows:" + maxRows;
        if (allowCache && (cached = this.cache.get(cacheKey)) != null) {
            return new TranslatedQuery(cached, new SQLStatementEvaluationContext(query, parameters));
        }
        if (CalcitePlanner.isDDL(query)) {
            query = DDLSQLPlanner.rewriteExecuteSyntax(query);
            return this.fallback.translate(defaultTableSpace, query, parameters, scan, allowCache, returnValues, maxRows);
        }
        if (!CalcitePlanner.isCachable(query)) {
            allowCache = false;
        }
        try {
            PlannerOp rootOp;
            ScanStatement scanStatement;
            PlannerResult plan;
            if (query.startsWith("EXPLAIN ")) {
                query = query.substring("EXPLAIN ".length());
                plan = this.runPlanner(defaultTableSpace, query);
                boolean upsert = CalcitePlanner.detectUpsert(query);
                PlannerOp finalPlan = this.convertRelNode(plan.topNode, plan.originalRowType, returnValues, upsert).optimize();
                ValuesOp values = new ValuesOp(this.manager.getNodeId(), new String[]{"name", "value"}, new Column[]{Column.column("name", 0), Column.column("value", 0)}, Arrays.asList(Arrays.asList(new ConstantExpression("query"), new ConstantExpression(query)), Arrays.asList(new ConstantExpression("logicalplan"), new ConstantExpression(RelOptUtil.dumpPlan((String)"", (RelNode)plan.logicalPlan, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES))), Arrays.asList(new ConstantExpression("plan"), new ConstantExpression(RelOptUtil.dumpPlan((String)"", (RelNode)plan.topNode, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES))), Arrays.asList(new ConstantExpression("finalplan"), new ConstantExpression(finalPlan + ""))));
                ExecutionPlan executionPlan = ExecutionPlan.simple(new SQLPlannedOperationStatement(values), values);
                return new TranslatedQuery(executionPlan, new SQLStatementEvaluationContext(query, parameters));
            }
            if (query.startsWith("SHOW")) {
                return this.calculateShowCreateTable(query, defaultTableSpace, parameters);
            }
            plan = this.runPlanner(defaultTableSpace, query);
            boolean upsert = CalcitePlanner.detectUpsert(query);
            SQLPlannedOperationStatement sqlPlannedOperationStatement = new SQLPlannedOperationStatement(this.convertRelNode(plan.topNode, plan.originalRowType, returnValues, upsert).optimize());
            if (LOG.isLoggable(DUMP_QUERY_LEVEL)) {
                LOG.log(DUMP_QUERY_LEVEL, "Query: {0} --HerdDB Plan\n{1}", new Object[]{query, sqlPlannedOperationStatement.getRootOp()});
            }
            if (!scan && (scanStatement = sqlPlannedOperationStatement.unwrap(ScanStatement.class)) != null) {
                herddb.model.Table tableDef = scanStatement.getTableDef();
                CompiledSQLExpression where = (CompiledSQLExpression)scanStatement.getPredicate().unwrap(CompiledSQLExpression.class);
                SQLRecordKeyFunction keyFunction = CalcitePlanner.findIndexAccess(where, tableDef.getPrimaryKey(), tableDef, "=", tableDef);
                if (keyFunction == null || !keyFunction.isFullPrimaryKey()) {
                    throw new StatementExecutionException("unsupported GET not on PK, bad where clause: " + query);
                }
                GetStatement get = new GetStatement(scanStatement.getTableSpace(), scanStatement.getTable(), keyFunction, scanStatement.getPredicate(), true);
                ExecutionPlan executionPlan = ExecutionPlan.simple(get);
                if (allowCache) {
                    this.cache.put(cacheKey, executionPlan);
                }
                return new TranslatedQuery(executionPlan, new SQLStatementEvaluationContext(query, parameters));
            }
            if (maxRows > 0) {
                PlannerOp op = new LimitOp(sqlPlannedOperationStatement.getRootOp(), new ConstantExpression(maxRows), new ConstantExpression(0)).optimize();
                sqlPlannedOperationStatement = new SQLPlannedOperationStatement(op);
            }
            ExecutionPlan executionPlan = (rootOp = sqlPlannedOperationStatement.getRootOp()).isSimpleStatementWrapper() ? ExecutionPlan.simple((Statement)rootOp.unwrap(Statement.class), rootOp) : ExecutionPlan.simple(sqlPlannedOperationStatement, rootOp);
            if (allowCache) {
                this.cache.put(cacheKey, executionPlan);
            }
            return new TranslatedQuery(executionPlan, new SQLStatementEvaluationContext(query, parameters));
        }
        catch (CalciteContextException ex) {
            LOG.log(Level.INFO, "Error while parsing '" + ex.getOriginalStatement() + "'", ex);
            throw new StatementExecutionException(ex.getMessage());
        }
        catch (SqlParseException | RelConversionException | ValidationException ex) {
            LOG.log(Level.INFO, "Error while parsing '" + query + "'", ex);
            throw new StatementExecutionException(ex.getMessage().replace("org.apache.calcite.runtime.CalciteContextException: ", ""), ex);
        }
        catch (MetadataStorageManagerException ex) {
            LOG.log(Level.INFO, "Error while parsing '" + query + "'", ex);
            throw new StatementExecutionException(ex);
        }
    }

    private static boolean detectUpsert(String query) {
        boolean upsert = query.startsWith("UPSERT");
        return upsert;
    }

    private TranslatedQuery calculateShowCreateTable(String query, String defaultTablespace, List<Object> parameters) {
        String[] items = new String[]{"SHOW", "CREATE", "TABLE"};
        if (Arrays.stream(items).allMatch(query::contains)) {
            String tableName;
            query = query.substring(Arrays.stream(items).collect(Collectors.joining(" ")).length()).trim();
            String tableSpace = defaultTablespace;
            boolean showCreateIndex = query.contains("WITH INDEXES");
            if (showCreateIndex) {
                query = query.substring(0, query.indexOf("WITH INDEXES"));
            }
            if (query.contains(".")) {
                String[] tokens = query.split("\\.");
                tableSpace = tokens[0].trim();
                tableName = tokens[1].trim();
            } else {
                tableName = query.trim();
            }
            TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(tableSpace);
            if (tableSpaceManager == null) {
                throw new TableSpaceDoesNotExistException(String.format("Tablespace %s does not exist.", tableSpace));
            }
            AbstractTableManager tableManager = tableSpaceManager.getTableManager(tableName);
            if (tableManager == null || tableManager.getCreatedInTransaction() > 0L) {
                throw new TableDoesNotExistException(String.format("Table %s does not exist.", tableName));
            }
            String showCreateResult = ShowCreateTableCalculator.calculate(showCreateIndex, tableName, tableSpace, tableManager);
            ValuesOp values = new ValuesOp(this.manager.getNodeId(), new String[]{"tabledef"}, new Column[]{Column.column("tabledef", 0)}, Arrays.asList(Arrays.asList(new ConstantExpression(showCreateResult))));
            ExecutionPlan executionPlan = ExecutionPlan.simple(new SQLPlannedOperationStatement(values), values);
            return new TranslatedQuery(executionPlan, new SQLStatementEvaluationContext(query, parameters));
        }
        throw new StatementExecutionException(String.format("Incorrect Syntax for SHOW CREATE TABLE tablespace.tablename", new Object[0]));
    }

    private SchemaPlus getSchemaForTableSpace(String defaultTableSpace) throws MetadataStorageManagerException {
        long startTs = System.currentTimeMillis();
        SchemaPlus schema;
        SchemaPlus result;
        while ((result = (schema = this.getRootSchema()).getSubSchema(defaultTableSpace)) == null) {
            long delta = System.currentTimeMillis() - startTs;
            LOG.log(Level.FINE, "schema {0} not available yet, after waiting {1}/{2} ms", new Object[]{defaultTableSpace, delta, WAIT_FOR_SCHEMA_UP_TIMEOUT});
            if (delta >= WAIT_FOR_SCHEMA_UP_TIMEOUT) {
                return null;
            }
            this.clearCache();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return result;
    }

    private CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(CompiledSQLExpression filterPk, herddb.model.Table table, RelNode debug) {
        try {
            int[] projectionToKey = table.getPrimaryKeyProjection();
            return filterPk.remapPositionalAccessToToPrimaryKeyAccessor(projectionToKey);
        }
        catch (IllegalStateException notImplemented) {
            LOG.log(Level.INFO, "Not implemented best access for PK on " + RelOptUtil.dumpPlan((String)"", (RelNode)debug, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES), notImplemented);
            return null;
        }
    }

    private PlannerResult runPlanner(String defaultTableSpace, String query) throws RelConversionException, SqlParseException, ValidationException, MetadataStorageManagerException {
        RelCollation collation;
        SchemaPlus subSchema = this.getSchemaForTableSpace(defaultTableSpace);
        if (subSchema == null) {
            this.clearCache();
            throw new StatementExecutionException("tablespace " + defaultTableSpace + " is not available");
        }
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SQL_PARSER_CONFIG).defaultSchema(subSchema).traitDefs(TRAITS).programs(new Program[]{Programs.ofRules((Iterable)Programs.RULE_SET)}).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Query: {0}", query);
        }
        SqlNode n = planner.parse(query);
        n = planner.validate(n);
        RelNode logicalPlan = planner.rel(n).project();
        if (LOG.isLoggable(DUMP_QUERY_LEVEL)) {
            LOG.log(DUMP_QUERY_LEVEL, "Query: {0} {1}", new Object[]{query, RelOptUtil.dumpPlan((String)"-- Logical Plan", (RelNode)logicalPlan, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES)});
        }
        RelDataType originalRowType = logicalPlan.getRowType();
        RelOptCluster cluster = logicalPlan.getCluster();
        RelOptPlanner optPlanner = cluster.getPlanner();
        optPlanner.addRule((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
        RelTraitSet desiredTraits = cluster.traitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelCollation relCollation = collation = logicalPlan instanceof Sort ? ((Sort)logicalPlan).collation : null;
        if (collation != null) {
            desiredTraits = desiredTraits.replace((RelTrait)collation);
        }
        RelNode newRoot = optPlanner.changeTraits(logicalPlan, desiredTraits);
        optPlanner.setRoot(newRoot);
        RelNode bestExp = optPlanner.findBestExp();
        if (LOG.isLoggable(DUMP_QUERY_LEVEL)) {
            LOG.log(DUMP_QUERY_LEVEL, "Query: {0} {1}", new Object[]{query, RelOptUtil.dumpPlan((String)"-- Best  Plan", (RelNode)bestExp, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES)});
        }
        return new PlannerResult(bestExp, originalRowType, logicalPlan);
    }

    private SchemaPlus getRootSchema() throws MetadataStorageManagerException {
        if (this.rootSchema != null) {
            return this.rootSchema;
        }
        SchemaPlus _rootSchema = Frameworks.createRootSchema((boolean)true);
        for (String tableSpace : this.manager.getLocalTableSpaces()) {
            TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(tableSpace);
            SchemaPlus schema = _rootSchema.add(tableSpace, (Schema)new AbstractSchema());
            List<herddb.model.Table> tables = tableSpaceManager.getAllTablesForPlanner();
            for (herddb.model.Table table : tables) {
                AbstractTableManager tableManager = tableSpaceManager.getTableManager(table.name);
                TableImpl tableDef = new TableImpl(tableManager);
                schema.add(table.name, (Table)tableDef);
            }
        }
        this.rootSchema = _rootSchema;
        return _rootSchema;
    }

    private PlannerOp convertRelNode(RelNode plan, RelDataType rowType, boolean returnValues, boolean upsert) throws StatementExecutionException {
        if (plan instanceof EnumerableTableModify) {
            EnumerableTableModify dml = (EnumerableTableModify)plan;
            switch (dml.getOperation()) {
                case INSERT: {
                    return this.planInsert(dml, returnValues, upsert);
                }
                case DELETE: {
                    return this.planDelete(dml);
                }
                case UPDATE: {
                    return this.planUpdate(dml, returnValues);
                }
            }
            throw new StatementExecutionException("unsupport DML operation " + dml.getOperation());
        }
        if (plan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan scan = (Bindables.BindableTableScan)plan;
            return this.planBindableTableScan(scan, rowType);
        }
        if (plan instanceof EnumerableTableScan) {
            EnumerableTableScan scan = (EnumerableTableScan)plan;
            return this.planEnumerableTableScan(scan, rowType);
        }
        if (plan instanceof EnumerableProject) {
            EnumerableProject scan = (EnumerableProject)plan;
            return this.planProject(scan, rowType);
        }
        if (plan instanceof EnumerableHashJoin) {
            EnumerableHashJoin scan = (EnumerableHashJoin)plan;
            return this.planEnumerableHashJoin(scan, rowType);
        }
        if (plan instanceof EnumerableNestedLoopJoin) {
            EnumerableNestedLoopJoin scan = (EnumerableNestedLoopJoin)plan;
            return this.planEnumerableNestedLoopJoin(scan, rowType);
        }
        if (plan instanceof EnumerableHashJoin) {
            EnumerableHashJoin scan = (EnumerableHashJoin)plan;
            return this.planEnumerableJoin(scan, rowType);
        }
        if (plan instanceof EnumerableMergeJoin) {
            EnumerableMergeJoin scan = (EnumerableMergeJoin)plan;
            return this.planEnumerableMergeJoin(scan, rowType);
        }
        if (plan instanceof EnumerableValues) {
            EnumerableValues scan = (EnumerableValues)plan;
            return this.planValues(scan);
        }
        if (plan instanceof EnumerableSort) {
            EnumerableSort scan = (EnumerableSort)plan;
            return this.planSort(scan, rowType);
        }
        if (plan instanceof EnumerableLimit) {
            EnumerableLimit scan = (EnumerableLimit)plan;
            return this.planLimit(scan, rowType);
        }
        if (plan instanceof EnumerableInterpreter) {
            EnumerableInterpreter scan = (EnumerableInterpreter)plan;
            return this.planInterpreter(scan, rowType, returnValues);
        }
        if (plan instanceof EnumerableFilter) {
            EnumerableFilter scan = (EnumerableFilter)plan;
            return this.planFilter(scan, rowType, returnValues);
        }
        if (plan instanceof EnumerableUnion) {
            EnumerableUnion scan = (EnumerableUnion)plan;
            return this.planEnumerableUnion(scan, rowType, returnValues);
        }
        if (plan instanceof EnumerableAggregate) {
            EnumerableAggregate scan = (EnumerableAggregate)plan;
            return this.planAggregate(scan, rowType, returnValues);
        }
        throw new StatementExecutionException("not implented " + plan.getRelTypeName());
    }

    private PlannerOp planInsert(EnumerableTableModify dml, boolean returnValues, boolean upsert) {
        EnumerableValues values;
        EnumerableProject project;
        String tableSpace = (String)dml.getTable().getQualifiedName().get(0);
        String tableName = (String)dml.getTable().getQualifiedName().get(1);
        DMLStatement statement = null;
        if (dml.getInput() instanceof EnumerableProject && (project = (EnumerableProject)dml.getInput()).getInput() instanceof EnumerableValues && (values = (EnumerableValues)project.getInput()).getTuples().size() == 1) {
            TableImpl tableImpl = (TableImpl)((Object)dml.getTable().unwrap(Table.class));
            herddb.model.Table table = tableImpl.tableManager.getTable();
            int index = 0;
            List projects = project.getProjects();
            ArrayList<CompiledSQLExpression> keyValueExpression = new ArrayList<CompiledSQLExpression>();
            ArrayList<String> keyExpressionToColumn = new ArrayList<String>();
            ArrayList<CompiledSQLExpression> valuesExpressions = new ArrayList<CompiledSQLExpression>();
            ArrayList<String> valuesColumns = new ArrayList<String>();
            boolean invalid = false;
            for (Column column : table.getColumns()) {
                CompiledSQLExpression exp = SQLExpressionCompiler.compileExpression((RexNode)projects.get(index));
                if (exp instanceof ConstantExpression || exp instanceof JdbcParameterExpression || exp instanceof TypedJdbcParameterExpression) {
                    boolean isAlwaysNull;
                    boolean bl = isAlwaysNull = exp instanceof ConstantExpression && ((ConstantExpression)exp).isNull();
                    if (!isAlwaysNull) {
                        if (table.isPrimaryKeyColumn(column.name)) {
                            keyExpressionToColumn.add(column.name);
                            keyValueExpression.add(exp);
                        }
                        valuesColumns.add(column.name);
                        valuesExpressions.add(exp);
                    }
                    ++index;
                    continue;
                }
                invalid = true;
                break;
            }
            if (!invalid) {
                RecordFunction keyfunction;
                if (keyValueExpression.isEmpty() && table.auto_increment) {
                    keyfunction = new AutoIncrementPrimaryKeyRecordFunction();
                } else {
                    if (keyValueExpression.size() != table.primaryKey.length) {
                        throw new StatementExecutionException("you must set a value for the primary key (expressions=" + keyValueExpression.size() + ")");
                    }
                    keyfunction = new SQLRecordKeyFunction(keyExpressionToColumn, keyValueExpression, table);
                }
                SQLRecordFunction valuesfunction = new SQLRecordFunction(valuesColumns, table, valuesExpressions);
                statement = new InsertStatement(tableSpace, tableName, keyfunction, valuesfunction, upsert).setReturnValues(returnValues);
            }
        }
        if (statement != null) {
            return new SimpleInsertOp(statement);
        }
        PlannerOp input = this.convertRelNode(dml.getInput(), null, false, false);
        try {
            return new InsertOp(tableSpace, tableName, input, returnValues, upsert);
        }
        catch (IllegalArgumentException err) {
            throw new StatementExecutionException(err);
        }
    }

    private PlannerOp planDelete(EnumerableTableModify dml) {
        PlannerOp input = this.convertRelNode(dml.getInput(), null, false, false);
        String tableSpace = (String)dml.getTable().getQualifiedName().get(0);
        String tableName = (String)dml.getTable().getQualifiedName().get(1);
        TableImpl tableImpl = (TableImpl)((Object)dml.getTable().unwrap(Table.class));
        herddb.model.Table table = tableImpl.tableManager.getTable();
        DeleteStatement delete = null;
        if (input instanceof TableScanOp) {
            delete = new DeleteStatement(tableSpace, tableName, null, null);
        } else if (input instanceof FilterOp) {
            FilterOp filter = (FilterOp)input;
            if (filter.getInput() instanceof TableScanOp) {
                SQLRecordPredicate pred = new SQLRecordPredicate(table, null, filter.getCondition());
                delete = new DeleteStatement(tableSpace, tableName, null, pred);
            }
        } else if (input instanceof BindableTableScanOp) {
            BindableTableScanOp filter = (BindableTableScanOp)input;
            Predicate pred = filter.getStatement().getPredicate();
            delete = new DeleteStatement(tableSpace, tableName, null, pred);
        }
        if (delete != null) {
            return new SimpleDeleteOp(delete);
        }
        return new DeleteOp(tableSpace, tableName, input);
    }

    private PlannerOp planUpdate(EnumerableTableModify dml, boolean returnValues) {
        PlannerOp input = this.convertRelNode(dml.getInput(), null, false, false);
        List updateColumnList = dml.getUpdateColumnList();
        List sourceExpressionList = dml.getSourceExpressionList();
        String tableSpace = (String)dml.getTable().getQualifiedName().get(0);
        String tableName = (String)dml.getTable().getQualifiedName().get(1);
        TableImpl tableImpl = (TableImpl)((Object)dml.getTable().unwrap(Table.class));
        herddb.model.Table table = tableImpl.tableManager.getTable();
        ArrayList<CompiledSQLExpression> expressions = new ArrayList<CompiledSQLExpression>(sourceExpressionList.size());
        for (RexNode node : sourceExpressionList) {
            CompiledSQLExpression exp = SQLExpressionCompiler.compileExpression(node);
            expressions.add(exp);
        }
        SQLRecordFunction function = new SQLRecordFunction(updateColumnList, table, expressions);
        UpdateStatement update = null;
        if (input instanceof TableScanOp) {
            update = new UpdateStatement(tableSpace, tableName, null, function, null);
        } else if (input instanceof FilterOp) {
            FilterOp filter = (FilterOp)input;
            if (filter.getInput() instanceof TableScanOp) {
                SQLRecordPredicate pred = new SQLRecordPredicate(table, null, filter.getCondition());
                update = new UpdateStatement(tableSpace, tableName, null, function, pred);
            }
        } else if (input instanceof ProjectOp) {
            BindableTableScanOp filter;
            ScanStatement scan;
            ProjectOp proj = (ProjectOp)input;
            if (proj.getInput() instanceof TableScanOp) {
                update = new UpdateStatement(tableSpace, tableName, null, function, null);
            } else if (proj.getInput() instanceof FilterOp) {
                FilterOp filter2 = (FilterOp)proj.getInput();
                if (filter2.getInput() instanceof TableScanOp) {
                    SQLRecordPredicate pred = new SQLRecordPredicate(table, null, filter2.getCondition());
                    update = new UpdateStatement(tableSpace, tableName, null, function, pred);
                }
            } else if (proj.getInput() instanceof FilteredTableScanOp) {
                FilteredTableScanOp filter3 = (FilteredTableScanOp)proj.getInput();
                Predicate pred = filter3.getPredicate();
                update = new UpdateStatement(tableSpace, tableName, null, function, pred);
            } else if (proj.getInput() instanceof BindableTableScanOp && (scan = (filter = (BindableTableScanOp)proj.getInput()).getStatement()).getComparator() == null && scan.getLimits() == null && scan.getTableDef() != null) {
                Predicate pred = scan.getPredicate();
                update = new UpdateStatement(tableSpace, tableName, null, function, pred);
            }
        }
        if (update != null) {
            return new SimpleUpdateOp(update.setReturnValues(returnValues));
        }
        return new UpdateOp(tableSpace, tableName, input, returnValues, function);
    }

    private PlannerOp planEnumerableTableScan(EnumerableTableScan scan, RelDataType rowType) {
        List fieldNamesFromQuery;
        String tableSpace = (String)scan.getTable().getQualifiedName().get(0);
        TableImpl tableImpl = (TableImpl)((Object)scan.getTable().unwrap(Table.class));
        herddb.model.Table table = tableImpl.tableManager.getTable();
        Column[] columns = table.getColumns();
        int numColumns = columns.length;
        boolean usingAliases = false;
        if (rowType != null) {
            fieldNamesFromQuery = rowType.getFieldNames();
            for (int i = 0; i < numColumns; ++i) {
                String colName;
                String fieldName = (String)fieldNamesFromQuery.get(i);
                String alias = fieldName.toLowerCase();
                if (alias.equals(colName = columns[i].name)) continue;
                usingAliases = true;
                break;
            }
        }
        if (usingAliases) {
            fieldNamesFromQuery = rowType.getFieldNames();
            String[] fieldNames = new String[numColumns];
            int[] projections = new int[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                String alias;
                fieldNames[i] = alias = ((String)fieldNamesFromQuery.get(i)).toLowerCase();
                projections[i] = i;
            }
            ProjectOp.ZeroCopyProjection zeroCopy = new ProjectOp.ZeroCopyProjection(fieldNames, columns, projections);
            ScanStatement scanStatement = new ScanStatement(tableSpace, table, zeroCopy, null);
            return new TableScanOp(scanStatement);
        }
        ScanStatement scanStatement = new ScanStatement(tableSpace, table, null);
        return new TableScanOp(scanStatement);
    }

    private PlannerOp planBindableTableScan(Bindables.BindableTableScan scan, RelDataType rowType) {
        Object op;
        if (rowType == null) {
            rowType = scan.getRowType();
        }
        String tableSpace = (String)scan.getTable().getQualifiedName().get(0);
        TableImpl tableImpl = (TableImpl)((Object)scan.getTable().unwrap(Table.class));
        herddb.model.Table table = tableImpl.tableManager.getTable();
        SQLRecordPredicate predicate = null;
        if (!scan.filters.isEmpty()) {
            CompiledSQLExpression where = null;
            if (scan.filters.size() == 1) {
                RexNode expr = (RexNode)scan.filters.get(0);
                where = SQLExpressionCompiler.compileExpression(expr);
            } else {
                CompiledSQLExpression[] operands = new CompiledSQLExpression[scan.filters.size()];
                int i = 0;
                for (RexNode expr : scan.filters) {
                    CompiledSQLExpression condition = SQLExpressionCompiler.compileExpression(expr);
                    operands[i++] = condition;
                }
                where = new CompiledMultiAndExpression(operands);
            }
            predicate = new SQLRecordPredicate(table, null, where);
            TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(tableSpace);
            op = this.scanForIndexAccess(where, table, tableSpaceManager);
            predicate.setIndexOperation((IndexOperation)op);
            CompiledSQLExpression filterPk = this.findFiltersOnPrimaryKey(table, where);
            if (filterPk != null) {
                filterPk = this.remapPositionalAccessToToPrimaryKeyAccessor(filterPk, table, (RelNode)scan);
            }
            predicate.setPrimaryKeyFilter(filterPk);
        }
        ArrayList<RexNode> projections = new ArrayList<RexNode>(scan.projects.size());
        int i = 0;
        op = scan.projects.iterator();
        while (op.hasNext()) {
            int fieldpos = (Integer)op.next();
            projections.add((RexNode)new RexInputRef(fieldpos, ((RelDataTypeField)rowType.getFieldList().get(i++)).getType()));
        }
        Projection projection = this.buildProjection(projections, rowType, true, table.columns);
        ScanStatement scanStatement = new ScanStatement(tableSpace, table.name, projection, predicate, null, null);
        scanStatement.setTableDef(table);
        return new BindableTableScanOp(scanStatement);
    }

    private CompiledSQLExpression findFiltersOnPrimaryKey(herddb.model.Table table, CompiledSQLExpression where) throws StatementExecutionException {
        String pk;
        List<CompiledSQLExpression> conditions;
        ArrayList<CompiledSQLExpression> expressions = new ArrayList<CompiledSQLExpression>();
        String[] stringArray = table.primaryKey;
        int n = stringArray.length;
        for (int i = 0; i < n && !(conditions = where.scanForConstraintsOnColumn(pk = stringArray[i], table)).isEmpty(); ++i) {
            expressions.addAll(conditions);
        }
        if (expressions.isEmpty()) {
            return null;
        }
        if (expressions.size() == 1) {
            return (CompiledSQLExpression)expressions.get(0);
        }
        return new CompiledMultiAndExpression(expressions.toArray(new CompiledSQLExpression[expressions.size()]));
    }

    private PlannerOp planProject(EnumerableProject op, RelDataType rowType) {
        PlannerOp input = this.convertRelNode(op.getInput(), null, false, false);
        List projects = op.getProjects();
        RelDataType _rowType = rowType == null ? op.getRowType() : rowType;
        Projection projection = this.buildProjection(projects, _rowType, false, null);
        return new ProjectOp(projection, input);
    }

    private PlannerOp planEnumerableHashJoin(EnumerableHashJoin op, RelDataType rowType) {
        PlannerOp left = this.convertRelNode(op.getLeft(), null, false, false);
        PlannerOp right = this.convertRelNode(op.getRight(), null, false, false);
        JoinInfo analyzeCondition = op.analyzeCondition();
        int[] leftKeys = analyzeCondition.leftKeys.toIntArray();
        int[] rightKeys = analyzeCondition.rightKeys.toIntArray();
        boolean generateNullsOnLeft = op.getJoinType().generatesNullsOnLeft();
        boolean generateNullsOnRight = op.getJoinType().generatesNullsOnRight();
        List<CompiledSQLExpression> nonEquiConditions = this.convertJoinNonEquiConditions(analyzeCondition);
        RelDataType _rowType = rowType == null ? op.getRowType() : rowType;
        List fieldList = _rowType.getFieldList();
        Column[] columns = new Column[fieldList.size()];
        String[] fieldNames = new String[columns.length];
        int i = 0;
        for (RelDataTypeField field : fieldList) {
            Column col = Column.column(field.getName().toLowerCase(), CalcitePlanner.convertToHerdType(field.getType()));
            fieldNames[i] = col.name;
            columns[i++] = col;
        }
        return new JoinOp(fieldNames, columns, leftKeys, left, rightKeys, right, generateNullsOnLeft, generateNullsOnRight, false, nonEquiConditions);
    }

    private List<CompiledSQLExpression> convertJoinNonEquiConditions(JoinInfo analyzeCondition) throws IllegalStateException {
        ArrayList<CompiledSQLExpression> nonEquiConditions = new ArrayList<CompiledSQLExpression>();
        if (!analyzeCondition.isEqui()) {
            for (RexNode rexNode : analyzeCondition.nonEquiConditions) {
                nonEquiConditions.add(SQLExpressionCompiler.compileExpression(rexNode));
            }
        } else if (!analyzeCondition.nonEquiConditions.isEmpty()) {
            throw new IllegalStateException("Unexpected non equi with " + analyzeCondition.nonEquiConditions + " conditions");
        }
        return nonEquiConditions;
    }

    private PlannerOp planEnumerableJoin(EnumerableHashJoin op, RelDataType rowType) {
        PlannerOp left = this.convertRelNode(op.getLeft(), null, false, false);
        PlannerOp right = this.convertRelNode(op.getRight(), null, false, false);
        JoinInfo analyzeCondition = op.analyzeCondition();
        int[] leftKeys = analyzeCondition.leftKeys.toIntArray();
        int[] rightKeys = analyzeCondition.rightKeys.toIntArray();
        boolean generateNullsOnLeft = op.getJoinType().generatesNullsOnLeft();
        boolean generateNullsOnRight = op.getJoinType().generatesNullsOnRight();
        List<CompiledSQLExpression> nonEquiConditions = this.convertJoinNonEquiConditions(analyzeCondition);
        RelDataType _rowType = rowType == null ? op.getRowType() : rowType;
        List fieldList = _rowType.getFieldList();
        Column[] columns = new Column[fieldList.size()];
        String[] fieldNames = new String[columns.length];
        int i = 0;
        for (RelDataTypeField field : fieldList) {
            Column col = Column.column(field.getName().toLowerCase(), CalcitePlanner.convertToHerdType(field.getType()));
            fieldNames[i] = col.name;
            columns[i++] = col;
        }
        return new JoinOp(fieldNames, columns, leftKeys, left, rightKeys, right, generateNullsOnLeft, generateNullsOnRight, false, nonEquiConditions);
    }

    private PlannerOp planEnumerableNestedLoopJoin(EnumerableNestedLoopJoin op, RelDataType rowType) {
        PlannerOp left = this.convertRelNode(op.getLeft(), null, false, false);
        PlannerOp right = this.convertRelNode(op.getRight(), null, false, false);
        CompiledSQLExpression condition = SQLExpressionCompiler.compileExpression(op.getCondition());
        RelDataType _rowType = rowType == null ? op.getRowType() : rowType;
        List fieldList = _rowType.getFieldList();
        Column[] columns = new Column[fieldList.size()];
        String[] fieldNames = new String[columns.length];
        int i = 0;
        for (RelDataTypeField field : fieldList) {
            Column col = Column.column(field.getName().toLowerCase(), CalcitePlanner.convertToHerdType(field.getType()));
            fieldNames[i] = col.name;
            columns[i++] = col;
        }
        return new NestedLoopJoinOp(fieldNames, columns, left, right, condition, op.getJoinType(), false);
    }

    private PlannerOp planEnumerableMergeJoin(EnumerableMergeJoin op, RelDataType rowType) {
        PlannerOp left = this.convertRelNode(op.getLeft(), null, false, false);
        PlannerOp right = this.convertRelNode(op.getRight(), null, false, false);
        JoinInfo analyzeCondition = op.analyzeCondition();
        int[] leftKeys = analyzeCondition.leftKeys.toIntArray();
        int[] rightKeys = analyzeCondition.rightKeys.toIntArray();
        boolean generateNullsOnLeft = op.getJoinType().generatesNullsOnLeft();
        boolean generateNullsOnRight = op.getJoinType().generatesNullsOnRight();
        RelDataType _rowType = rowType == null ? op.getRowType() : rowType;
        List<CompiledSQLExpression> nonEquiConditions = this.convertJoinNonEquiConditions(analyzeCondition);
        List fieldList = _rowType.getFieldList();
        Column[] columns = new Column[fieldList.size()];
        String[] fieldNames = new String[columns.length];
        int i = 0;
        for (RelDataTypeField field : fieldList) {
            Column col = Column.column(field.getName().toLowerCase(), CalcitePlanner.convertToHerdType(field.getType()));
            fieldNames[i] = col.name;
            columns[i++] = col;
        }
        return new JoinOp(fieldNames, columns, leftKeys, left, rightKeys, right, generateNullsOnLeft, generateNullsOnRight, true, nonEquiConditions);
    }

    private Projection buildProjection(List<RexNode> projects, RelDataType rowType, boolean allowIdentity, Column[] tableSchema) {
        boolean allowZeroCopyProjection = true;
        ArrayList<CompiledSQLExpression> fields = new ArrayList<CompiledSQLExpression>(projects.size());
        Column[] columns = new Column[projects.size()];
        String[] fieldNames = new String[columns.length];
        int i = 0;
        int[] zeroCopyProjections = new int[fieldNames.length];
        boolean identity = allowIdentity && tableSchema != null && tableSchema.length == fieldNames.length;
        for (RexNode node : projects) {
            CompiledSQLExpression exp = SQLExpressionCompiler.compileExpression(node);
            if (exp instanceof AccessCurrentRowExpression) {
                int mappedIndex;
                AccessCurrentRowExpression accessCurrentRowExpression = (AccessCurrentRowExpression)exp;
                zeroCopyProjections[i] = mappedIndex = accessCurrentRowExpression.getIndex();
                if (i != mappedIndex) {
                    identity = false;
                }
            } else {
                allowZeroCopyProjection = false;
            }
            fields.add(exp);
            Column col = Column.column(((String)rowType.getFieldNames().get(i)).toLowerCase(), CalcitePlanner.convertToHerdType(node.getType()));
            identity = identity && col.name.equals(tableSchema[i].name);
            fieldNames[i] = col.name;
            columns[i++] = col;
        }
        if (allowZeroCopyProjection) {
            if (identity) {
                return Projection.IDENTITY(fieldNames, columns);
            }
            return new ProjectOp.ZeroCopyProjection(fieldNames, columns, zeroCopyProjections);
        }
        return new ProjectOp.BasicProjection(fieldNames, columns, fields);
    }

    private PlannerOp planValues(EnumerableValues op) {
        ArrayList<List<CompiledSQLExpression>> tuples = new ArrayList<List<CompiledSQLExpression>>(op.getTuples().size());
        RelDataType rowType = op.getRowType();
        List fieldList = rowType.getFieldList();
        Column[] columns = new Column[fieldList.size()];
        for (ImmutableList tuple : op.getTuples()) {
            ArrayList<CompiledSQLExpression> row = new ArrayList<CompiledSQLExpression>(tuple.size());
            for (RexLiteral node : tuple) {
                CompiledSQLExpression exp = SQLExpressionCompiler.compileExpression((RexNode)node);
                row.add(exp);
            }
            tuples.add(row);
        }
        int i = 0;
        String[] fieldNames = new String[fieldList.size()];
        for (RelDataTypeField field : fieldList) {
            Column col = Column.column(field.getName(), CalcitePlanner.convertToHerdType(field.getType()));
            fieldNames[i] = field.getName();
            columns[i++] = col;
        }
        return new ValuesOp(this.manager.getNodeId(), fieldNames, columns, tuples);
    }

    private PlannerOp planSort(EnumerableSort op, RelDataType rowType) {
        PlannerOp input = this.convertRelNode(op.getInput(), rowType, false, false);
        RelCollation collation = op.getCollation();
        List fieldCollations = collation.getFieldCollations();
        boolean[] directions = new boolean[fieldCollations.size()];
        int[] fields = new int[fieldCollations.size()];
        int i = 0;
        for (RelFieldCollation col : fieldCollations) {
            RelFieldCollation.Direction direction = col.getDirection();
            int index = col.getFieldIndex();
            directions[i] = direction == RelFieldCollation.Direction.ASCENDING || direction == RelFieldCollation.Direction.STRICTLY_ASCENDING;
            fields[i++] = index;
        }
        return new SortOp(input, directions, fields);
    }

    private PlannerOp planInterpreter(EnumerableInterpreter op, RelDataType rowType, boolean returnValues) {
        return this.convertRelNode(op.getInput(), rowType, returnValues, false);
    }

    private PlannerOp planLimit(EnumerableLimit op, RelDataType rowType) {
        PlannerOp input = this.convertRelNode(op.getInput(), rowType, false, false);
        CompiledSQLExpression maxRows = SQLExpressionCompiler.compileExpression(op.fetch);
        CompiledSQLExpression offset = SQLExpressionCompiler.compileExpression(op.offset);
        return new LimitOp(input, maxRows, offset);
    }

    private PlannerOp planFilter(EnumerableFilter op, RelDataType rowType, boolean returnValues) {
        PlannerOp input = this.convertRelNode(op.getInput(), rowType, returnValues, false);
        CompiledSQLExpression condition = SQLExpressionCompiler.compileExpression(op.getCondition());
        return new FilterOp(input, condition);
    }

    private PlannerOp planEnumerableUnion(EnumerableUnion op, RelDataType rowType, boolean returnValues) {
        if (!op.all) {
            throw new StatementExecutionException("not suppoer UNION, all=false");
        }
        ArrayList<PlannerOp> inputs = new ArrayList<PlannerOp>(op.getInputs().size());
        for (RelNode input : op.getInputs()) {
            PlannerOp inputOp = this.convertRelNode(input, rowType, false, false).optimize();
            inputs.add(inputOp);
        }
        return new UnionAllOp(inputs);
    }

    private PlannerOp planAggregate(EnumerableAggregate op, RelDataType rowType, boolean returnValues) {
        List fieldList = op.getRowType().getFieldList();
        List calls = op.getAggCallList();
        String[] fieldnames = new String[fieldList.size()];
        String[] aggtypes = new String[calls.size()];
        Column[] columns = new Column[fieldList.size()];
        List groupedFiledsIndexes = op.getGroupSet().toList();
        ArrayList<List<Integer>> argLists = new ArrayList<List<Integer>>(calls.size());
        int i = 0;
        int idaggcall = 0;
        for (RelDataTypeField c : fieldList) {
            Column co;
            int type = CalcitePlanner.convertToHerdType(c.getType());
            columns[i] = co = Column.column(c.getName(), type);
            fieldnames[i] = c.getName().toLowerCase();
            ++i;
        }
        for (AggregateCall call : calls) {
            aggtypes[idaggcall++] = call.getAggregation().getName();
            argLists.add(call.getArgList());
        }
        PlannerOp input = this.convertRelNode(op.getInput(), null, returnValues, false);
        return new AggregateOp(input, fieldnames, columns, aggtypes, argLists, groupedFiledsIndexes);
    }

    public static int convertToHerdType(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case VARCHAR: 
            case CHAR: {
                return 0;
            }
            case BOOLEAN: {
                return 7;
            }
            case INTEGER: {
                return 2;
            }
            case BIGINT: {
                return 1;
            }
            case VARBINARY: {
                return 3;
            }
            case NULL: {
                return 5;
            }
            case TIMESTAMP: {
                return 4;
            }
            case DECIMAL: {
                return 6;
            }
            case ANY: {
                return 10;
            }
        }
        throw new StatementExecutionException("unsupported expression type " + type.getSqlTypeName());
    }

    private static SQLRecordKeyFunction findIndexAccess(CompiledSQLExpression where, String[] columnsToMatch, ColumnsList table, String operator, BindableTableScanColumnNameResolver res) throws StatementExecutionException {
        String pk;
        List<CompiledSQLExpression> conditions;
        ArrayList<CompiledSQLExpression> expressions = new ArrayList<CompiledSQLExpression>();
        ArrayList<String> columns = new ArrayList<String>();
        String[] stringArray = columnsToMatch;
        int n = stringArray.length;
        for (int i = 0; i < n && !(conditions = where.scanForConstraintedValueOnColumnWithOperator(pk = stringArray[i], operator, res)).isEmpty(); ++i) {
            columns.add(pk);
            expressions.add(conditions.get(0));
        }
        if (expressions.isEmpty()) {
            return null;
        }
        return new SQLRecordKeyFunction(columns, expressions, table);
    }

    private IndexOperation scanForIndexAccess(CompiledSQLExpression expressionWhere, herddb.model.Table table, TableSpaceManager tableSpaceManager) {
        Map<String, AbstractIndexManager> indexes;
        SQLRecordKeyFunction keyFunction = CalcitePlanner.findIndexAccess(expressionWhere, table.primaryKey, table, "=", table);
        IndexOperation result = null;
        if (keyFunction != null) {
            result = keyFunction.isFullPrimaryKey() ? new PrimaryIndexSeek(keyFunction) : new PrimaryIndexPrefixScan(keyFunction);
        } else {
            SQLRecordKeyFunction rangeMax;
            SQLRecordKeyFunction rangeMin = CalcitePlanner.findIndexAccess(expressionWhere, table.primaryKey, table, ">=", table);
            if (rangeMin != null && !rangeMin.isFullPrimaryKey()) {
                rangeMin = null;
            }
            if (rangeMin == null && (rangeMin = CalcitePlanner.findIndexAccess(expressionWhere, table.primaryKey, table, ">", table)) != null && !rangeMin.isFullPrimaryKey()) {
                rangeMin = null;
            }
            if ((rangeMax = CalcitePlanner.findIndexAccess(expressionWhere, table.primaryKey, table, "<=", table)) != null && !rangeMax.isFullPrimaryKey()) {
                rangeMax = null;
            }
            if (rangeMax == null && (rangeMax = CalcitePlanner.findIndexAccess(expressionWhere, table.primaryKey, table, "<", table)) != null && !rangeMax.isFullPrimaryKey()) {
                rangeMax = null;
            }
            if (rangeMin != null || rangeMax != null) {
                result = new PrimaryIndexRangeScan(table.primaryKey, rangeMin, rangeMax);
            }
        }
        if (result == null && (indexes = tableSpaceManager.getIndexesOnTable(table.name)) != null) {
            for (AbstractIndexManager index : indexes.values()) {
                IndexOperation secondaryIndexOperation;
                if (!index.isAvailable() || (secondaryIndexOperation = CalcitePlanner.findSecondaryIndexOperation(index, expressionWhere, table)) == null) continue;
                result = secondaryIndexOperation;
                break;
            }
        }
        return result;
    }

    private static IndexOperation findSecondaryIndexOperation(AbstractIndexManager index, CompiledSQLExpression where, herddb.model.Table table) throws StatementExecutionException {
        IndexOperation secondaryIndexOperation = null;
        String[] columnsToMatch = index.getColumnNames();
        SQLRecordKeyFunction indexSeekFunction = CalcitePlanner.findIndexAccess(where, columnsToMatch, index.getIndex(), "=", table);
        if (indexSeekFunction != null) {
            secondaryIndexOperation = indexSeekFunction.isFullPrimaryKey() ? new SecondaryIndexSeek(index.getIndexName(), columnsToMatch, indexSeekFunction) : new SecondaryIndexPrefixScan(index.getIndexName(), columnsToMatch, indexSeekFunction);
        } else {
            SQLRecordKeyFunction rangeMax;
            SQLRecordKeyFunction rangeMin = CalcitePlanner.findIndexAccess(where, columnsToMatch, index.getIndex(), ">=", table);
            if (rangeMin != null && !rangeMin.isFullPrimaryKey()) {
                rangeMin = null;
            }
            if (rangeMin == null && (rangeMin = CalcitePlanner.findIndexAccess(where, columnsToMatch, index.getIndex(), ">", table)) != null && !rangeMin.isFullPrimaryKey()) {
                rangeMin = null;
            }
            if ((rangeMax = CalcitePlanner.findIndexAccess(where, columnsToMatch, index.getIndex(), "<=", table)) != null && !rangeMax.isFullPrimaryKey()) {
                rangeMax = null;
            }
            if (rangeMax == null && (rangeMax = CalcitePlanner.findIndexAccess(where, columnsToMatch, index.getIndex(), "<", table)) != null && !rangeMax.isFullPrimaryKey()) {
                rangeMax = null;
            }
            if (rangeMin != null || rangeMax != null) {
                secondaryIndexOperation = new SecondaryIndexRangeScan(index.getIndexName(), columnsToMatch, rangeMin, rangeMax);
            }
        }
        return secondaryIndexOperation;
    }

    private static boolean isCachable(String query) {
        return true;
    }

    private static class PlannerResult {
        private final RelNode topNode;
        private final RelDataType originalRowType;
        private final RelNode logicalPlan;

        public PlannerResult(RelNode topNode, RelDataType originalRowType, RelNode logicalPlan) {
            this.topNode = topNode;
            this.originalRowType = originalRowType;
            this.logicalPlan = logicalPlan;
        }
    }

    private static final class TableImpl
    extends AbstractTable
    implements ModifiableTable,
    ScannableTable,
    ProjectableFilterableTable {
        final AbstractTableManager tableManager;
        final ImmutableList<ImmutableBitSet> keys;

        private TableImpl(AbstractTableManager tableManager) {
            this.tableManager = tableManager;
            ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            herddb.model.Table table = tableManager.getTable();
            int index = 0;
            for (Column c : table.getColumns()) {
                if (table.isPrimaryKeyColumn(c.name)) {
                    builder.set(index);
                }
                ++index;
            }
            this.keys = ImmutableList.of((Object)builder.build());
        }

        private static boolean isColumnNullable(Column c, herddb.model.Table t) {
            return (!t.isPrimaryKeyColumn(c.name) || t.auto_increment) && !ColumnTypes.isNotNullDataType(c.type);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(typeFactory);
            herddb.model.Table table = this.tableManager.getTable();
            for (Column c : table.getColumns()) {
                boolean nullable = TableImpl.isColumnNullable(c, table);
                builder.add(c.name, TableImpl.convertType(c.type, typeFactory, nullable));
            }
            return builder.build();
        }

        public Statistic getStatistic() {
            return Statistics.of((double)this.tableManager.getStats().getTablesize(), this.keys);
        }

        public Collection getModifiableCollection() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
            return LogicalTableModify.create((RelOptTable)table, (Prepare.CatalogReader)catalogReader, (RelNode)child, (TableModify.Operation)operation, updateColumnList, sourceExpressionList, (boolean)flattened);
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Type getElementType() {
            return Object.class;
        }

        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            return null;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, int[] projects) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private static RelDataType convertType(int type, RelDataTypeFactory typeFactory, boolean nullable) {
            RelDataType relDataType = TableImpl.convertTypeNotNull(type, typeFactory);
            if (nullable) {
                return typeFactory.createTypeWithNullability(relDataType, true);
            }
            return relDataType;
        }

        private static RelDataType convertTypeNotNull(int type, RelDataTypeFactory typeFactory) {
            switch (type) {
                case 7: {
                    return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
                }
                case 2: 
                case 12: {
                    return typeFactory.createSqlType(SqlTypeName.INTEGER);
                }
                case 0: 
                case 11: {
                    return typeFactory.createSqlType(SqlTypeName.VARCHAR);
                }
                case 3: {
                    return typeFactory.createSqlType(SqlTypeName.VARBINARY);
                }
                case 1: 
                case 13: {
                    return typeFactory.createSqlType(SqlTypeName.BIGINT);
                }
                case 4: {
                    return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
                }
            }
            return typeFactory.createSqlType(SqlTypeName.ANY);
        }
    }
}

