/*
 * Decompiled with CFR 0.152.
 */
package herddb.server;

import herddb.cluster.BookkeeperCommitLogManager;
import herddb.cluster.EmbeddedBookie;
import herddb.cluster.ZookeeperMetadataStorageManager;
import herddb.core.DBManager;
import herddb.core.stats.ConnectionsInfo;
import herddb.core.stats.ConnectionsInfoProvider;
import herddb.file.FileBasedUserManager;
import herddb.file.FileCommitLogManager;
import herddb.file.FileDataStorageManager;
import herddb.file.FileMetadataStorageManager;
import herddb.log.CommitLogManager;
import herddb.mem.MemoryCommitLogManager;
import herddb.mem.MemoryDataStorageManager;
import herddb.mem.MemoryLocalNodeIdManager;
import herddb.mem.MemoryMetadataStorageManager;
import herddb.metadata.MetadataStorageManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.network.Channel;
import herddb.network.ServerHostData;
import herddb.network.ServerSideConnection;
import herddb.network.ServerSideConnectionAcceptor;
import herddb.network.netty.NettyChannelAcceptor;
import herddb.network.netty.NetworkUtils;
import herddb.security.SimpleSingleUserManager;
import herddb.security.UserManager;
import herddb.server.LocalNodeIdManager;
import herddb.server.ServerConfiguration;
import herddb.server.ServerSideConnectionPeer;
import herddb.storage.DataStorageManager;
import herddb.utils.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

public class Server
implements AutoCloseable,
ServerSideConnectionAcceptor<ServerSideConnection>,
ConnectionsInfoProvider {
    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    private final DBManager manager;
    private final NettyChannelAcceptor networkServer;
    private final ServerConfiguration configuration;
    private final StatsLogger statsLogger;
    private final Path baseDirectory;
    private final Path dataDirectory;
    private final Path tmpDirectory;
    private final ServerHostData serverHostData;
    private final Map<Long, ServerSideConnectionPeer> connections = new ConcurrentHashMap<Long, ServerSideConnectionPeer>();
    private final String mode;
    private final MetadataStorageManager metadataStorageManager;
    private String jdbcUrl;
    private UserManager userManager;
    private EmbeddedBookie embeddedBookie;

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public MetadataStorageManager getMetadataStorageManager() {
        return this.metadataStorageManager;
    }

    public DBManager getManager() {
        return this.manager;
    }

    public NettyChannelAcceptor getNetworkServer() {
        return this.networkServer;
    }

    public Server(ServerConfiguration configuration) {
        this(configuration, null);
    }

    public Server(ServerConfiguration configuration, StatsLogger statsLogger) {
        String advertised_host;
        this.statsLogger = statsLogger == null ? new NullStatsLogger() : statsLogger;
        this.configuration = configuration;
        String nodeId = configuration.getString("server.node.id", "");
        this.mode = configuration.getString("server.mode", "standalone");
        this.baseDirectory = Paths.get(configuration.getString("server.base.dir", "dbdata"), new String[0]).toAbsolutePath();
        try {
            Files.createDirectories(this.baseDirectory, new FileAttribute[0]);
        }
        catch (IOException ignore) {
            LOGGER.log(Level.SEVERE, "Cannot create baseDirectory " + this.baseDirectory, ignore);
        }
        this.dataDirectory = this.baseDirectory.resolve(configuration.getString("server.data.dir", "data"));
        this.tmpDirectory = this.baseDirectory.resolve(configuration.getString("server.tmp.dir", "tmp"));
        String usersfile = configuration.getString("server.users.file", "");
        if (usersfile.isEmpty()) {
            this.userManager = new SimpleSingleUserManager(configuration);
        } else {
            try {
                Path userDirectoryFile = this.baseDirectory.resolve(usersfile).toAbsolutePath();
                LOGGER.log(Level.INFO, "Reading users from file " + userDirectoryFile);
                this.userManager = new FileBasedUserManager(userDirectoryFile);
            }
            catch (IOException error) {
                throw new RuntimeException(error);
            }
        }
        this.metadataStorageManager = this.buildMetadataStorageManager();
        String host = configuration.getString("server.host", "localhost");
        int port = configuration.getInt("server.port", 7000);
        LOGGER.log(Level.INFO, "Configured network parameters: server.host={0}, server.port={1}", new Object[]{host, port});
        if (host.trim().isEmpty()) {
            String _host = "0.0.0.0";
            LOGGER.log(Level.INFO, "As configuration parameter server.host is {0}, I have choosen to use {1}. Set to a non-empty value in order to use a fixed hostname", new Object[]{host, _host});
            host = _host;
        }
        if (port <= 0) {
            try {
                int _port = NetworkUtils.assignFirstFreePort();
                LOGGER.log(Level.INFO, "As configuration parameter server.port is {0},I have choosen to listen on port {1}. Set to a positive number in order to use a fixed port", new Object[]{Integer.toString(port), Integer.toString(_port)});
                port = _port;
            }
            catch (IOException err) {
                LOGGER.log(Level.SEVERE, "Cannot find a free port", err);
                throw new RuntimeException(err);
            }
        }
        if ((advertised_host = configuration.getString("server.advertised.host", host)).trim().isEmpty() || advertised_host.equals("0.0.0.0")) {
            try {
                String _host = NetworkUtils.getLocalNetworkAddress();
                LOGGER.log(Level.INFO, "As configuration parameter server.advertised.host is {0}, I have choosen to use {1}. Set to a non-empty value in order to use a fixed hostname", new Object[]{advertised_host, _host});
                advertised_host = _host;
            }
            catch (IOException err) {
                LOGGER.log(Level.SEVERE, "Cannot get local host name", err);
                throw new RuntimeException(err);
            }
        }
        int advertised_port = configuration.getInt("server.advertised.port", port);
        HashMap<String, String> realData = new HashMap<String, String>();
        realData.put("server.host", host);
        realData.put("server.port", port + "");
        LOGGER.info("Public endpoint: server.advertised.host=" + advertised_host + ", Public endpoint: " + "server.advertised.port" + "=" + advertised_port);
        this.serverHostData = new ServerHostData(advertised_host, advertised_port, "", configuration.getBoolean("server.ssl", false), realData);
        if (nodeId.isEmpty()) {
            LocalNodeIdManager localNodeIdManager = this.buildLocalNodeIdManager();
            try {
                nodeId = localNodeIdManager.readLocalNodeId();
                if (nodeId == null) {
                    this.metadataStorageManager.start();
                    nodeId = this.metadataStorageManager.generateNewNodeId(configuration);
                    LOGGER.info("Generated new node id " + nodeId);
                    localNodeIdManager.persistLocalNodeId(nodeId);
                }
            }
            catch (MetadataStorageManagerException | IOException error) {
                LOGGER.log(Level.SEVERE, "Fatal error while generating the local node ID", error);
                throw new RuntimeException(new Exception("Fatal error while generating the local node ID: " + error, error));
            }
        }
        this.manager = new DBManager(nodeId, this.metadataStorageManager, this.buildDataStorageManager(), this.buildCommitLogManager(), this.tmpDirectory, this.serverHostData, configuration, statsLogger);
        this.manager.setClearAtBoot(configuration.getBoolean("server.clear.at.boot", false));
        this.manager.setHaltOnTableSpaceBootError(configuration.getBoolean("server.halt.on.tablespace.boot.error", false));
        this.manager.setConnectionsInfoProvider(this);
        this.manager.setServerToServerUsername(configuration.getString("server.username", "sa"));
        this.manager.setServerToServerPassword(configuration.getString("server.password", "hdb"));
        this.manager.setCheckpointPeriod(configuration.getLong("server.checkpoint.period", 900000L));
        this.manager.setAbandonedTransactionsTimeout(configuration.getLong("server.abandoned.transactions.timeout", 900000L));
        boolean enforeLeadership = configuration.getBoolean("server.enforce.leadership", true);
        this.manager.setErrorIfNotLeader(enforeLeadership);
        this.networkServer = this.buildChannelAcceptor();
        this.networkServer.setAcceptor((ServerSideConnectionAcceptor)this);
        switch (this.mode) {
            case "local": {
                this.jdbcUrl = "jdbc:herddb:server:" + this.serverHostData.getHost() + ":" + this.serverHostData.getPort();
                LOGGER.info("JDBC URL is not available. This server will not be accessible outside the JVM");
                break;
            }
            case "standalone": {
                this.jdbcUrl = "jdbc:herddb:server:" + this.serverHostData.getHost() + ":" + this.serverHostData.getPort();
                LOGGER.log(Level.INFO, "Use this JDBC URL to connect to this server: {0}", new Object[]{this.jdbcUrl});
                break;
            }
            case "cluster": {
                this.embeddedBookie = new EmbeddedBookie(this.baseDirectory, configuration, (ZookeeperMetadataStorageManager)this.metadataStorageManager, statsLogger);
                this.jdbcUrl = "jdbc:herddb:zookeeper:" + configuration.getString("server.zookeeper.address", "localhost:1281") + configuration.getString("server.zookeeper.path", "/herd");
                LOGGER.log(Level.INFO, "Use this JDBC URL to connect to this HerdDB cluster: {0}", new Object[]{this.jdbcUrl});
                break;
            }
            default: {
                throw new IllegalStateException("invalid server.mode=" + this.mode);
            }
        }
        LOGGER.log(Level.INFO, "HerdDB version {0}", new Object[]{Version.getVERSION()});
        LOGGER.log(Level.INFO, "Local server.node.id is {0}", new Object[]{nodeId});
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    private NettyChannelAcceptor buildChannelAcceptor() {
        String realHost = (String)this.serverHostData.getAdditionalData().get("server.host");
        int realPort = Integer.parseInt((String)this.serverHostData.getAdditionalData().get("server.port"));
        NettyChannelAcceptor acceptor = new NettyChannelAcceptor(realHost, realPort, this.serverHostData.isSsl(), this.statsLogger.scope("network"));
        boolean isLocal = "local".equals(this.mode);
        boolean nextworkEnabled = this.configuration.getBoolean("server.network.enabled", !isLocal);
        if (!nextworkEnabled) {
            acceptor.setEnableRealNetwork(false);
            LOGGER.log(Level.INFO, "Local in-JVM acceptor on {0}:{1} ssl:{2}", new Object[]{realHost, realPort, this.serverHostData.isSsl()});
        } else {
            LOGGER.log(Level.INFO, "Binding network acceptor to {0}:{1} ssl:{2}", new Object[]{realHost, realPort, this.serverHostData.isSsl()});
        }
        int callbackThreads = this.configuration.getInt("server.network.thread.callback.workers", 64);
        int workerThreads = this.configuration.getInt("server.network.thread.workers", 16);
        acceptor.setCallbackThreads(callbackThreads);
        acceptor.setWorkerThreads(workerThreads);
        return acceptor;
    }

    private MetadataStorageManager buildMetadataStorageManager() {
        switch (this.mode) {
            case "local": {
                return new MemoryMetadataStorageManager();
            }
            case "standalone": {
                Path metadataDirectory = this.baseDirectory.resolve(this.configuration.getString("server.metadata.dir", "metadata"));
                return new FileMetadataStorageManager(metadataDirectory);
            }
            case "cluster": {
                return new ZookeeperMetadataStorageManager(this.configuration.getString("server.zookeeper.address", "localhost:1281"), this.configuration.getInt("server.zookeeper.session.timeout", 40000), this.configuration.getString("server.zookeeper.path", "/herd"));
            }
        }
        throw new RuntimeException();
    }

    private DataStorageManager buildDataStorageManager() {
        switch (this.mode) {
            case "local": {
                return new MemoryDataStorageManager();
            }
            case "standalone": 
            case "cluster": {
                int diskswapThreshold = this.configuration.getInt("server.disk.swap.max.records", 10000);
                boolean requirefsync = this.configuration.getBoolean("requirefsync", ServerConfiguration.PROPERTY_REQUIRE_FSYNC_DEFAULT);
                boolean pageodirect = this.configuration.getBoolean("page.use_o_direct", ServerConfiguration.PROPERTY_PAGE_USE_ODIRECT_DEFAULT);
                boolean indexodirect = this.configuration.getBoolean("index.use_o_direct", ServerConfiguration.PROPERTY_INDEX_USE_ODIRECT_DEFAULT);
                return new FileDataStorageManager(this.dataDirectory, this.tmpDirectory, diskswapThreshold, requirefsync, pageodirect, indexodirect, this.statsLogger);
            }
        }
        throw new RuntimeException();
    }

    protected CommitLogManager buildCommitLogManager() {
        switch (this.mode) {
            case "local": {
                return new MemoryCommitLogManager();
            }
            case "standalone": {
                Path logDirectory = this.baseDirectory.resolve(this.configuration.getString("server.log.dir", "txlog"));
                return new FileCommitLogManager(logDirectory, this.configuration.getLong("txlog.maxfilesize", 0x4000000L), this.configuration.getInt("txlog.maxsyncbatchsize", 10000), this.configuration.getInt("txlog.maxsyncbatchbytes", 524288), this.configuration.getInt("txlog.synctimeout", 1), this.configuration.getBoolean("requirefsync", ServerConfiguration.PROPERTY_REQUIRE_FSYNC_DEFAULT), this.configuration.getBoolean("txlog.use_o_direct", ServerConfiguration.PROPERTY_TXLOG_USE_ODIRECT_DEFAULT), this.configuration.getInt("txlog.deferredsyncperiod", 0), this.statsLogger.scope("txlog"));
            }
            case "cluster": {
                long limit;
                BookkeeperCommitLogManager bkmanager = new BookkeeperCommitLogManager((ZookeeperMetadataStorageManager)this.metadataStorageManager, this.configuration, this.statsLogger);
                bkmanager.setAckQuorumSize(this.configuration.getInt("server.bookkeeper.ack.quorum.size", 1));
                bkmanager.setEnsemble(this.configuration.getInt("server.bookkeeper.ensemble.size", 1));
                bkmanager.setWriteQuorumSize(this.configuration.getInt("server.bookkeeper.write.quorum.size", 1));
                long ledgersRetentionPeriod = this.configuration.getLong("server.bookkeeper.ledgers.retention.period", 172800000L);
                bkmanager.setLedgersRetentionPeriod(ledgersRetentionPeriod);
                long maxLedgerSizeBytes = this.configuration.getLong("server.bookkeeper.ledgers.max.size", 0x40000000L);
                bkmanager.setMaxLedgerSizeBytes(maxLedgerSizeBytes);
                long maxIdleTime = this.configuration.getLong("server.bookkeeper.max.idle.time", 10000L);
                bkmanager.setMaxIdleTime(maxIdleTime);
                long checkPointperiod = this.configuration.getLong("server.checkpoint.period", 900000L);
                if (checkPointperiod > 0L && ledgersRetentionPeriod > 0L && checkPointperiod > (limit = ledgersRetentionPeriod / 2L)) {
                    throw new RuntimeException("server.checkpoint.period=" + checkPointperiod + " must be less then " + "server.bookkeeper.ledgers.retention.period" + "/2=" + limit);
                }
                return bkmanager;
            }
        }
        throw new RuntimeException();
    }

    private LocalNodeIdManager buildLocalNodeIdManager() {
        switch (this.mode) {
            case "local": {
                return new MemoryLocalNodeIdManager(this.dataDirectory);
            }
            case "standalone": {
                return new LocalNodeIdManager(this.dataDirectory);
            }
            case "cluster": {
                return new LocalNodeIdManager(this.dataDirectory);
            }
        }
        throw new RuntimeException();
    }

    public void start() throws Exception {
        boolean startBookie = this.configuration.getBoolean("server.bookkeeper.start", false);
        if (startBookie && this.embeddedBookie != null) {
            this.embeddedBookie.start();
        }
        this.manager.start();
        this.networkServer.start();
    }

    public void waitForStandaloneBoot() throws Exception {
        this.waitForTableSpaceBoot("herd", true);
    }

    public void waitForTableSpaceBoot(String tableSpace, boolean leader) throws Exception {
        this.waitForTableSpaceBoot(tableSpace, 180000, leader);
    }

    public void waitForTableSpaceBoot(String tableSpace, int timeout, boolean leader) throws Exception {
        if (!this.manager.waitForTablespace(tableSpace, timeout, leader)) {
            throw new Exception("TableSpace " + tableSpace + " not started within " + timeout + " ms");
        }
    }

    public void waitForBootOfLocalTablespaces(int timeout) throws Exception {
        this.manager.waitForBootOfLocalTablespaces(timeout);
    }

    @Override
    public void close() throws Exception {
        try {
            this.networkServer.close();
        }
        catch (Throwable error) {
            LOGGER.log(Level.SEVERE, "error while stopping Network Manager" + error, error);
        }
        try {
            this.manager.close();
        }
        catch (Throwable error) {
            LOGGER.log(Level.SEVERE, "error while stopping embedded DBManager " + error, error);
        }
        if (this.embeddedBookie != null) {
            try {
                this.embeddedBookie.close();
            }
            catch (Throwable error) {
                LOGGER.log(Level.SEVERE, "error while stopping embedded bookie " + error, error);
            }
        }
    }

    protected ServerSideConnectionPeer buildPeer(Channel channel) {
        return new ServerSideConnectionPeer(channel, this);
    }

    public ServerSideConnection createConnection(Channel channel) {
        ServerSideConnectionPeer peer = this.buildPeer(channel);
        this.connections.put(peer.getConnectionId(), peer);
        return peer;
    }

    Map<Long, ServerSideConnectionPeer> getConnections() {
        return this.connections;
    }

    void connectionClosed(ServerSideConnectionPeer connection) {
        this.connections.remove(connection.getConnectionId());
    }

    public String getNodeId() {
        return this.manager.getNodeId();
    }

    public ServerHostData getServerHostData() {
        return this.serverHostData;
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    @Override
    public ConnectionsInfo getActualConnections() {
        return new ConnectionsInfo(this.connections.values().stream().map(c -> c.toConnectionInfo()).collect(Collectors.toList()));
    }
}

