/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.MaterializedRecordSet;
import herddb.core.SimpleDataScanner;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.ConcatenatedDataAccessor;
import herddb.model.planner.EnumerableDataScanner;
import herddb.model.planner.PlannerOp;
import herddb.sql.CalciteEnumUtils;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.Arrays;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;
import org.apache.calcite.linq4j.JoinType;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Predicate2;
import org.apache.calcite.rel.core.JoinRelType;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class NestedLoopJoinOp
implements PlannerOp {
    private final PlannerOp left;
    private final PlannerOp right;
    private final String[] fieldNames;
    private final Column[] columns;
    private final JoinRelType joinRelType;
    private final CompiledSQLExpression condition;

    public NestedLoopJoinOp(String[] fieldNames, Column[] columns, PlannerOp left, PlannerOp right, CompiledSQLExpression condition, JoinRelType joinRelType, boolean mergeJoin) {
        this.fieldNames = fieldNames;
        this.columns = columns;
        this.left = left.optimize();
        this.right = right.optimize();
        this.joinRelType = joinRelType;
        this.condition = condition;
    }

    @Override
    public String getTablespace() {
        return this.left.getTablespace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        ScanResult resLeft = (ScanResult)this.left.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        DataScanner leftScanner = resLeft.dataScanner;
        transactionContext = new TransactionContext(resLeft.transactionId);
        ScanResult resRight = (ScanResult)this.right.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        DataScanner rightScanner = resRight.dataScanner;
        JoinType linq4jJoinType = CalciteEnumUtils.toLinq4jJoinType(this.joinRelType);
        if (!linq4jJoinType.generatesNullsOnLeft() && !rightScanner.isRewindSupported()) {
            try {
                MaterializedRecordSet recordSet = tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(rightScanner.getFieldNames(), rightScanner.getSchema());
                rightScanner.forEach(d -> recordSet.add((DataAccessor)d));
                recordSet.writeFinished();
                SimpleDataScanner materialized = new SimpleDataScanner(rightScanner.getTransaction(), recordSet);
                rightScanner.close();
                rightScanner = materialized;
            }
            catch (DataScannerException err) {
                throw new StatementExecutionException(err);
            }
        }
        long resTransactionId = resRight.transactionId;
        String[] fieldNamesFromLeft = leftScanner.getFieldNames();
        String[] fieldNamesFromRight = rightScanner.getFieldNames();
        Function2<DataAccessor, DataAccessor, DataAccessor> resultProjection = this.resultProjection(fieldNamesFromLeft, fieldNamesFromRight);
        Enumerable result = EnumerableDefaults.nestedLoopJoin(leftScanner.createNonRewindableEnumerable(), rightScanner.createRewindOnCloseEnumerable(), this.predicate(resultProjection, context), resultProjection, (JoinType)linq4jJoinType);
        EnumerableDataScanner joinedScanner = new EnumerableDataScanner(rightScanner.getTransaction(), this.fieldNames, this.columns, (Enumerable<DataAccessor>)result, leftScanner, rightScanner);
        return new ScanResult(resTransactionId, joinedScanner);
    }

    private Predicate2<DataAccessor, DataAccessor> predicate(Function2<DataAccessor, DataAccessor, DataAccessor> projection, StatementEvaluationContext context) {
        return (v0, v1) -> {
            DataAccessor currentRow = (DataAccessor)projection.apply(v0, v1);
            return SQLRecordPredicateFunctions.toBoolean((Object)this.condition.evaluate(currentRow, context));
        };
    }

    private Function2<DataAccessor, DataAccessor, DataAccessor> resultProjection(String[] fieldNamesFromLeft, String[] fieldNamesFromRight) {
        DataAccessor nullsOnLeft = DataAccessor.ALL_NULLS((String[])fieldNamesFromLeft);
        DataAccessor nullsOnRight = DataAccessor.ALL_NULLS((String[])fieldNamesFromRight);
        return (a, b) -> new ConcatenatedDataAccessor(this.fieldNames, a != null ? a : nullsOnLeft, b != null ? b : nullsOnRight);
    }

    public String toString() {
        return "NestedLoopJoinOp{\nleft=" + this.left + "\n, right=" + this.right + "\n, fieldNames=" + Arrays.toString(this.fieldNames) + "\n, columns=" + Arrays.toString(this.columns) + "\n, joinRelType=" + this.joinRelType + "\n, condition=" + this.condition + '}';
    }
}

