/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.Transaction;
import herddb.utils.DataAccessor;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;

public class EnumerableDataScanner
extends DataScanner {
    private final Enumerator<DataAccessor> wrapped;
    private DataAccessor next;
    private final DataScanner originalLeft;
    private final DataScanner originalRight;

    public EnumerableDataScanner(Transaction transaction, String[] fieldNames, Column[] schema, Enumerable<DataAccessor> wrapped, DataScanner originalLeft, DataScanner originalRight) {
        super(transaction, fieldNames, schema);
        this.originalLeft = originalLeft;
        this.originalRight = originalRight;
        this.wrapped = wrapped.enumerator();
        this.fetchNext();
    }

    @Override
    public boolean hasNext() throws DataScannerException {
        return this.next != null;
    }

    private void fetchNext() {
        this.next = this.wrapped.moveNext() ? (DataAccessor)this.wrapped.current() : null;
    }

    @Override
    public DataAccessor next() throws DataScannerException {
        DataAccessor current = this.next;
        this.fetchNext();
        return current;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws DataScannerException {
        try {
            this.originalLeft.close();
            return;
        }
        catch (RuntimeException err) {
            throw new DataScannerException(err);
        }
        finally {
            try {
                this.originalRight.close();
            }
            catch (RuntimeException err) {
                throw new DataScannerException(err);
            }
            finally {
                try {
                    this.wrapped.close();
                }
                catch (RuntimeException err) {
                    throw new DataScannerException(err);
                }
                finally {
                    super.close();
                }
            }
        }
    }
}

