/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.commands;

import herddb.model.Predicate;
import herddb.model.Projection;
import herddb.model.ScanLimits;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableAwareStatement;
import herddb.model.TupleComparator;

public class ScanStatement
extends TableAwareStatement {
    private Predicate predicate;
    private Projection projection;
    private TupleComparator comparator;
    private ScanLimits limits;
    private Table tableDef;

    public ScanStatement(String tableSpace, Table table, Predicate predicate) {
        this(tableSpace, table, Projection.IDENTITY(table.columnNames, table.columns), predicate);
    }

    public ScanStatement(String tableSpace, Table table, Projection projection, Predicate predicate) {
        this(tableSpace, table.name, projection, predicate, null, null);
        this.tableDef = table;
    }

    public ScanStatement(String tableSpace, String table, Projection projection, Predicate predicate, TupleComparator comparator, ScanLimits limits) {
        super(table, tableSpace);
        this.predicate = predicate;
        this.projection = projection;
        this.comparator = comparator;
        this.limits = limits;
    }

    public Table getTableDef() {
        return this.tableDef;
    }

    public ScanLimits getLimits() {
        return this.limits;
    }

    public TupleComparator getComparator() {
        return this.comparator;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setComparator(TupleComparator comparator) {
        this.comparator = comparator;
    }

    public void setLimits(ScanLimits limits) {
        this.limits = limits;
    }

    public String toString() {
        return "ScanStatement{table=" + this.table + ",predicate=" + this.predicate + ",comparator=" + this.comparator + ",limits=" + this.limits + '}';
    }

    @Override
    public void validateContext(StatementEvaluationContext context) throws StatementExecutionException {
        if (this.predicate != null) {
            this.predicate.validateContext(context);
        }
    }

    public void setTableDef(Table table) {
        this.tableDef = table;
    }
}

