/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.codec.RecordSerializer;
import herddb.model.Column;
import herddb.utils.AbstractDataAccessor;
import herddb.utils.ByteArrayCursor;
import herddb.utils.DataAccessor;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.RawString;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public final class Tuple
extends AbstractDataAccessor {
    public final String[] fieldNames;
    private Map<String, Object> map;
    private Object[] values;

    private void buildValues() {
        if (this.values != null) {
            return;
        }
        int i = 0;
        Object[] newValues = new Object[this.fieldNames.length];
        for (String name : this.fieldNames) {
            newValues[i++] = this.map.get(name);
        }
        this.values = newValues;
    }

    public Tuple(String[] fieldNames, Object[] values) {
        if (fieldNames == null || values == null) {
            throw new NullPointerException();
        }
        this.fieldNames = fieldNames;
        this.values = values;
        if (fieldNames.length != values.length) {
            throw new IllegalArgumentException();
        }
    }

    public Tuple(Map<String, Object> record) {
        if (record == null) {
            throw new NullPointerException();
        }
        int size = record.size();
        this.fieldNames = new String[size];
        this.values = new Object[size];
        this.map = record;
        int i = 0;
        for (Map.Entry<String, Object> entry : record.entrySet()) {
            this.fieldNames[i] = entry.getKey();
            this.values[i++] = entry.getValue();
        }
    }

    public Tuple(Map<String, Object> record, String[] fieldNames) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.fieldNames = fieldNames;
        this.map = record;
    }

    public void forEach(BiConsumer<String, Object> consumer) {
        if (this.map != null) {
            this.map.forEach(consumer);
        } else {
            for (int i = 0; i < this.fieldNames.length; ++i) {
                consumer.accept(this.fieldNames[i], this.values[i]);
            }
        }
    }

    public int size() {
        return this.values.length;
    }

    public Object get(String column) {
        if (this.map != null) {
            return this.map.get(column);
        }
        return this.toMap().get(column);
    }

    public Object[] getValues() {
        if (this.values == null) {
            this.buildValues();
        }
        return this.values;
    }

    public Map<String, Object> toMap() {
        if (this.map != null) {
            return this.map;
        }
        HashMap<String, Object> _map = new HashMap<String, Object>();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            _map.put(this.fieldNames[i], this.values[i]);
        }
        this.map = _map;
        return _map;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public String toString() {
        return "Tuple{values=" + Arrays.toString(this.values) + ", fieldNames=" + Arrays.toString(this.fieldNames) + '}';
    }

    public Object get(int i) {
        this.buildValues();
        return this.values[i];
    }

    public static VisibleByteArrayOutputStream serialize(DataAccessor tuple, Column[] columns) throws IOException {
        VisibleByteArrayOutputStream oo = new VisibleByteArrayOutputStream(1024);
        try (ExtendedDataOutputStream eoo = new ExtendedDataOutputStream((OutputStream)oo);){
            Object[] fieldNames;
            int i = 0;
            for (String string : fieldNames = tuple.getFieldNames()) {
                if (!columns[i].name.toLowerCase().equals(string)) {
                    throw new IOException("invalid schema for tuple " + Arrays.toString(fieldNames) + " <> " + Arrays.toString(columns));
                }
                Object value = tuple.get(string);
                if (value == null) {
                    eoo.writeVInt(5);
                } else {
                    int columnType;
                    if (value instanceof String) {
                        columnType = 0;
                    } else if (value instanceof RawString) {
                        columnType = 0;
                    } else if (value instanceof Integer) {
                        columnType = 2;
                    } else if (value instanceof Long) {
                        columnType = 1;
                    } else if (value instanceof Timestamp) {
                        columnType = 4;
                    } else if (value instanceof Double) {
                        columnType = 6;
                    } else if (value instanceof Boolean) {
                        columnType = 7;
                    } else if (value instanceof byte[]) {
                        columnType = 3;
                    } else {
                        throw new IOException("unsupported class " + value.getClass());
                    }
                    RecordSerializer.serializeTypeAndValue(value, columnType, eoo);
                }
                ++i;
            }
        }
        return oo;
    }

    public static Tuple deserialize(byte[] data, String[] fieldNames, int nColumns) throws IOException {
        try (ByteArrayCursor eoo = ByteArrayCursor.wrap((byte[])data);){
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < nColumns; ++i) {
                Object value = RecordSerializer.deserializeTypeAndValue(eoo);
                values.add(value);
            }
            Object[] _values = values.toArray(new Object[nColumns]);
            Tuple tuple = new Tuple(fieldNames, _values);
            return tuple;
        }
    }
}

