/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.planner.PlannerOp;
import java.util.concurrent.atomic.AtomicLong;

public class ExecutionPlan {
    private static final AtomicLong ID = new AtomicLong();
    private final long id = ID.incrementAndGet();
    public final Statement mainStatement;
    public final PlannerOp originalRoot;

    private ExecutionPlan(Statement mainStatement, PlannerOp originalRoot) {
        this.mainStatement = mainStatement;
        this.originalRoot = originalRoot;
    }

    public static ExecutionPlan simple(Statement statement) {
        return new ExecutionPlan(statement, null);
    }

    public static ExecutionPlan simple(Statement statement, PlannerOp root) {
        return new ExecutionPlan(statement, root);
    }

    public void validateContext(StatementEvaluationContext context) throws StatementExecutionException {
        if (this.mainStatement != null) {
            this.mainStatement.validateContext(context);
        }
    }

    public String toString() {
        return "Plan" + this.id;
    }
}

