/*
 * Decompiled with CFR 0.152.
 */
package herddb.index.brin;

import java.util.Collections;
import java.util.List;

public class BlockRangeIndexMetadata<K extends Comparable<K>> {
    private static final BlockRangeIndexMetadata EMPTY_METADATA = new BlockRangeIndexMetadata(Collections.emptyList());
    private List<BlockMetadata<K>> blocksMetadata;

    public static final <X extends Comparable<X>> BlockRangeIndexMetadata<X> empty() {
        return EMPTY_METADATA;
    }

    public List<BlockMetadata<K>> getBlocksMetadata() {
        return this.blocksMetadata;
    }

    public BlockRangeIndexMetadata(List<BlockMetadata<K>> blocksMetadata) {
        this.blocksMetadata = blocksMetadata;
    }

    public String toString() {
        return "BlockRangeIndexMetadata [blocksMetadata=" + this.blocksMetadata + "]";
    }

    public static class BlockMetadata<K extends Comparable<K>> {
        public static final byte HEAD = 1;
        public static final byte TAIL = 2;
        final boolean headBlock;
        final K firstKey;
        final long blockId;
        final long size;
        final long pageId;
        final Long nextBlockId;

        BlockMetadata(K firstKey, long blockId, long size, long pageId, Long nextBlockId) {
            this.firstKey = firstKey;
            this.blockId = blockId;
            this.size = size;
            this.pageId = pageId;
            this.nextBlockId = nextBlockId;
            if (nextBlockId != null && nextBlockId == blockId) {
                throw new IllegalStateException("I cannot be the successor of myself! BlockId " + blockId);
            }
            this.headBlock = firstKey == null;
        }

        public long getSize() {
            return this.size;
        }

        public long getPageId() {
            return this.pageId;
        }

        public K getFirstKey() {
            return this.firstKey;
        }

        public boolean isHeadBlock() {
            return this.headBlock;
        }

        public long getBlockId() {
            return this.blockId;
        }

        public Long getNextBlockId() {
            return this.nextBlockId;
        }

        public String toString() {
            return "BlockMetadata [headBlock=" + this.headBlock + ", firstKey=" + this.firstKey + ", blockId=" + this.blockId + ", size=" + this.size + ", pageId=" + this.pageId + ", nextBlockId=" + this.nextBlockId + "]";
        }
    }
}

