/*
 * Decompiled with CFR 0.152.
 */
package herddb.index;

import herddb.codec.RecordSerializer;
import herddb.core.AbstractIndexManager;
import herddb.core.AbstractTableManager;
import herddb.core.PostCheckpointAction;
import herddb.core.TableSpaceManager;
import herddb.index.IndexOperation;
import herddb.index.SecondaryIndexPrefixScan;
import herddb.index.SecondaryIndexRangeScan;
import herddb.index.SecondaryIndexSeek;
import herddb.log.CommitLog;
import herddb.log.LogSequenceNumber;
import herddb.model.ColumnsList;
import herddb.model.Index;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableContext;
import herddb.sql.SQLRecordKeyFunction;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.storage.IndexStatus;
import herddb.utils.Bytes;
import herddb.utils.DataAccessor;
import herddb.utils.Holder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class MemoryHashIndexManager
extends AbstractIndexManager {
    private static final Logger LOGGER = Logger.getLogger(MemoryHashIndexManager.class.getName());
    private final ConcurrentHashMap<Bytes, List<Bytes>> data = new ConcurrentHashMap();
    private final AtomicLong newPageId = new AtomicLong(1L);
    LogSequenceNumber bootSequenceNumber;

    public MemoryHashIndexManager(Index index, AbstractTableManager tableManager, CommitLog log, DataStorageManager dataStorageManager, TableSpaceManager tableSpaceManager, String tableSpaceUUID, long transaction) {
        super(index, tableManager, dataStorageManager, tableSpaceManager.getTableSpaceUUID(), log, transaction);
    }

    @Override
    protected boolean doStart(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        IndexStatus status;
        LOGGER.log(Level.INFO, "loading in memory all the keys for mem index {0}", new Object[]{this.index.name});
        this.bootSequenceNumber = sequenceNumber;
        this.dataStorageManager.initIndex(this.tableSpaceUUID, this.index.uuid);
        if (LogSequenceNumber.START_OF_TIME.equals(sequenceNumber)) {
            LOGGER.log(Level.INFO, "loaded empty index {0}", new Object[]{this.index.name});
            return true;
        }
        try {
            status = this.dataStorageManager.getIndexStatus(this.tableSpaceUUID, this.index.uuid, sequenceNumber);
        }
        catch (DataStorageManagerException e) {
            LOGGER.log(Level.SEVERE, "cannot load index {0} due to {1}, it will be rebuilt", new Object[]{this.index.name, e});
            return false;
        }
        for (long pageId : status.activePages) {
            LOGGER.log(Level.INFO, "recovery index {0}, load {1}", new Object[]{this.index.name, pageId});
            Map read = this.dataStorageManager.readIndexPage(this.tableSpaceUUID, this.index.uuid, pageId, in -> {
                HashMap deserialized = new HashMap();
                long version = in.readVLong();
                long flags = in.readVLong();
                if (version != 1L || flags != 0L) {
                    throw new DataStorageManagerException("corrupted index page");
                }
                int size = in.readVInt();
                for (int i = 0; i < size; ++i) {
                    Bytes indexKey = in.readBytesNoCopy();
                    int entrySize = in.readVInt();
                    ArrayList<Bytes> value = new ArrayList<Bytes>(entrySize);
                    for (int kk = 0; kk < entrySize; ++kk) {
                        Bytes tableKey = in.readBytesNoCopy();
                        value.add(tableKey);
                    }
                    deserialized.put(indexKey, value);
                }
                return deserialized;
            });
            this.data.putAll(read);
        }
        this.newPageId.set(status.newPageId);
        LOGGER.log(Level.INFO, "loaded {0} keys for index {1}", new Object[]{this.data.size(), this.index.name});
        return true;
    }

    @Override
    public void rebuild() throws DataStorageManagerException {
        long _start = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "rebuilding index {0}", this.index.name);
        this.dataStorageManager.initIndex(this.tableSpaceUUID, this.index.uuid);
        this.data.clear();
        Table table = this.tableManager.getTable();
        this.tableManager.scanForIndexRebuild(r -> {
            DataAccessor values = r.getDataAccessor(table);
            Bytes key = RecordSerializer.serializePrimaryKey(values, (ColumnsList)table, table.primaryKey);
            Bytes indexKey = RecordSerializer.serializePrimaryKey(values, (ColumnsList)this.index, this.index.columnNames);
            this.recordInserted(key, indexKey);
        });
        long _stop = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "rebuilding index {0} took {1]", new Object[]{this.index.name, _stop - _start + " ms"});
    }

    @Override
    public Stream<Bytes> scanner(IndexOperation operation, StatementEvaluationContext context, TableContext tableContext) throws StatementExecutionException {
        if (operation instanceof SecondaryIndexSeek) {
            SecondaryIndexSeek sis = (SecondaryIndexSeek)operation;
            SQLRecordKeyFunction value = sis.value;
            byte[] refvalue = value.computeNewValue(null, context, tableContext);
            List<Bytes> result = this.data.get(Bytes.from_array((byte[])refvalue));
            if (result != null) {
                return result.stream();
            }
            return Stream.empty();
        }
        if (operation instanceof SecondaryIndexPrefixScan) {
            SecondaryIndexPrefixScan sis = (SecondaryIndexPrefixScan)operation;
            SQLRecordKeyFunction value = sis.value;
            byte[] refvalue = value.computeNewValue(null, context, tableContext);
            Predicate<Map.Entry> predicate = entry -> {
                Bytes recordValue = (Bytes)entry.getKey();
                return recordValue.startsWith(refvalue.length, refvalue);
            };
            return this.data.entrySet().stream().filter(predicate).map(entry -> (List)entry.getValue()).flatMap(l -> l.stream());
        }
        if (operation instanceof SecondaryIndexRangeScan) {
            SecondaryIndexRangeScan sis = (SecondaryIndexRangeScan)operation;
            SQLRecordKeyFunction minKey = sis.minValue;
            Bytes refminvalue = minKey != null ? Bytes.from_nullable_array((byte[])minKey.computeNewValue(null, context, tableContext)) : null;
            SQLRecordKeyFunction maxKey = sis.maxValue;
            Bytes refmaxvalue = maxKey != null ? Bytes.from_nullable_array((byte[])maxKey.computeNewValue(null, context, tableContext)) : null;
            Predicate<Map.Entry> predicate = refminvalue != null && refmaxvalue == null ? entry -> {
                Bytes datum = (Bytes)entry.getKey();
                return datum.compareTo(refminvalue) >= 0;
            } : (refminvalue == null && refmaxvalue != null ? entry -> {
                Bytes datum = (Bytes)entry.getKey();
                return datum.compareTo(refmaxvalue) <= 0;
            } : (refminvalue != null && refmaxvalue != null ? entry -> {
                Bytes datum = (Bytes)entry.getKey();
                return datum.compareTo(refmaxvalue) <= 0 && datum.compareTo(refminvalue) >= 0;
            } : entry -> true));
            return this.data.entrySet().stream().filter(predicate).map(entry -> (List)entry.getValue()).flatMap(l -> l.stream());
        }
        throw new UnsupportedOperationException("unsuppported index access type " + operation);
    }

    @Override
    public List<PostCheckpointAction> checkpoint(LogSequenceNumber sequenceNumber, boolean pin) throws DataStorageManagerException {
        if (this.createdInTransaction > 0L) {
            LOGGER.log(Level.INFO, "checkpoint for index " + this.index.name + " skipped, this index is created on transaction " + this.createdInTransaction + " which is not committed");
            return Collections.emptyList();
        }
        ArrayList<PostCheckpointAction> result = new ArrayList<PostCheckpointAction>();
        LOGGER.log(Level.INFO, "flush index {0}", new Object[]{this.index.name});
        long pageId = this.newPageId.getAndIncrement();
        Holder count = new Holder();
        this.dataStorageManager.writeIndexPage(this.tableSpaceUUID, this.index.uuid, pageId, out -> {
            long entries = 0L;
            out.writeVLong(1L);
            out.writeVLong(0L);
            out.writeVInt(this.data.size());
            for (Map.Entry<Bytes, List<Bytes>> entry : this.data.entrySet()) {
                out.writeArray(entry.getKey());
                List<Bytes> entrydata = entry.getValue();
                out.writeVInt(entrydata.size());
                for (Bytes v : entrydata) {
                    out.writeArray(v);
                    ++entries;
                }
            }
            count.value = entries;
        });
        IndexStatus indexStatus = new IndexStatus(this.index.name, sequenceNumber, this.newPageId.get(), Collections.singleton(pageId), null);
        result.addAll(this.dataStorageManager.indexCheckpoint(this.tableSpaceUUID, this.index.uuid, indexStatus, pin));
        LOGGER.log(Level.INFO, "checkpoint index {0} finished: logpos {1}, {2} entries, page {3}", new Object[]{this.index.name, sequenceNumber, Long.toString((Long)count.value), Long.toString(pageId)});
        return result;
    }

    @Override
    public void unpinCheckpoint(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        this.dataStorageManager.unPinIndexCheckpoint(this.tableSpaceUUID, this.index.uuid, sequenceNumber);
    }

    @Override
    public void recordDeleted(Bytes key, Bytes indexKey) {
        this.removeValueFromIndex(indexKey, key);
    }

    private void removeValueFromIndex(Bytes indexKey, Bytes key) {
        this.data.merge(indexKey, Collections.singletonList(key), (actual, newList) -> {
            if (actual.size() == 1) {
                return null;
            }
            actual.removeAll((Collection<?>)newList);
            return actual;
        });
    }

    @Override
    public void recordInserted(Bytes key, Bytes indexKey) {
        this.addValueToIndex(indexKey, key);
    }

    private void addValueToIndex(Bytes indexKey, Bytes key) {
        this.data.merge(indexKey, Collections.singletonList(key), (actual, newList) -> {
            ArrayList result = new ArrayList(actual.size() + 1);
            result.addAll(actual);
            result.addAll(newList);
            return result;
        });
    }

    @Override
    public void recordUpdated(Bytes key, Bytes indexKeyRemoved, Bytes indexKeyAdded) {
        if (Objects.equals(indexKeyRemoved, indexKeyAdded)) {
            return;
        }
        if (indexKeyAdded != null) {
            this.addValueToIndex(indexKeyAdded, key);
        }
        if (indexKeyRemoved != null) {
            this.removeValueFromIndex(indexKeyRemoved, key);
        }
    }

    @Override
    public void close() {
        this.data.clear();
    }

    @Override
    public void truncate() throws DataStorageManagerException {
        this.data.clear();
    }
}

