/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SystransactionsTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("systransactions").column("tablespace", 0).column("txid", 1).column("creationTimestamp", 4).primaryKey("txid", false).build();

    public SystransactionsTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList() {
        List<Transaction> transactions = this.tableSpaceManager.getTransactions();
        ArrayList<Record> result = new ArrayList<Record>();
        for (Transaction tx : transactions) {
            result.add(RecordSerializer.makeRecord(this.table, "tablespace", this.tableSpaceManager.getTableSpaceName(), "txid", tx.transactionId, "creationtimestamp", new Timestamp(tx.localCreationTimestamp)));
        }
        return result;
    }
}

