/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.Record;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class SystablespacesTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("systablespaces").column("tablespace_name", 0).column("uuid", 0).column("leader", 0).column("replica", 0).column("expectedreplicacount", 2).column("maxleaderinactivitytime", 1).primaryKey("tablespace_name", false).build();

    public SystablespacesTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList() throws StatementExecutionException {
        try {
            Collection<String> names = this.tableSpaceManager.getMetadataStorageManager().listTableSpaces();
            ArrayList<Record> result = new ArrayList<Record>();
            for (String name : names) {
                TableSpace t = this.tableSpaceManager.getMetadataStorageManager().describeTableSpace(name);
                if (t == null) continue;
                result.add(RecordSerializer.makeRecord(this.table, "tablespace_name", t.name, "uuid", t.uuid, "leader", t.leaderId, "expectedreplicacount", t.expectedReplicaCount, "maxleaderinactivitytime", t.maxLeaderInactivityTime, "replica", t.replicas.stream().collect(Collectors.joining(","))));
            }
            return result;
        }
        catch (MetadataStorageManagerException error) {
            throw new StatementExecutionException(error);
        }
    }
}

