/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.log.LogSequenceNumber;
import herddb.model.Record;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import java.util.ArrayList;

public class SyslogstatusManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("syslogstatus").column("tablespace_uuid", 0).column("nodeid", 0).column("tablespace_name", 0).column("ledger", 1).column("offset", 1).column("status", 0).primaryKey("tablespace_uuid", false).primaryKey("nodeid", false).build();

    public SyslogstatusManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList() throws StatementExecutionException {
        boolean isVirtual = this.tableSpaceManager.isVirtual();
        boolean isLeader = this.tableSpaceManager.isLeader();
        LogSequenceNumber logSequenceNumber = isVirtual ? null : this.tableSpaceManager.getLog().getLastSequenceNumber();
        ArrayList<Record> result = new ArrayList<Record>();
        result.add(RecordSerializer.makeRecord(this.table, "tablespace_uuid", this.tableSpaceManager.getTableSpaceUUID(), "nodeid", this.tableSpaceManager.getDbmanager().getNodeId(), "tablespace_name", this.tableSpaceManager.getTableSpaceName(), "ledger", isVirtual ? 0L : logSequenceNumber.ledgerId, "offset", isVirtual ? 0L : logSequenceNumber.offset, "status", isVirtual ? "virtual" : (isLeader ? "leader" : "follower")));
        return result;
    }
}

