/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.model.Column;
import herddb.model.ColumnTypes;
import herddb.model.Record;
import herddb.model.Table;
import java.util.ArrayList;
import java.util.List;

public class SyscolumnsTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("syscolumns").column("table_name", 0).column("column_name", 0).column("ordinal_position", 2).column("is_nullable", 2).column("data_type", 0).column("type_name", 0).column("auto_increment", 2).primaryKey("column_name", false).primaryKey("table_name", false).build();

    public SyscolumnsTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList() {
        List<Table> tables = this.tableSpaceManager.getAllCommittedTables();
        ArrayList<Record> result = new ArrayList<Record>();
        for (Table t : tables) {
            int pos = 1;
            for (Column c : t.columns) {
                boolean pk = t.isPrimaryKeyColumn(c.name);
                boolean nonNullCType = pk || ColumnTypes.isNotNullDataType(c.type);
                result.add(RecordSerializer.makeRecord(this.table, "table_name", t.name, "column_name", c.name, "ordinal_position", pos++, "is_nullable", nonNullCType ? 0 : 1, "data_type", ColumnTypes.sqlDataType(c.type), "type_name", ColumnTypes.typeToString(c.type), "auto_increment", pk && t.auto_increment ? 1 : 0));
            }
        }
        return result;
    }
}

