/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.core.AbstractTableManager;
import herddb.core.MaterializedRecordSet;
import herddb.core.SimpleDataScanner;
import herddb.core.TableSpaceManager;
import herddb.core.stats.TableManagerStats;
import herddb.index.KeyToPageIndex;
import herddb.log.CommitLogResult;
import herddb.log.LogEntry;
import herddb.log.LogSequenceNumber;
import herddb.model.DDLException;
import herddb.model.DataScanner;
import herddb.model.Index;
import herddb.model.InvalidTableException;
import herddb.model.Predicate;
import herddb.model.Record;
import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.Transaction;
import herddb.model.commands.ScanStatement;
import herddb.storage.DataStorageManagerException;
import herddb.storage.FullTableScanConsumer;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.bookkeeper.common.concurrent.FutureUtils;

public abstract class AbstractSystemTableManager
implements AbstractTableManager {
    protected TableSpaceManager tableSpaceManager;
    protected final Table table;
    private final Comparator<Record> sortByPk = new Comparator<Record>(){

        @Override
        public int compare(Record o1, Record o2) {
            Map<String, Object> ac1 = o1.toBean(AbstractSystemTableManager.this.table);
            Map<String, Object> ac2 = o2.toBean(AbstractSystemTableManager.this.table);
            for (String pk : AbstractSystemTableManager.this.table.primaryKey) {
                Object value2;
                Object value1 = ac1.get(pk);
                int cmp = SQLRecordPredicateFunctions.compare((Object)value1, (Object)(value2 = ac2.get(pk)));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    };

    public AbstractSystemTableManager(TableSpaceManager tableSpaceManager, Table table) {
        this.tableSpaceManager = tableSpaceManager;
        this.table = table;
    }

    @Override
    public CompletableFuture<StatementExecutionResult> executeStatementAsync(Statement statement, Transaction transaction, StatementEvaluationContext context) throws StatementExecutionException {
        return FutureUtils.exception((Throwable)((Object)new StatementExecutionException("not supported on system tables")));
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public TableManagerStats getStats() {
        return new TableManagerStats(){

            @Override
            public int getLoadedpages() {
                return 0;
            }

            @Override
            public long getLoadedPagesCount() {
                return 0L;
            }

            @Override
            public long getUnloadedPagesCount() {
                return 0L;
            }

            @Override
            public long getTablesize() {
                return 0L;
            }

            @Override
            public int getDirtypages() {
                return 0;
            }

            @Override
            public int getDirtyrecords() {
                return 0;
            }

            @Override
            public long getDirtyUsedMemory() {
                return 0L;
            }

            @Override
            public long getMaxLogicalPageSize() {
                return 0L;
            }

            @Override
            public long getBuffersUsedMemory() {
                return 0L;
            }

            @Override
            public long getKeysUsedMemory() {
                return 0L;
            }
        };
    }

    @Override
    public void start() throws DataStorageManagerException {
    }

    @Override
    public void close() {
    }

    @Override
    public LogSequenceNumber getBootSequenceNumber() {
        return LogSequenceNumber.START_OF_TIME;
    }

    @Override
    public void dropTableData() throws DataStorageManagerException {
        throw new DataStorageManagerException("no supported on system tables");
    }

    @Override
    public void validateAlterTable(Table table, StatementEvaluationContext context) throws StatementExecutionException {
        throw new StatementExecutionException("Cannot alter system table " + table.name);
    }

    @Override
    public void onTransactionRollback(Transaction transaction) throws DataStorageManagerException {
    }

    @Override
    public void onTransactionCommit(Transaction transaction, boolean recovery) throws DataStorageManagerException {
    }

    @Override
    public void apply(CommitLogResult pos, LogEntry entry, boolean recovery) throws DataStorageManagerException {
    }

    @Override
    public void dump(LogSequenceNumber sequenceNumber, FullTableScanConsumer receiver) throws DataStorageManagerException {
        throw new DataStorageManagerException("you cannot dump a system table!");
    }

    @Override
    public AbstractTableManager.TableCheckpoint checkpoint(boolean pin) throws DataStorageManagerException {
        throw new DataStorageManagerException("you cannot checkpoint a system table!");
    }

    @Override
    public AbstractTableManager.TableCheckpoint fullCheckpoint(boolean pin) throws DataStorageManagerException {
        throw new DataStorageManagerException("you cannot checkpoint a system table!");
    }

    @Override
    public void unpinCheckpoint(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        throw new DataStorageManagerException("you cannot checkpoint a system table!");
    }

    @Override
    public void flush() throws DataStorageManagerException {
    }

    @Override
    public void scanForIndexRebuild(Consumer<Record> records) throws DataStorageManagerException {
    }

    @Override
    public long getNextPrimaryKeyValue() {
        return -1L;
    }

    @Override
    public boolean isSystemTable() {
        return true;
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public void tableAltered(Table table, Transaction transaction) throws DDLException {
        throw new InvalidTableException("cannot alter system tables");
    }

    protected abstract Iterable<Record> buildVirtualRecordList() throws StatementExecutionException;

    @Override
    public DataScanner scan(ScanStatement statement, StatementEvaluationContext context, Transaction transaction, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        Predicate predicate = statement.getPredicate();
        MaterializedRecordSet recordSet = this.tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(this.table.columnNames, this.table.columns);
        Iterable<Record> data = this.buildVirtualRecordList();
        StreamSupport.stream(data.spliterator(), false).filter(record -> predicate == null || predicate.evaluate((Record)record, context)).sorted(this.sortByPk).map(r -> r.getDataAccessor(this.table)).forEach(recordSet::add);
        recordSet.writeFinished();
        recordSet.sort(statement.getComparator());
        recordSet.applyLimits(statement.getLimits(), context);
        recordSet.applyProjection(statement.getProjection(), context);
        return new SimpleDataScanner(transaction, recordSet);
    }

    @Override
    public long getCreatedInTransaction() {
        return 0L;
    }

    @Override
    public List<Index> getAvailableIndexes() {
        return Collections.emptyList();
    }

    @Override
    public KeyToPageIndex getKeyToPageIndex() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [table=").append(this.table).append("]");
        return builder.toString();
    }
}

