/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.MaterializedRecordSet;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.Transaction;
import herddb.utils.DataAccessor;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

public class SimpleDataScanner
extends DataScanner {
    private final MaterializedRecordSet recordSet;
    private Iterator<DataAccessor> iterator;
    private DataAccessor next;
    private boolean finished;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public SimpleDataScanner(Transaction transaction, MaterializedRecordSet recordSet) {
        super(transaction, recordSet.fieldNames, recordSet.columns);
        this.recordSet = recordSet;
        this.iterator = this.recordSet.iterator();
        if (transaction != null) {
            transaction.increaseRefcount();
        }
    }

    @Override
    public void close() throws DataScannerException {
        if (this.closed.compareAndSet(false, true)) {
            if (this.transaction != null) {
                this.transaction.decreaseRefCount();
            }
            this.finished = true;
            try {
                this.recordSet.close();
            }
            finally {
                super.close();
            }
        }
    }

    @Override
    public boolean hasNext() throws DataScannerException {
        if (this.finished) {
            return false;
        }
        return this.ensureNext();
    }

    private boolean ensureNext() throws DataScannerException {
        if (this.next != null) {
            return true;
        }
        if (!this.iterator.hasNext()) {
            this.finished = true;
            return false;
        }
        this.next = this.iterator.next();
        return true;
    }

    @Override
    public DataAccessor next() throws DataScannerException {
        if (this.finished) {
            throw new DataScannerException("Scanner is exhausted");
        }
        DataAccessor _next = this.next;
        this.next = null;
        return _next;
    }

    @Override
    public void rewind() throws DataScannerException {
        this.finished = false;
        this.iterator = this.recordSet.iterator();
        this.next = null;
    }

    @Override
    public boolean isRewindSupported() {
        return true;
    }
}

