/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.AbstractTableManager;
import herddb.core.PostCheckpointAction;
import herddb.index.IndexOperation;
import herddb.index.KeyToPageIndex;
import herddb.log.CommitLog;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.TableContext;
import herddb.model.Transaction;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.utils.Bytes;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public abstract class AbstractIndexManager
implements AutoCloseable {
    protected final Index index;
    protected final AbstractTableManager tableManager;
    protected final DataStorageManager dataStorageManager;
    protected final String tableSpaceUUID;
    protected final CommitLog log;
    protected long createdInTransaction;

    public AbstractIndexManager(Index index, AbstractTableManager tableManager, DataStorageManager dataStorageManager, String tableSpaceUUID, CommitLog log, long createdInTransaction) {
        this.index = index;
        this.createdInTransaction = createdInTransaction;
        this.tableManager = tableManager;
        this.dataStorageManager = dataStorageManager;
        this.tableSpaceUUID = tableSpaceUUID;
        this.log = log;
    }

    public final Index getIndex() {
        return this.index;
    }

    public final String getIndexName() {
        return this.index.name;
    }

    public final String[] getColumnNames() {
        return this.index.columnNames;
    }

    public void start(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        boolean needRebuild;
        boolean bl = needRebuild = !this.doStart(sequenceNumber);
        if (needRebuild) {
            this.dropIndexData();
            this.rebuild();
        }
    }

    protected abstract boolean doStart(LogSequenceNumber var1) throws DataStorageManagerException;

    @Override
    public void close() {
    }

    public abstract void rebuild() throws DataStorageManagerException;

    public abstract List<PostCheckpointAction> checkpoint(LogSequenceNumber var1, boolean var2) throws DataStorageManagerException;

    public abstract void unpinCheckpoint(LogSequenceNumber var1) throws DataStorageManagerException;

    protected abstract Stream<Bytes> scanner(IndexOperation var1, StatementEvaluationContext var2, TableContext var3) throws StatementExecutionException;

    public Stream<Map.Entry<Bytes, Long>> recordSetScanner(IndexOperation operation, StatementEvaluationContext context, TableContext tableContext, KeyToPageIndex keyToPageIndex) throws DataStorageManagerException, StatementExecutionException {
        return this.scanner(operation, context, tableContext).map(b -> {
            Long idPage = keyToPageIndex.get((Bytes)b);
            if (idPage == null) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry<Bytes, Long>((Bytes)b, idPage);
        }).filter(p -> p != null);
    }

    public abstract void recordUpdated(Bytes var1, Bytes var2, Bytes var3) throws DataStorageManagerException;

    public abstract void recordInserted(Bytes var1, Bytes var2) throws DataStorageManagerException;

    public abstract void recordDeleted(Bytes var1, Bytes var2) throws DataStorageManagerException;

    public void dropIndexData() throws DataStorageManagerException {
        this.dataStorageManager.dropIndex(this.tableSpaceUUID, this.index.uuid);
    }

    public void truncateIndexData() throws DataStorageManagerException {
        this.dataStorageManager.truncateIndex(this.tableSpaceUUID, this.index.uuid);
    }

    final void onTransactionCommit(Transaction transaction, boolean recovery) throws DataStorageManagerException {
        if (this.createdInTransaction > 0L) {
            if (transaction.transactionId != this.createdInTransaction) {
                throw new DataStorageManagerException("this indexManager is available only on transaction " + this.createdInTransaction);
            }
            this.createdInTransaction = 0L;
        }
    }

    public final boolean isAvailable() {
        return this.createdInTransaction == 0L;
    }

    public abstract void truncate() throws DataStorageManagerException;
}

