/*
 * Decompiled with CFR 0.152.
 */
package herddb.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import herddb.utils.SimpleByteArrayInputStream;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LedgersInfo {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private List<Long> activeLedgers = new ArrayList<Long>();
    private List<Long> ledgersTimestamps = new ArrayList<Long>();
    private long firstLedger = -1L;
    private int zkVersion = -1;
    private static final Logger LOG = Logger.getLogger(LedgersInfo.class.getName());

    public synchronized String toString() {
        return "LedgersInfo{activeLedgers=" + this.activeLedgers + ", firstLedger=" + this.firstLedger + ", zkVersion=" + this.zkVersion + '}';
    }

    public synchronized List<Long> getLedgersTimestamps() {
        return this.ledgersTimestamps;
    }

    public synchronized void setLedgersTimestamps(List<Long> ledgersTimestamps) {
        this.ledgersTimestamps = ledgersTimestamps;
    }

    public synchronized int getZkVersion() {
        return this.zkVersion;
    }

    public synchronized void setZkVersion(int zkVersion) {
        this.zkVersion = zkVersion;
    }

    public synchronized byte[] serialize() {
        try {
            VisibleByteArrayOutputStream oo = new VisibleByteArrayOutputStream();
            MAPPER.writeValue((OutputStream)oo, (Object)this);
            return oo.toByteArray();
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public static LedgersInfo deserialize(byte[] data, int zkVersion) {
        if (data == null || data.length == 0) {
            LedgersInfo info = new LedgersInfo();
            info.setZkVersion(zkVersion);
            return info;
        }
        try {
            LedgersInfo info = (LedgersInfo)MAPPER.readValue((InputStream)new SimpleByteArrayInputStream(data), LedgersInfo.class);
            info.setZkVersion(zkVersion);
            return info;
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public synchronized void addLedger(long id) {
        this.activeLedgers.add(id);
        this.ledgersTimestamps.add(System.currentTimeMillis());
        if (this.firstLedger < 0L) {
            this.firstLedger = id;
        }
    }

    public synchronized void removeLedger(long id) throws IllegalArgumentException {
        int index = -1;
        for (int i = 0; i < this.activeLedgers.size(); ++i) {
            if (this.activeLedgers.get(i) != id) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new IllegalArgumentException("ledger " + id + " not in list " + this.activeLedgers);
        }
        this.activeLedgers.remove(index);
        this.ledgersTimestamps.remove(index);
    }

    public synchronized List<Long> getOldLedgers(long timestamp) throws IllegalArgumentException {
        ArrayList<Long> res = new ArrayList<Long>();
        for (int i = 0; i < this.activeLedgers.size(); ++i) {
            long id = this.activeLedgers.get(i);
            long ledgerTimestamp = this.ledgersTimestamps.get(i);
            if (ledgerTimestamp < timestamp) {
                LOG.log(Level.INFO, "ledeger {0} is to be dropped, time is {1} < {2}", new Object[]{id, new Timestamp(ledgerTimestamp), new Timestamp(timestamp)});
                res.add(id);
                continue;
            }
            LOG.log(Level.INFO, "ledeger {0} is to keep, time is {1} >= {2}", new Object[]{id, new Timestamp(ledgerTimestamp), new Timestamp(timestamp)});
        }
        return res;
    }

    public synchronized List<Long> getActiveLedgers() {
        return new ArrayList<Long>(this.activeLedgers);
    }

    public synchronized void setActiveLedgers(List<Long> activeLedgers) {
        this.activeLedgers = activeLedgers;
    }

    public synchronized long getFirstLedger() {
        return this.firstLedger;
    }

    public synchronized void setFirstLedger(long firstLedger) {
        this.firstLedger = firstLedger;
    }
}

