/*
 * Decompiled with CFR 0.152.
 */
package herddb.client;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Map;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class ScanResultSetMetadata {
    private String[] columnNames;
    private Map<String, Integer> columnNameToPosition;

    public ScanResultSetMetadata(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int getColumnPosition(String columnName) {
        this.ensureColumnToPositionMap();
        Integer pos = this.columnNameToPosition.get(columnName);
        if (pos == null) {
            pos = this.columnNameToPosition.get(columnName.toLowerCase());
        }
        return pos == null ? 0 : pos;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    private void ensureColumnToPositionMap() throws IllegalStateException {
        if (this.columnNameToPosition == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int i = 1;
            for (String _columnName : this.columnNames) {
                if (_columnName == null) {
                    throw new IllegalStateException("Invalid columnName null, in " + Arrays.toString(this.columnNames));
                }
                builder.put((Object)_columnName, (Object)i++);
            }
            this.columnNameToPosition = builder.build();
        }
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }
}

