/*
 * Decompiled with CFR 0.152.
 */
package herddb.client;

import herddb.client.ClientConfiguration;
import herddb.client.ClientSideMetadataProvider;
import herddb.client.HDBConnection;
import herddb.client.ZookeeperClientSideMetadataProvider;
import herddb.network.Channel;
import herddb.network.ChannelEventListener;
import herddb.network.ServerHostData;
import herddb.network.netty.NettyConnector;
import herddb.network.netty.NetworkUtils;
import herddb.server.StaticClientSideMetadataProvider;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

public class HDBClient
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(HDBClient.class.getName());
    private final ClientConfiguration configuration;
    private final Map<Long, HDBConnection> connections = new ConcurrentHashMap<Long, HDBConnection>();
    private ClientSideMetadataProvider clientSideMetadataProvider;
    private final ExecutorService thredpool;
    private final MultithreadEventLoopGroup networkGroup;
    private final DefaultEventLoopGroup localEventsGroup;
    private final StatsLogger statsLogger;
    private final int maxOperationRetryCount;
    private final int operationRetryDelay;

    public HDBClient(ClientConfiguration configuration) {
        this(configuration, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public HDBClient(ClientConfiguration configuration, StatsLogger statsLogger) {
        String mode;
        this.configuration = configuration;
        this.statsLogger = statsLogger.scope("hdbclient");
        int corePoolSize = configuration.getInt("client.network.thread.callback", 64);
        this.maxOperationRetryCount = configuration.getInt("client.max.operation.retry.count", 100);
        this.operationRetryDelay = configuration.getInt("client.operation.retry.delay", 1000);
        this.thredpool = new ThreadPoolExecutor(corePoolSize, Integer.MAX_VALUE, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            FastThreadLocalThread t = new FastThreadLocalThread(r, "hdb-client");
            t.setDaemon(true);
            return t;
        });
        this.networkGroup = NetworkUtils.isEnableEpoolNative() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        this.localEventsGroup = new DefaultEventLoopGroup();
        switch (mode = configuration.getString("client.mode", "local")) {
            case "local": 
            case "standalone": {
                this.clientSideMetadataProvider = new StaticClientSideMetadataProvider(configuration.getString("client.server.address", "localhost"), configuration.getInt("client.server.port", 7000), configuration.getBoolean("client.server.ssl", false));
                break;
            }
            case "cluster": {
                this.clientSideMetadataProvider = new ZookeeperClientSideMetadataProvider(configuration.getString("client.zookeeper.address", "localhost:1281"), configuration.getInt("client.zookeeper.session.timeout", 40000), configuration.getString("client.zookeeper.path", "/herd"));
                break;
            }
            default: {
                throw new IllegalStateException(mode);
            }
        }
    }

    public ClientSideMetadataProvider getClientSideMetadataProvider() {
        return this.clientSideMetadataProvider;
    }

    public void setClientSideMetadataProvider(ClientSideMetadataProvider clientSideMetadataProvider) {
        this.clientSideMetadataProvider = clientSideMetadataProvider;
    }

    public int getMaxOperationRetryCount() {
        return this.maxOperationRetryCount;
    }

    public int getOperationRetryDelay() {
        return this.operationRetryDelay;
    }

    public ClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void close() {
        ArrayList<HDBConnection> connectionsAtClose = new ArrayList<HDBConnection>(this.connections.values());
        for (HDBConnection connection : connectionsAtClose) {
            connection.close();
        }
        if (this.networkGroup != null) {
            this.networkGroup.shutdownGracefully();
        }
        if (this.localEventsGroup != null) {
            this.localEventsGroup.shutdownGracefully();
        }
        if (this.thredpool != null) {
            this.thredpool.shutdown();
        }
    }

    public HDBConnection openConnection() {
        HDBConnection con = new HDBConnection(this);
        this.registerConnection(con);
        return con;
    }

    protected final void registerConnection(HDBConnection con) {
        this.connections.put(con.getId(), con);
    }

    void releaseConnection(HDBConnection connection) {
        this.connections.remove(connection.getId());
    }

    Channel createChannelTo(ServerHostData server, ChannelEventListener eventReceiver) throws IOException {
        int timeoutms = this.configuration.getInt("client.timeout", 300000);
        int timeouts = (int)TimeUnit.MILLISECONDS.toSeconds(timeoutms);
        return NettyConnector.connect((String)server.getHost(), (int)server.getPort(), (boolean)server.isSsl(), (int)timeoutms, (int)timeouts, (ChannelEventListener)eventReceiver, (ExecutorService)this.thredpool, (MultithreadEventLoopGroup)this.networkGroup, (DefaultEventLoopGroup)this.localEventsGroup);
    }

    StatsLogger getStatsLogger() {
        return this.statsLogger;
    }
}

