/*
 * Decompiled with CFR 0.152.
 */
package herddb.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientConfiguration {
    private static final Logger LOG = Logger.getLogger(ClientConfiguration.class.getName());
    private final Properties properties = new Properties();
    public static final String PROPERTY_CLIENT_USERNAME = "user";
    public static final String PROPERTY_CLIENT_USERNAME_DEFAULT = "sa";
    public static final String PROPERTY_CLIENT_PASSWORD = "password";
    public static final String PROPERTY_CLIENT_PASSWORD_DEFAULT = "hdb";
    public static final String PROPERTY_BASEDIR = "client.base.dir";
    public static final String PROPERTY_TIMEOUT = "client.timeout";
    public static final String PROPERTY_CLIENTID = "client.client.id";
    public static final int PROPERTY_TIMEOUT_DEFAULT = 300000;
    public static final String PROPERTY_CLIENTID_DEFAULT = "localhost";
    public static final String PROPERTY_MODE = "client.mode";
    public static final String PROPERTY_MODE_LOCAL = "local";
    public static final String PROPERTY_MODE_STANDALONE = "standalone";
    public static final String PROPERTY_MODE_CLUSTER = "cluster";
    public static final String PROPERTY_SERVER_ADDRESS = "client.server.address";
    public static final String PROPERTY_SERVER_PORT = "client.server.port";
    public static final String PROPERTY_SERVER_SSL = "client.server.ssl";
    public static final String PROPERTY_MAX_CONNECTIONS_PER_SERVER = "client.maxconnections.perserver";
    public static final int PROPERTY_MAX_CONNECTIONS_PER_SERVER_DEFAULT = 10;
    public static final String PROPERTY_MAX_OPERATION_RETRY_COUNT = "client.max.operation.retry.count";
    public static final int PROPERTY_MAX_OPERATION_RETRY_COUNT_DEFAULT = 100;
    public static final String PROPERTY_OPERATION_RETRY_DELAY = "client.operation.retry.delay";
    public static final int PROPERTY_OPERATION_RETRY_DELAY_DEFAULT = 1000;
    public static final String PROPERTY_ZOOKEEPER_ADDRESS = "client.zookeeper.address";
    public static final String PROPERTY_ZOOKEEPER_SESSIONTIMEOUT = "client.zookeeper.session.timeout";
    public static final String PROPERTY_ZOOKEEPER_PATH = "client.zookeeper.path";
    public static final String PROPERTY_ZOOKEEPER_ADDRESS_DEFAULT = "localhost:1281";
    public static final String PROPERTY_ZOOKEEPER_PATH_DEFAULT = "/herd";
    public static final int PROPERTY_SERVER_PORT_DEFAULT = 7000;
    public static final String PROPERTY_SERVER_ADDRESS_DEFAULT = "localhost";
    public static final boolean PROPERTY_SERVER_SSL_DEFAULT = false;
    public static final int PROPERTY_ZOOKEEPER_SESSIONTIMEOUT_DEFAULT = 40000;
    public static final int PROPERTY_CLIENT_CALLBACKS_DEFAULT = 64;
    public static final String PROPERTY_CLIENT_CALLBACKS = "client.network.thread.callback";

    public ClientConfiguration(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public ClientConfiguration(Path baseDir) {
        this();
        this.set(PROPERTY_BASEDIR, baseDir.toAbsolutePath());
    }

    public ClientConfiguration() {
        this.set(PROPERTY_BASEDIR, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath());
    }

    public int getInt(String key, int defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public String getString(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public final ClientConfiguration set(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value + "");
        }
        return this;
    }

    public void readJdbcUrl(String url) {
        String before;
        if (url == null || url.isEmpty()) {
            return;
        }
        int questionMark = url.indexOf(63);
        if (questionMark <= 0) {
            questionMark = url.length();
        }
        if (!(before = url.substring(0, questionMark)).startsWith("jdbc:herddb:")) {
            throw new IllegalArgumentException("invalid url " + url);
        }
        if (before.startsWith("jdbc:herddb:zookeeper:")) {
            this.set(PROPERTY_MODE, PROPERTY_MODE_CLUSTER);
            String zkaddress = before.substring("jdbc:herddb:zookeeper:".length());
            int slash = zkaddress.indexOf(47);
            if (slash <= 0) {
                this.set(PROPERTY_ZOOKEEPER_ADDRESS, zkaddress);
            } else {
                String path = zkaddress.substring(slash);
                zkaddress = zkaddress.substring(0, slash);
                this.set(PROPERTY_ZOOKEEPER_ADDRESS, zkaddress);
                this.set(PROPERTY_ZOOKEEPER_PATH, path);
            }
        } else if (before.startsWith("jdbc:herddb:server:")) {
            this.set(PROPERTY_MODE, PROPERTY_MODE_STANDALONE);
            before = before.substring("jdbc:herddb:server:".length());
            int port_pos = before.indexOf(58);
            String host = before;
            int port = 7000;
            if (port_pos > 0) {
                host = before.substring(0, port_pos);
                port = Integer.parseInt(before.substring(port_pos + 1));
            }
            this.set(PROPERTY_SERVER_ADDRESS, host);
            this.set(PROPERTY_SERVER_PORT, port);
        } else if (before.startsWith("jdbc:herddb:local:")) {
            this.set(PROPERTY_MODE, PROPERTY_MODE_LOCAL);
        }
        if (questionMark < url.length()) {
            String[] params;
            String qs = url.substring(questionMark + 1);
            for (String param : params = qs.split("&")) {
                int pos = param.indexOf(61);
                if (pos > 0) {
                    String key = param.substring(0, pos);
                    String value = param.substring(pos + 1);
                    this.set(key, value);
                    continue;
                }
                this.set(param, "");
            }
        }
        this.readAdditionalProperties();
    }

    private void readAdditionalProperties() {
        String configFile = this.getString("configFile", "");
        if (!configFile.isEmpty()) {
            File file = new File(configFile);
            LOG.log(Level.INFO, "Reading additional configuration file configFile={0}", file.getAbsolutePath());
            Properties additionalProperties = new Properties();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                additionalProperties.load(reader);
            }
            catch (IOException err) {
                throw new RuntimeException(err);
            }
            additionalProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.set(k.toString(), v)));
        }
    }

    public String toString() {
        Properties propsNoPassword = new Properties();
        propsNoPassword.putAll((Map<?, ?>)this.properties);
        propsNoPassword.setProperty(PROPERTY_CLIENT_PASSWORD, "---");
        return "ClientConfiguration{" + propsNoPassword + '}';
    }
}

