/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import herddb.client.HDBException;
import herddb.client.ScanResultSet;
import herddb.client.ScanResultSetMetadata;
import herddb.jdbc.HerdDBStatement;
import herddb.jdbc.utils.SQLExceptionUtils;
import herddb.utils.DataAccessor;
import herddb.utils.RawString;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class HerdDBResultSet
implements ResultSet {
    private static final AtomicLong IDGENERATOR = new AtomicLong();
    private final Long id = IDGENERATOR.incrementAndGet();
    private final ScanResultSet scanResult;
    private DataAccessor actualValue;
    private Object lastValue;
    private final HerdDBStatement parent;
    private final ScanResultSetMetadata metadata;
    private boolean closed;
    private boolean wasNull;

    HerdDBResultSet(ScanResultSet scanResult) {
        this(scanResult, null);
    }

    HerdDBResultSet(ScanResultSet scanResult, HerdDBStatement parent) {
        this.scanResult = scanResult;
        this.metadata = scanResult.getMetadata();
        this.parent = parent;
        if (parent != null) {
            this.parent.registerResultSet(this);
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (this.scanResult.hasNext()) {
                this.actualValue = this.scanResult.next();
                return true;
            }
            this.actualValue = null;
            this.lastValue = null;
            return false;
        }
        catch (HDBException ex) {
            throw SQLExceptionUtils.wrapException(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        this.scanResult.close();
        if (this.parent != null) {
            this.parent.releaseResultSet(this);
        }
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private int resolveColumnIndexByName(String columnName) throws SQLException {
        return this.metadata.getColumnPosition(columnName);
    }

    @Override
    public String getString(String columnIndex) throws SQLException {
        return this.getString(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public boolean getBoolean(String columnIndex) throws SQLException {
        return this.getBoolean(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public byte getByte(String columnIndex) throws SQLException {
        return this.getByte(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public short getShort(String columnIndex) throws SQLException {
        return this.getShort(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public int getInt(String columnIndex) throws SQLException {
        return this.getInt(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public long getLong(String columnIndex) throws SQLException {
        return this.getLong(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public float getFloat(String columnIndex) throws SQLException {
        return this.getFloat(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public double getDouble(String columnIndex) throws SQLException {
        return this.getDouble(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(this.resolveColumnIndexByName(columnIndex), scale);
    }

    @Override
    public byte[] getBytes(String columnIndex) throws SQLException {
        return this.getBytes(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public Date getDate(String columnIndex) throws SQLException {
        return this.getDate(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public Time getTime(String columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Timestamp getTimestamp(String columnIndex) throws SQLException {
        return this.getTimestamp(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public InputStream getAsciiStream(String columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream getUnicodeStream(String columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream getBinaryStream(String columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getString(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            return this.lastValue.toString();
        }
        return null;
    }

    private void fillLastValue(int columnLabel) {
        this.lastValue = columnLabel <= 0 ? null : this.actualValue.get(columnLabel - 1);
    }

    private void ensureNextCalled() throws SQLException {
        if (this.actualValue == null) {
            throw new SQLException("please call next()");
        }
    }

    @Override
    public boolean getBoolean(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            this.wasNull = false;
            return Boolean.parseBoolean(this.lastValue.toString());
        }
        this.wasNull = true;
        return false;
    }

    @Override
    public byte getByte(int columnLabel) throws SQLException {
        return (byte)this.getInt(columnLabel);
    }

    @Override
    public short getShort(int columnLabel) throws SQLException {
        return (short)this.getInt(columnLabel);
    }

    @Override
    public int getInt(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            this.wasNull = false;
            if (this.lastValue instanceof Integer) {
                return (Integer)this.lastValue;
            }
            if (this.lastValue instanceof Number) {
                return ((Number)this.lastValue).intValue();
            }
            try {
                return Integer.parseInt(this.lastValue.toString());
            }
            catch (NumberFormatException err) {
                throw this.buildPrettyPrintConvertionError(columnLabel, "getInt", err);
            }
        }
        this.wasNull = true;
        return 0;
    }

    private SQLException buildPrettyPrintConvertionError(int columnLabel, String method, NumberFormatException err) throws SQLException {
        throw new SQLException("Value '" + this.lastValue + "' (" + this.lastValue.getClass() + ") cannot be converted to an integer value, call was " + method + "(" + columnLabel + "), column names: " + Arrays.asList(this.metadata.getColumnNames()), err);
    }

    @Override
    public long getLong(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            this.wasNull = false;
            if (this.lastValue instanceof Long) {
                return (Long)this.lastValue;
            }
            if (this.lastValue instanceof Number) {
                return ((Number)this.lastValue).longValue();
            }
            try {
                return Long.parseLong(this.lastValue.toString());
            }
            catch (NumberFormatException err) {
                throw this.buildPrettyPrintConvertionError(columnLabel, "getLong", err);
            }
        }
        this.wasNull = true;
        return 0L;
    }

    @Override
    public float getFloat(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            this.wasNull = false;
            if (this.lastValue instanceof Number) {
                return ((Number)this.lastValue).floatValue();
            }
            return Float.parseFloat(this.lastValue.toString());
        }
        this.wasNull = true;
        return 0.0f;
    }

    @Override
    public double getDouble(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            this.wasNull = false;
            if (this.lastValue instanceof Number) {
                return ((Number)this.lastValue).doubleValue();
            }
            return Double.parseDouble(this.lastValue.toString());
        }
        this.wasNull = true;
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnLabel, int scale) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] getBytes(int columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Date getDate(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            this.wasNull = false;
            if (this.lastValue instanceof Date) {
                return (Date)this.lastValue;
            }
            if (this.lastValue instanceof java.util.Date) {
                return new Date(((java.util.Date)this.lastValue).getTime());
            }
            try {
                return new Date(Long.parseLong(this.lastValue.toString()));
            }
            catch (NumberFormatException err) {
                throw this.buildPrettyPrintConvertionError(columnLabel, "getDate", err);
            }
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public Time getTime(int columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Timestamp getTimestamp(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            this.wasNull = false;
            if (this.lastValue instanceof Timestamp) {
                return (Timestamp)this.lastValue;
            }
            if (this.lastValue instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)this.lastValue).getTime());
            }
            try {
                return new Timestamp(Long.parseLong(this.lastValue.toString()));
            }
            catch (NumberFormatException err) {
                throw this.buildPrettyPrintConvertionError(columnLabel, "getTimestamp", err);
            }
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream getUnicodeStream(int columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream getBinaryStream(int columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(){

            @Override
            public int getColumnCount() throws SQLException {
                return HerdDBResultSet.this.metadata.getColumnNames().length;
            }

            @Override
            public boolean isAutoIncrement(int column) throws SQLException {
                return false;
            }

            @Override
            public boolean isCaseSensitive(int column) throws SQLException {
                return true;
            }

            @Override
            public boolean isSearchable(int column) throws SQLException {
                return true;
            }

            @Override
            public boolean isCurrency(int column) throws SQLException {
                return false;
            }

            @Override
            public int isNullable(int column) throws SQLException {
                return 1;
            }

            @Override
            public boolean isSigned(int column) throws SQLException {
                return true;
            }

            @Override
            public int getColumnDisplaySize(int column) throws SQLException {
                return 10;
            }

            @Override
            public String getColumnLabel(int column) throws SQLException {
                try {
                    return HerdDBResultSet.this.metadata.getColumnNames()[column - 1];
                }
                catch (ArrayIndexOutOfBoundsException err) {
                    throw new SQLException("not such index " + column, err);
                }
            }

            @Override
            public String getColumnName(int column) throws SQLException {
                try {
                    return HerdDBResultSet.this.metadata.getColumnNames()[column - 1];
                }
                catch (ArrayIndexOutOfBoundsException err) {
                    throw new SQLException("not such index " + column, err);
                }
            }

            @Override
            public String getSchemaName(int column) throws SQLException {
                return null;
            }

            @Override
            public int getPrecision(int column) throws SQLException {
                return 0;
            }

            @Override
            public int getScale(int column) throws SQLException {
                return 0;
            }

            @Override
            public String getTableName(int column) throws SQLException {
                return null;
            }

            @Override
            public String getCatalogName(int column) throws SQLException {
                return null;
            }

            @Override
            public int getColumnType(int column) throws SQLException {
                return 1111;
            }

            @Override
            public String getColumnTypeName(int column) throws SQLException {
                return null;
            }

            @Override
            public boolean isReadOnly(int column) throws SQLException {
                return true;
            }

            @Override
            public boolean isWritable(int column) throws SQLException {
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int column) throws SQLException {
                return false;
            }

            @Override
            public String getColumnClassName(int column) throws SQLException {
                return Object.class.getName();
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                return (T)this;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return iface.isInstance(this);
            }
        };
    }

    @Override
    public Object getObject(String columnIndex) throws SQLException {
        return this.getObject(this.resolveColumnIndexByName(columnIndex));
    }

    @Override
    public Object getObject(int columnLabel) throws SQLException {
        this.ensureNextCalled();
        this.fillLastValue(columnLabel);
        if (this.lastValue != null) {
            this.wasNull = false;
            if (this.lastValue instanceof RawString) {
                return this.lastValue.toString();
            }
            return this.lastValue;
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int index = this.metadata.getColumnPosition(columnLabel);
        if (index <= 0) {
            throw new SQLException("no such column " + columnLabel + ", only " + Arrays.toString(this.metadata.getColumnNames()));
        }
        return index;
    }

    @Override
    public Reader getCharacterStream(String columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getCharacterStream(int columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean first() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean last() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.parent.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnLabel);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T getObject(String columnIndex, Class<T> type) throws SQLException {
        return this.getObject(this.resolveColumnIndexByName(columnIndex), type);
    }

    @Override
    public <T> T getObject(int columnLabel, Class<T> type) throws SQLException {
        return (T)this.getObject(columnLabel);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    Long getId() {
        return this.id;
    }
}

