/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import herddb.client.ClientSideMetadataProvider;
import herddb.jdbc.BasicHerdDBDataSource;
import herddb.server.Server;
import herddb.server.ServerConfiguration;
import herddb.server.StaticClientSideMetadataProvider;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bookkeeper.stats.StatsLogger;

public class HerdDBEmbeddedDataSource
extends BasicHerdDBDataSource {
    private static final Logger LOGGER = Logger.getLogger(HerdDBEmbeddedDataSource.class.getName());
    private Server server;
    private StatsLogger statsLogger;
    private volatile boolean serverInitialized;
    private boolean startServer;

    public synchronized boolean isStartServer() {
        return this.startServer;
    }

    public synchronized void setStartServer(boolean startServer) {
        this.startServer = startServer;
    }

    public HerdDBEmbeddedDataSource() {
    }

    public HerdDBEmbeddedDataSource(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public synchronized Server getServer() {
        return this.server;
    }

    @Override
    protected synchronized void ensureClient() throws SQLException {
        super.ensureClient();
        this.startEmbeddedServer();
        this.doWaitForTableSpace();
    }

    private void startEmbeddedServer() throws SQLException {
        if (!this.serverInitialized) {
            ServerConfiguration serverConfiguration = new ServerConfiguration(this.properties);
            try {
                serverConfiguration.readJdbcUrl(this.url);
            }
            catch (RuntimeException err) {
                throw new SQLException(err);
            }
            this.startServer = serverConfiguration.getBoolean("server.start", this.startServer);
            String mode = serverConfiguration.getString("server.mode", "local");
            if ("local".equals(mode) || "standalone".equals(mode) && this.startServer || "cluster".equals(mode) && this.startServer) {
                LOGGER.log(Level.INFO, "Booting Local Embedded HerdDB mode, url:" + this.url + ", properties:" + serverConfiguration);
                this.server = new Server(serverConfiguration, this.statsLogger);
                try {
                    this.server.start();
                    int waitForTableSpaceTimeout = this.getWaitForTableSpaceTimeout();
                    if (waitForTableSpaceTimeout > 0) {
                        this.server.waitForBootOfLocalTablespaces(waitForTableSpaceTimeout);
                    }
                    if ("local".equals(mode) || "standalone".equals(mode)) {
                        this.client.setClientSideMetadataProvider((ClientSideMetadataProvider)new StaticClientSideMetadataProvider(this.server));
                    }
                }
                catch (Exception ex) {
                    throw new SQLException("Cannot boot embedded server " + ex, ex);
                }
            }
            this.serverInitialized = true;
        }
    }

    @Override
    public synchronized void close() {
        super.close();
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception err) {
                LOGGER.log(Level.SEVERE, "error during server shutdown:" + err, err);
            }
            this.server = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public synchronized StatsLogger getStatsLogger() {
        return this.statsLogger;
    }

    public synchronized void setStatsLogger(StatsLogger statsLogger) {
        this.statsLogger = statsLogger;
    }
}

